/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.cfd;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public static final String PREFIX = "cfd.configgui.";
        public final Tier tier1;
        public final Tier tier2;
        public final Tier tier3;
        public final Tier tier4;
        public final Tier tier5;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server configuration ssettings").push("server");
            this.tier1 = new Tier(builder, "1", 1, 40, 64, true);
            this.tier2 = new Tier(builder, "2", 1, 20, 128, true);
            this.tier3 = new Tier(builder, "3", 1, 10, 256, true);
            this.tier4 = new Tier(builder, "4", 1, 5, 512, true);
            this.tier5 = new Tier(builder, "5", 1, 1, 1024, true);
            builder.pop();
        }

        public static class Tier {
            public final ForgeConfigSpec.IntValue count;
            public final ForgeConfigSpec.IntValue interval;
            public final ForgeConfigSpec.IntValue max;
            public final ForgeConfigSpec.BooleanValue pushes;

            Tier(ForgeConfigSpec.Builder builder, String name, int count, int interval, int max, boolean pushes) {
                builder.comment("Tier: " + name).push(name);
                this.interval = builder.comment("The number of ticks between every generation update.").translation("cfd.configgui..tier_" + name + ".interval").worldRestart().defineInRange("interval", interval, 1, Integer.MAX_VALUE);
                this.count = builder.comment("The amount of items to generate every update.").translation("cfd.configgui..tier_" + name + ".count").worldRestart().defineInRange("count", count, 1, Integer.MAX_VALUE);
                this.max = builder.comment("The maximum amount of items to hold in the internal buffer.").translation("cfd.configgui..tier_" + name + ".max").worldRestart().defineInRange("max", max, 1, Integer.MAX_VALUE);
                this.pushes = builder.comment("Set to true to enable automatically pushing to inventories above this block.").translation("cfd.configgui..tier_" + name + ".can_push").define("pushes", pushes);
                builder.pop();
            }
        }
    }
}

