/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.impl.builders;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.shedaniel.forge.clothconfig2.gui.entries.TextListEntry;
import me.shedaniel.forge.clothconfig2.impl.builders.FieldBuilder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextDescriptionBuilder
extends FieldBuilder<String, TextListEntry> {
    private int color = -1;
    @Nullable
    private Supplier<Optional<String[]>> tooltipSupplier = null;
    private final String value;

    public TextDescriptionBuilder(String resetButtonKey, String fieldNameKey, String value) {
        super(resetButtonKey, fieldNameKey);
        this.value = value;
    }

    @Override
    public void requireRestart(boolean requireRestart) {
        throw new UnsupportedOperationException();
    }

    public TextDescriptionBuilder setTooltipSupplier(Supplier<Optional<String[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public TextDescriptionBuilder setTooltip(Optional<String[]> tooltip) {
        this.tooltipSupplier = () -> tooltip;
        return this;
    }

    public TextDescriptionBuilder setTooltip(String ... tooltip) {
        this.tooltipSupplier = () -> Optional.ofNullable(tooltip);
        return this;
    }

    public TextDescriptionBuilder setColor(int color) {
        this.color = color;
        return this;
    }

    @Override
    public TextListEntry build() {
        return new TextListEntry(this.getFieldNameKey(), this.value, this.color, this.tooltipSupplier);
    }
}

