/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.module;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;

@LoadModule(category=ModuleCategory.CLIENT)
public class GreenerGrassModule
extends Module {
    @Config
    public static boolean affectLeaves = true;
    @Config
    public static boolean alphaGrass = false;
    @Config
    public static boolean absoluteValues = false;
    @Config
    public static int redShift = -30;
    @Config
    public static int greenShift = 30;
    @Config
    public static int blueShift = -30;
    @Config
    public static List<String> blockList = Lists.newArrayList((Object[])new String[]{"minecraft:large_fern", "minecraft:tall_grass", "minecraft:grass_block", "minecraft:fern", "minecraft:grass", "minecraft:potted_fern", "minecraft:sugar_cane"});
    @Config
    public static List<String> leavesList = Lists.newArrayList((Object[])new String[]{"minecraft:spruce_leaves", "minecraft:birch_leaves", "minecraft:oak_leaves", "minecraft:jungle_leaves", "minecraft:acacia_leaves", "minecraft:dark_oak_leaves", "minecraft:vine"});

    @Override
    public void clientSetup() {
        this.registerGreenerColor(blockList, false);
        this.registerGreenerColor(leavesList, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerGreenerColor(Iterable<String> ids, boolean leaves) {
        BlockColors colors = Minecraft.func_71410_x().func_184125_al();
        Map map = (Map)ObfuscationReflectionHelper.getPrivateValue(BlockColors.class, (Object)colors, (String)"field_186725_a");
        for (String id : ids) {
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(id));
            if (b == null || b.delegate == null) {
                return;
            }
            IBlockColor color = (IBlockColor)map.get(b.delegate);
            if (color == null) continue;
            colors.func_186722_a(this.getGreenerColor(color, leaves), new Block[]{b});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private IBlockColor getGreenerColor(IBlockColor color, boolean leaves) {
        return (state, world, pos, tintIndex) -> {
            int shiftBlue;
            int originalColor = color.getColor(state, world, pos, tintIndex);
            if (!this.enabled || leaves && !affectLeaves) {
                return originalColor;
            }
            int r = originalColor >> 16 & 0xFF;
            int g = originalColor >> 8 & 0xFF;
            int b = originalColor & 0xFF;
            int shiftRed = alphaGrass ? 30 : redShift;
            int shiftGreen = alphaGrass ? 120 : greenShift;
            int n = shiftBlue = alphaGrass ? 30 : blueShift;
            if (absoluteValues) {
                return (Math.max(0, Math.min(255, redShift)) << 16) + Math.max(0, Math.min(255, greenShift) << 8) + Math.max(0, Math.min(255, blueShift));
            }
            return (Math.max(0, Math.min(255, r + shiftRed)) << 16) + Math.max(0, Math.min(255, g + shiftGreen) << 8) + Math.max(0, Math.min(255, b + shiftBlue));
        };
    }
}

