/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.world.config;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.ConfigFlagManager;
import vazkii.quark.base.module.IConfigType;

public class BiomeTypeConfig
implements IConfigType {
    @Config(name="Biome Types")
    @Config.Restriction(value={"HOT", "COLD", "SPARSE", "DENSE", "WET", "SAVANNA", "CONIFEROUS", "JUNGLE", "SPOOKY", "DEAD", "LUSH", "NETHER", "END", "MUSHROOM", "MAGICAL", "RARE", "OCEAN", "RIVER", "WATER", "MESA", "FOREST", "PLAINS", "MOUNTAIN", "HILLS", "SWAMP", "SANDY", "SNOWY", "WASTELAND", "BEACH", "VOID"})
    private List<String> typeStrings;
    @Config
    private boolean isBlacklist;
    private List<BiomeDictionary.Type> types;

    public BiomeTypeConfig(boolean isBlacklist, BiomeDictionary.Type ... types) {
        this.isBlacklist = isBlacklist;
        this.typeStrings = new LinkedList<String>();
        for (BiomeDictionary.Type s : types) {
            this.typeStrings.add(s.getName());
        }
    }

    public BiomeTypeConfig(boolean isBlacklist, String ... types) {
        this.isBlacklist = isBlacklist;
        this.typeStrings = new LinkedList<String>();
        this.typeStrings.addAll(Arrays.asList(types));
    }

    public boolean canSpawn(Biome b) {
        if (this.types == null) {
            this.updateTypes();
        }
        Set currentTypes = BiomeDictionary.getTypes((Biome)b);
        for (BiomeDictionary.Type type : this.types) {
            if (!currentTypes.contains(type)) continue;
            return !this.isBlacklist;
        }
        return this.isBlacklist;
    }

    @Override
    public void onReload(ConfigFlagManager flagManager) {
        this.updateTypes();
    }

    public void updateTypes() {
        this.types = new LinkedList<BiomeDictionary.Type>();
        for (String s : this.typeStrings) {
            BiomeDictionary.Type type = BiomeDictionary.Type.getType((String)s, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
            if (type == null) continue;
            this.types.add(type);
        }
    }
}

