/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.util;

import net.minecraft.util.Direction;

public enum RelativeSide {
    BACK,
    LEFT,
    RIGHT,
    TOP,
    BOTTOM,
    FRONT;

    private static final RelativeSide[] values;

    public static RelativeSide fromIndex(int i) {
        return values[Math.abs(i % values.length)];
    }

    public Direction toFacing(Direction baseFacing) {
        switch (this) {
            case FRONT: {
                return baseFacing;
            }
            case BACK: {
                return baseFacing.func_176734_d();
            }
            case LEFT: {
                if (baseFacing.func_176740_k() == Direction.Axis.Y) {
                    return Direction.EAST;
                }
                return baseFacing.func_176746_e();
            }
            case RIGHT: {
                if (baseFacing.func_176740_k() == Direction.Axis.Y) {
                    return Direction.WEST;
                }
                return baseFacing.func_176735_f();
            }
            case TOP: {
                if (baseFacing == Direction.UP) {
                    return Direction.SOUTH;
                }
                if (baseFacing == Direction.DOWN) {
                    return Direction.NORTH;
                }
                return Direction.UP;
            }
            case BOTTOM: {
                if (baseFacing == Direction.UP) {
                    return Direction.NORTH;
                }
                if (baseFacing == Direction.DOWN) {
                    return Direction.SOUTH;
                }
                return Direction.DOWN;
            }
        }
        return null;
    }

    static {
        values = RelativeSide.values();
    }
}

