/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.element;

import java.util.List;
import net.blay09.mods.refinedrelocation.client.gui.base.ITickableElement;
import net.blay09.mods.refinedrelocation.client.gui.base.ITooltipElement;
import net.blay09.mods.refinedrelocation.client.gui.base.element.SizableButton;
import net.blay09.mods.refinedrelocation.tile.TileBlockExtender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class GuiButtonStackLimiter
extends SizableButton
implements ITickableElement,
ITooltipElement {
    private final TileBlockExtender blockExtender;

    public GuiButtonStackLimiter(int x, int y, int width, int height, TileBlockExtender blockExtender) {
        super(x, y, width, height, "", it -> {});
        this.blockExtender = blockExtender;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.playDownSound(Minecraft.func_71410_x().func_147118_V());
            this.onClick(mouseX, mouseY, mouseButton);
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void onClick(double mouseX, double mouseY, int mouseButton) {
        int limit = this.blockExtender.getStackLimiterLimit();
        int index = (int)(Math.log(limit) / Math.log(2.0));
        int maxStackSize = Items.field_190931_a.getItemStackLimit(ItemStack.field_190927_a);
        int maxIndex = (int)(Math.log(maxStackSize) / Math.log(2.0));
        if (mouseButton == 0) {
            if (index < maxIndex) {
                ++index;
            }
        } else if (mouseButton == 1 && index > 0) {
            --index;
        }
        this.blockExtender.setStackLimiterLimit((int)Math.pow(2.0, index));
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        int limit = this.blockExtender.getStackLimiterLimit();
        if (delta > 0.0) {
            ++limit;
        } else if (delta < 0.0) {
            --limit;
        }
        limit = MathHelper.func_76125_a((int)limit, (int)1, (int)Items.field_190931_a.getItemStackLimit(ItemStack.field_190927_a));
        this.blockExtender.setStackLimiterLimit(limit);
        return true;
    }

    @Override
    public void tick() {
        this.setMessage(String.valueOf(this.blockExtender.getStackLimiterLimit()));
    }

    @Override
    public void addTooltip(List<String> list) {
        list.add(I18n.func_135052_a((String)"gui.refinedrelocation:block_extender.stack_limiter", (Object[])new Object[0]));
        list.add(TextFormatting.GREEN + I18n.func_135052_a((String)"gui.refinedrelocation:block_extender.stack_limiter_increase", (Object[])new Object[0]));
        list.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.refinedrelocation:block_extender.stack_limiter_decrease", (Object[])new Object[0]));
    }
}

