/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class TileEntityWindGenerator
extends TileEntityGenerator
implements IBoundingBlock {
    public static final float SPEED = 32.0f;
    public static final float SPEED_SCALED = 8.0f;
    private double angle;
    private FloatingLong currentMultiplier = FloatingLong.ZERO;
    private boolean isBlacklistDimension;
    private EnergyInventorySlot energySlot;

    public TileEntityWindGenerator() {
        super((IBlockProvider)GeneratorsBlocks.WIND_GENERATOR, ((FloatingLong)MekanismGeneratorsConfig.generators.windGenerationMax.get()).multiply(2L));
    }

    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityWindGenerator)this).getDirection());
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IMekanismInventory)this, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot);
        return builder.build();
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b != null) {
            this.isBlacklistDimension = ((List)MekanismGeneratorsConfig.generators.windGenerationDimBlacklist.get()).contains(this.field_145850_b.func_201675_m().func_186058_p().getRegistryName());
            if (this.isBlacklistDimension) {
                this.setActive(false);
            }
        }
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.drainContainer();
        if (this.isBlacklistDimension) {
            return;
        }
        if (this.ticker % 20 == 0) {
            this.currentMultiplier = this.getMultiplier();
            this.setActive(MekanismUtils.canFunction((TileEntity)this) && !this.currentMultiplier.isZero());
        }
        if (!this.currentMultiplier.isZero() && MekanismUtils.canFunction((TileEntity)this) && !this.getEnergyContainer().getNeeded().isZero()) {
            this.getEnergyContainer().insert(((FloatingLong)MekanismGeneratorsConfig.generators.windGenerationMin.get()).multiply(this.currentMultiplier), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    protected void onUpdateClient() {
        if (this.getActive()) {
            this.angle = (this.angle + (double)(((float)this.func_174877_v().func_177956_o() + 4.0f) / 8.0f)) % 360.0;
        }
    }

    private FloatingLong getMultiplier() {
        if (this.field_145850_b != null && this.field_145850_b.func_175710_j(this.func_174877_v().func_177981_b(4))) {
            int minY = MekanismGeneratorsConfig.generators.windGenerationMinY.get();
            int maxY = MekanismGeneratorsConfig.generators.windGenerationMaxY.get();
            float clampedY = Math.min(maxY, Math.max(minY, this.func_174877_v().func_177956_o() + 4));
            FloatingLong minG = (FloatingLong)MekanismGeneratorsConfig.generators.windGenerationMin.get();
            FloatingLong maxG = (FloatingLong)MekanismGeneratorsConfig.generators.windGenerationMax.get();
            FloatingLong slope = maxG.subtract(minG).divide((long)(maxY - minY));
            FloatingLong toGen = minG.add(slope.multiply((double)(clampedY - (float)minY)));
            return toGen.divide(minG);
        }
        return FloatingLong.ZERO;
    }

    public void onPlace() {
        if (this.field_145850_b != null) {
            BlockPos pos = this.func_174877_v();
            MekanismUtils.makeBoundingBlock((IWorld)this.field_145850_b, (BlockPos)pos.func_177984_a(), (BlockPos)pos);
            MekanismUtils.makeBoundingBlock((IWorld)this.field_145850_b, (BlockPos)pos.func_177981_b(2), (BlockPos)pos);
            MekanismUtils.makeBoundingBlock((IWorld)this.field_145850_b, (BlockPos)pos.func_177981_b(3), (BlockPos)pos);
            MekanismUtils.makeBoundingBlock((IWorld)this.field_145850_b, (BlockPos)pos.func_177981_b(4), (BlockPos)pos);
            this.isBlacklistDimension = ((List)MekanismGeneratorsConfig.generators.windGenerationDimBlacklist.get()).contains(this.field_145850_b.func_201675_m().func_186058_p().getRegistryName());
        }
    }

    public void onBreak() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177982_a(0, 1, 0), false);
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177982_a(0, 2, 0), false);
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177982_a(0, 3, 0), false);
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177982_a(0, 4, 0), false);
            this.field_145850_b.func_217377_a(this.func_174877_v(), false);
        }
    }

    public FloatingLong getCurrentMultiplier() {
        return this.currentMultiplier;
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean isBlacklistDimension() {
        return this.isBlacklistDimension;
    }

    public SoundCategory getSoundCategory() {
        return SoundCategory.WEATHER;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableFloatingLong.create(this::getCurrentMultiplier, value -> {
            this.currentMultiplier = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::isBlacklistDimension, value -> {
            this.isBlacklistDimension = value;
        }));
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-2, 0, -2), this.field_174879_c.func_177982_a(3, 7, 3));
    }
}

