/*
 * Decompiled with CFR 0.152.
 */
package jeresources.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jeresources.entry.DungeonEntry;
import jeresources.util.TranslationHelper;

public class DungeonRegistry {
    private Map<String, DungeonEntry> registry = new LinkedHashMap<String, DungeonEntry>();
    public static Map<String, String> categoryToLocalKeyMap = new LinkedHashMap<String, String>();
    private static DungeonRegistry instance;

    public static DungeonRegistry getInstance() {
        if (instance == null) {
            instance = new DungeonRegistry();
            return instance;
        }
        return instance;
    }

    public DungeonRegistry() {
        DungeonRegistry.addCategoryMapping("chests/abandoned_mineshaft", "jer.dungeon.abandonedMineshaftChest");
        DungeonRegistry.addCategoryMapping("chests/desert_pyramid", "jer.dungeon.desertPyramidChest");
        DungeonRegistry.addCategoryMapping("chests/jungle_temple", "jer.dungeon.pyramidJungleChest");
        DungeonRegistry.addCategoryMapping("chests/igloo_chest", "jer.dungeon.iglooChest");
        DungeonRegistry.addCategoryMapping("chests/stronghold_corridor", "jer.dungeon.strongholdCorridorChest");
        DungeonRegistry.addCategoryMapping("chests/stronghold_library", "jer.dungeon.strongholdLibraryChest");
        DungeonRegistry.addCategoryMapping("chests/stronghold_crossing", "jer.dungeon.strongholdCrossingChest");
        DungeonRegistry.addCategoryMapping("chests/village_blacksmith", "jer.dungeon.villageBlacksmithChest");
        DungeonRegistry.addCategoryMapping("chests/spawn_bonus_chest", "jer.dungeon.spawnBonusChest");
        DungeonRegistry.addCategoryMapping("chests/simple_dungeon", "jer.dungeon.simpleDungeonChest");
        DungeonRegistry.addCategoryMapping("chests/nether_bridge", "jer.dungeon.netherBridgeChest");
        DungeonRegistry.addCategoryMapping("chests/end_city_treasure", "jer.dungeon.endCityTreasureChest");
        DungeonRegistry.addCategoryMapping("chests/woodland_mansion", "jer.dungeon.woodlandMansion");
        DungeonRegistry.addCategoryMapping("chests/village/village_weaponsmith", "jer.dungeon.village_weaponsmith");
        DungeonRegistry.addCategoryMapping("chests/village/village_toolsmith", "jer.dungeon.village_toolsmith");
        DungeonRegistry.addCategoryMapping("chests/village/village_armorer", "jer.dungeon.village_armorer");
        DungeonRegistry.addCategoryMapping("chests/village/village_cartographer", "jer.dungeon.village_cartographer");
        DungeonRegistry.addCategoryMapping("chests/village/village_mason", "jer.dungeon.village_mason");
        DungeonRegistry.addCategoryMapping("chests/village/village_shepherd", "jer.dungeon.village_shepherd");
        DungeonRegistry.addCategoryMapping("chests/village/village_butcher", "jer.dungeon.village_butcher");
        DungeonRegistry.addCategoryMapping("chests/village/village_fletcher", "jer.dungeon.village_fletcher");
        DungeonRegistry.addCategoryMapping("chests/village/village_fisher", "jer.dungeon.village_fisher");
        DungeonRegistry.addCategoryMapping("chests/village/village_tannery", "jer.dungeon.village_tannery");
        DungeonRegistry.addCategoryMapping("chests/village/village_temple", "jer.dungeon.village_temple");
        DungeonRegistry.addCategoryMapping("chests/village/village_desert_house", "jer.dungeon.village_desert_house");
        DungeonRegistry.addCategoryMapping("chests/village/village_plains_house", "jer.dungeon.village_plains_house");
        DungeonRegistry.addCategoryMapping("chests/village/village_taiga_house", "jer.dungeon.village_taiga_house");
        DungeonRegistry.addCategoryMapping("chests/village/village_snowy_house", "jer.dungeon.village_snowy_house");
        DungeonRegistry.addCategoryMapping("chests/village/village_savanna_house", "jer.dungeon.village_savanna_house");
        DungeonRegistry.addCategoryMapping("chests/underwater_ruin_small", "jer.dungeon.underwater_ruin_small");
        DungeonRegistry.addCategoryMapping("chests/underwater_ruin_big", "jer.dungeon.underwater_ruin_big");
        DungeonRegistry.addCategoryMapping("chests/buried_treasure", "jer.dungeon.buried_treasure");
        DungeonRegistry.addCategoryMapping("chests/shipwreck_map", "jer.dungeon.shipwreck_map");
        DungeonRegistry.addCategoryMapping("chests/shipwreck_supply", "jer.dungeon.shipwreck_supply");
        DungeonRegistry.addCategoryMapping("chests/shipwreck_treasure", "jer.dungeon.shipwreck_treasure");
        DungeonRegistry.addCategoryMapping("chests/pillager_outpost", "jer.dungeon.pillager_outpost");
    }

    public static boolean addCategoryMapping(String category, String name) {
        if (!categoryToLocalKeyMap.containsKey(category)) {
            categoryToLocalKeyMap.put(category, name);
            return true;
        }
        return false;
    }

    public void registerDungeonEntry(DungeonEntry entry) {
        if (entry == null) {
            return;
        }
        String name = entry.getName();
        if (this.registry.containsKey(name)) {
            return;
        }
        this.registry.put(name, entry);
    }

    public List<DungeonEntry> getDungeons() {
        return new ArrayList<DungeonEntry>(this.registry.values());
    }

    public String getNumStacks(DungeonEntry entry) {
        int max = entry.getMaxStacks();
        int min = entry.getMinStacks();
        if (min == max) {
            return TranslationHelper.translateAndFormat("jer.stacks", max);
        }
        return TranslationHelper.translateAndFormat("jer.stacks", min + " - " + max);
    }

    public void clear() {
        this.registry.clear();
    }
}

