/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.util.HashMap;
import java.util.Map;
import jeresources.json.WorldGenAdapter;
import net.minecraft.command.ICommandSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.dimension.DimensionType;

public class ProfilingTimer {
    private final ICommandSource sender;
    private int totalChunks;
    private final Map<Integer, DimensionCounters> dimensionsMap = new HashMap<Integer, DimensionCounters>();

    public ProfilingTimer(ICommandSource sender, int chunkCount) {
        this.sender = sender;
        this.totalChunks = chunkCount;
    }

    public void startChunk(int dim) {
        DimensionCounters counters = this.dimensionsMap.get(dim);
        if (counters == null) {
            counters = new DimensionCounters();
            this.dimensionsMap.put(dim, counters);
            this.send("[" + ProfilingTimer.getDimensionName(dim) + "] Started profiling");
        }
        ++counters.threadCounter;
    }

    public void endChunk(int dim) {
        DimensionCounters counters = this.dimensionsMap.get(dim);
        --counters.threadCounter;
        if (++counters.chunkCounter % 100 == 0) {
            this.sendSpeed(dim);
        }
        if (this.totalChunks == counters.chunkCounter) {
            counters.completed = true;
        }
    }

    public void complete() {
        for (int dim : this.dimensionsMap.keySet()) {
            DimensionCounters counters = this.dimensionsMap.get(dim);
            counters.completed = true;
            this.send("[" + ProfilingTimer.getDimensionName(dim) + "] Completed profiling of " + this.getBlocksPerLayer(dim) * 256L + " blocks in " + (System.currentTimeMillis() - counters.start) + " ms saved to " + WorldGenAdapter.getWorldGenFile());
        }
    }

    public synchronized boolean isCompleted() {
        for (DimensionCounters counters : this.dimensionsMap.values()) {
            if (counters.completed) continue;
            return false;
        }
        return true;
    }

    private void send(String s) {
        this.sender.func_145747_a((ITextComponent)new TranslationTextComponent(s, new Object[0]));
    }

    private void sendSpeed(int dim) {
        DimensionCounters counters = this.dimensionsMap.get(dim);
        float time = (float)(System.currentTimeMillis() - counters.start) * 1.0f / (float)counters.chunkCounter;
        String message = "[" + ProfilingTimer.getDimensionName(dim) + "] Scanned " + counters.chunkCounter + " chunks at " + String.format("%3.2f", Float.valueOf(time)) + " ms/chunk";
        this.send(message);
    }

    public long getBlocksPerLayer(int dim) {
        DimensionCounters counters = this.dimensionsMap.get(dim);
        return counters.chunkCounter * 16 * 16;
    }

    private static String getDimensionName(int dim) {
        DimensionType dimensionType = DimensionType.func_186069_a((int)dim);
        if (dimensionType == null) {
            return "Dim " + dim;
        }
        return "Dim " + dim + ": " + dimensionType.getRegistryName();
    }

    private static class DimensionCounters {
        public final long start = System.currentTimeMillis();
        public int chunkCounter;
        public int threadCounter;
        public boolean completed;

        private DimensionCounters() {
        }
    }
}

