/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import edivad.dimstorage.tile.TileEntityDimTank;
import edivad.dimstorage.tools.utils.FluidUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class RenderTileDimTank
extends TileEntityRenderer<TileEntityDimTank> {
    private static final float TANK_THICKNESS = 0.1f;

    public RenderTileDimTank(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TileEntityDimTank tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tileEntityIn == null || tileEntityIn.func_145837_r() || tileEntityIn.liquidState.clientLiquid == null) {
            return;
        }
        matrixStackIn.func_227860_a_();
        this.renderFluid(tileEntityIn, matrixStackIn, bufferIn);
        matrixStackIn.func_227865_b_();
    }

    private void renderFluid(@Nonnull TileEntityDimTank tileEntity, MatrixStack matrix, IRenderTypeBuffer bufferIn) {
        FluidStack fluid = tileEntity.liquidState.clientLiquid;
        float scale = 0.84999996f * (float)fluid.getAmount() / 16000.0f;
        if (scale > 0.0f) {
            Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
            TextureAtlasSprite sprite = FluidUtils.getFluidTexture(fluid);
            if (sprite == null) {
                return;
            }
            IVertexBuilder renderer = bufferIn.getBuffer(RenderType.func_228658_l_((ResourceLocation)sprite.func_229241_m_().func_229223_g_()));
            float u1 = sprite.func_94209_e();
            float v1 = sprite.func_94206_g();
            float u2 = sprite.func_94212_f();
            float v2 = sprite.func_94210_h();
            float margin = 0.9f;
            float offset = 0.1f;
            int color = FluidUtils.getLiquidColorWithBiome(fluid, tileEntity);
            float r = FluidUtils.getRed(color);
            float g = FluidUtils.getGreen(color);
            float b = FluidUtils.getBlue(color);
            float a = FluidUtils.getAlpha(color);
            int light = 0xF000F0;
            renderer.func_227888_a_(matrix4f, 0.1f + offset, scale + 0.1f, 0.1f + offset).func_227885_a_(r, g, b, a).func_225583_a_(u1, v1).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, 0.1f + offset, scale + 0.1f, margin - 0.1f).func_227885_a_(r, g, b, a).func_225583_a_(u1, v2).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, margin - 0.1f, scale + 0.1f, margin - 0.1f).func_227885_a_(r, g, b, a).func_225583_a_(u2, v2).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, margin - 0.1f, scale + 0.1f, 0.1f + offset).func_227885_a_(r, g, b, a).func_225583_a_(u2, v1).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, margin - 0.1f, 0.1f, 0.1f + offset).func_227885_a_(r, g, b, a).func_225583_a_(u2, v1).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, margin - 0.1f, 0.1f, margin - 0.1f).func_227885_a_(r, g, b, a).func_225583_a_(u2, v2).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, 0.1f + offset, 0.1f, margin - 0.1f).func_227885_a_(r, g, b, a).func_225583_a_(u1, v2).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, 0.1f + offset, 0.1f, 0.1f + offset).func_227885_a_(r, g, b, a).func_225583_a_(u1, v1).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, 0.1f + offset, scale + 0.1f, margin - 0.1f).func_227885_a_(r, g, b, a).func_225583_a_(u1, v1).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, 0.1f + offset, 0.1f, margin - 0.1f).func_227885_a_(r, g, b, a).func_225583_a_(u1, v2).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, margin - 0.1f, 0.1f, margin - 0.1f).func_227885_a_(r, g, b, a).func_225583_a_(u2, v2).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, margin - 0.1f, scale + 0.1f, margin - 0.1f).func_227885_a_(r, g, b, a).func_225583_a_(u2, v1).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, margin - 0.1f, scale + 0.1f, 0.1f + offset).func_227885_a_(r, g, b, a).func_225583_a_(u2, v1).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, margin - 0.1f, 0.1f, 0.1f + offset).func_227885_a_(r, g, b, a).func_225583_a_(u2, v2).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, 0.1f + offset, 0.1f, 0.1f + offset).func_227885_a_(r, g, b, a).func_225583_a_(u1, v2).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, 0.1f + offset, scale + 0.1f, 0.1f + offset).func_227885_a_(r, g, b, a).func_225583_a_(u1, v1).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, margin - 0.1f, scale + 0.1f, margin - 0.1f).func_227885_a_(r, g, b, a).func_225583_a_(u2, v1).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, margin - 0.1f, 0.1f, margin - 0.1f).func_227885_a_(r, g, b, a).func_225583_a_(u2, v2).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, margin - 0.1f, 0.1f, 0.1f + offset).func_227885_a_(r, g, b, a).func_225583_a_(u1, v2).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, margin - 0.1f, scale + 0.1f, 0.1f + offset).func_227885_a_(r, g, b, a).func_225583_a_(u1, v1).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, 0.1f + offset, scale + 0.1f, 0.1f + offset).func_227885_a_(r, g, b, a).func_225583_a_(u1, v1).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, 0.1f + offset, 0.1f, 0.1f + offset).func_227885_a_(r, g, b, a).func_225583_a_(u1, v2).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, 0.1f + offset, 0.1f, margin - 0.1f).func_227885_a_(r, g, b, a).func_225583_a_(u2, v2).func_227886_a_(light).func_181675_d();
            renderer.func_227888_a_(matrix4f, 0.1f + offset, scale + 0.1f, margin - 0.1f).func_227885_a_(r, g, b, a).func_225583_a_(u2, v1).func_227886_a_(light).func_181675_d();
        }
    }
}

