/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.wireless;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lain.mods.wireless.ConfigOptions;
import lain.mods.wireless.TileEntityWirelessCharger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;

public class PowerManager {
    private static final Predicate<? super TileEntity> FILTER = tile -> {
        if (tile.func_145837_r()) {
            return false;
        }
        if (tile instanceof TileEntityWirelessCharger) {
            return !((TileEntityWirelessCharger)((Object)tile)).isDisabled();
        }
        return true;
    };
    private static final boolean fBaubles = Loader.isModLoaded((String)"baubles");
    int scanDelay = 0;
    final Set<TileEntity> loadedChargers = new HashSet<TileEntity>();
    final Map<EntityPlayerMP, Set<TileEntity>> nearbyChargers = new WeakHashMap<EntityPlayerMP, Set<TileEntity>>();

    private static final Stream<ItemStack> sInv(EntityPlayer player) {
        Stream<ItemStack> res = IntStream.range(0, player.field_71071_by.func_70302_i_()).mapToObj(arg_0 -> ((InventoryPlayer)player.field_71071_by).func_70301_a(arg_0));
        if (fBaubles) {
            try {
                IBaublesItemHandler bih = BaublesApi.getBaublesHandler((EntityPlayer)player);
                res = Stream.concat(res, IntStream.range(0, bih.getSlots()).mapToObj(arg_0 -> ((IBaublesItemHandler)bih).getStackInSlot(arg_0)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return res;
    }

    public void addCharger(TileEntity tileentity) {
        if (tileentity.hasCapability(CapabilityEnergy.ENERGY, null)) {
            this.loadedChargers.add(tileentity);
        }
    }

    public void clear() {
        this.scanDelay = 0;
        this.loadedChargers.clear();
        this.nearbyChargers.clear();
    }

    private void doCharge(EntityPlayerMP player, Collection<TileEntity> chargers) {
        if (chargers.isEmpty()) {
            return;
        }
        PowerManager.sInv((EntityPlayer)player).filter(s -> {
            if (s.func_190926_b() || ConfigOptions.BlacklistedItems.contains(s.func_77973_b().getRegistryName()) || !s.hasCapability(CapabilityEnergy.ENERGY, null)) {
                return false;
            }
            IEnergyStorage c = (IEnergyStorage)s.getCapability(CapabilityEnergy.ENERGY, null);
            return c != null && c.canReceive() && c.getMaxEnergyStored() > c.getEnergyStored();
        }).map(s -> (IEnergyStorage)s.getCapability(CapabilityEnergy.ENERGY, null)).forEachOrdered(cStack -> {
            int needed = cStack.getMaxEnergyStored() - cStack.getEnergyStored();
            int available = chargers.stream().filter(FILTER).mapToInt(c -> ((IEnergyStorage)c.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(needed, true)).sum();
            int drain = Math.max(Math.min(available / chargers.size(), cStack.receiveEnergy(needed, true) / chargers.size()), 1);
            chargers.stream().filter(FILTER).forEach(c -> cStack.receiveEnergy(((IEnergyStorage)c.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(drain, false), false));
        });
    }

    private void doScan() {
        int sqRange = ConfigOptions.Range * ConfigOptions.Range;
        this.nearbyChargers.clear();
        this.getChargers().stream().filter(FILTER).forEach(c -> {
            TileEntityWirelessCharger t;
            boolean handled = false;
            if (c instanceof TileEntityWirelessCharger && (t = (TileEntityWirelessCharger)((Object)c)).isUpgraded()) {
                handled = true;
                EntityPlayerMP p2 = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(t.getTargetUser());
                if (p2 != null) {
                    Set<TileEntity> s = this.nearbyChargers.get(p2);
                    if (s == null) {
                        s = new HashSet<TileEntity>();
                        this.nearbyChargers.put(p2, s);
                    }
                    s.add((TileEntity)c);
                }
            }
            if (!handled) {
                c.func_145831_w().func_175661_b(EntityPlayerMP.class, p -> p.func_174831_c(c.func_174877_v()) <= (double)sqRange).forEach(p -> {
                    Set<TileEntity> s = this.nearbyChargers.get(p);
                    if (s == null) {
                        s = new HashSet<TileEntity>();
                        this.nearbyChargers.put((EntityPlayerMP)p, s);
                    }
                    s.add((TileEntity)c);
                });
            }
        });
    }

    public Collection<TileEntity> getChargers() {
        return Collections.unmodifiableSet(this.loadedChargers);
    }

    public Collection<TileEntity> getChargersInRange(EntityPlayerMP player) {
        if (this.nearbyChargers.containsKey(player)) {
            return Collections.unmodifiableSet(this.nearbyChargers.get(player));
        }
        return Collections.emptyList();
    }

    public void removeCharger(TileEntity tileentity) {
        this.loadedChargers.remove(tileentity);
    }

    public void updateChargers() {
        this.updateChargers(false);
    }

    public void updateChargers(boolean force) {
        if (force || ++this.scanDelay == 20) {
            this.scanDelay = 0;
            this.doScan();
        }
    }

    public void updatePlayer(EntityPlayerMP player) {
        if (player.func_70089_S()) {
            this.doCharge(player, this.getChargersInRange(player));
        }
    }
}

