/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.fastener;

import com.pau101.fairylights.server.fastener.FastenerEntity;
import com.pau101.fairylights.server.fastener.accessor.FastenerAccessorPlayer;
import com.pau101.fairylights.server.fastener.connection.type.Connection;
import com.pau101.fairylights.server.item.ItemConnection;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public final class FastenerPlayer
extends FastenerEntity<EntityPlayer> {
    public FastenerPlayer(EntityPlayer entity) {
        super(entity);
    }

    @Override
    public Vec3d getConnectionPoint() {
        double dy;
        double forwardDist;
        Vec3d point = super.getConnectionPoint();
        if (((EntityPlayer)this.entity).func_184613_cA()) {
            return point;
        }
        double angle = (((EntityPlayer)this.entity).field_70761_aq - 90.0f) * ((float)Math.PI / 180);
        double perpAngle = angle - 1.5707963267948966;
        boolean sneaking = ((EntityPlayer)this.entity).func_70093_af();
        double perpDist = 0.4 * (double)(this.matchesStack(((EntityPlayer)this.entity).func_184614_ca()) ? 1 : -1);
        if (sneaking) {
            forwardDist = 0.0;
            dy = 0.6;
        } else {
            forwardDist = 0.2;
            dy = 0.8;
        }
        double dx = Math.cos(perpAngle) * perpDist - Math.cos(angle) * forwardDist;
        double dz = Math.sin(perpAngle) * perpDist - Math.sin(angle) * forwardDist;
        return point.func_72441_c(dx, dy, dz);
    }

    @Override
    public boolean shouldDropConnection() {
        return false;
    }

    @Override
    public boolean isMoving() {
        return true;
    }

    @Override
    public boolean update() {
        if (!(this.hasNoConnections() || this.matchesStack(((EntityPlayer)this.entity).func_184614_ca()) || this.matchesStack(((EntityPlayer)this.entity).func_184592_cb()))) {
            Iterator entries = this.connections.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                entries.remove();
                Connection connection = (Connection)entry.getValue();
                if (!connection.getDestination().isLoaded(this.getWorld())) continue;
                connection.getDestination().get(this.getWorld()).removeConnection((UUID)entry.getKey());
            }
        }
        return super.update();
    }

    public boolean matchesStack(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemConnection)) {
            return false;
        }
        if (!((ItemConnection)stack.func_77973_b()).getConnectionType().isConnectionThis(this.getFirstConnection())) {
            return false;
        }
        return !stack.func_77942_o() || NBTUtil.func_181123_a((NBTBase)this.getFirstConnection().serializeLogic(), (NBTBase)stack.func_77978_p(), (boolean)true);
    }

    @Override
    public void resistSnap(Vec3d from) {
        double dist = this.getConnectionPoint().func_72438_d(from);
        if (dist > 32.0) {
            double arcX;
            double arcY;
            double arcZ;
            double dx = ((EntityPlayer)this.entity).field_70165_t - from.field_72450_a;
            double dy = ((EntityPlayer)this.entity).field_70163_u - from.field_72448_b;
            double dz = ((EntityPlayer)this.entity).field_70161_v - from.field_72449_c;
            double vectorX = dx / dist;
            double vectorY = dy / dist;
            double vectorZ = dz / dist;
            double factor = Math.min((dist - 32.0) / 5.0, 5.0);
            double tangent = Math.cos(MathHelper.func_181159_b((double)dy, (double)Math.sqrt(dx * dx + dz * dz))) * Math.signum(((EntityPlayer)this.entity).field_70181_x);
            double speed = Math.sqrt(((EntityPlayer)this.entity).field_70159_w * ((EntityPlayer)this.entity).field_70159_w + ((EntityPlayer)this.entity).field_70181_x * ((EntityPlayer)this.entity).field_70181_x + ((EntityPlayer)this.entity).field_70179_y * ((EntityPlayer)this.entity).field_70179_y);
            double swing = Math.abs(speed) < 1.0E-6 ? 0.0 : (1.0 - Math.abs(((EntityPlayer)this.entity).field_70181_x / speed - tangent)) * 0.1;
            double mag = Math.sqrt(((EntityPlayer)this.entity).field_70159_w * ((EntityPlayer)this.entity).field_70159_w + tangent * tangent + ((EntityPlayer)this.entity).field_70179_y * ((EntityPlayer)this.entity).field_70179_y);
            if (dy > 0.0 || Math.abs(mag) < 1.0E-6) {
                arcZ = 0.0;
                arcY = 0.0;
                arcX = 0.0;
            } else {
                arcX = ((EntityPlayer)this.entity).field_70159_w / mag * swing;
                arcY = tangent / mag * swing;
                arcZ = ((EntityPlayer)this.entity).field_70179_y / mag * swing;
            }
            ((EntityPlayer)this.entity).field_70159_w += vectorX * -Math.abs(vectorX) * factor + arcX;
            ((EntityPlayer)this.entity).field_70181_x += vectorY * -Math.abs(vectorY) * factor + arcY;
            ((EntityPlayer)this.entity).field_70179_y += vectorZ * -Math.abs(vectorZ) * factor + arcZ;
            ((EntityPlayer)this.entity).field_70143_R = 0.0f;
            if (this.entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)this.entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(this.entity));
            }
        }
    }

    @Override
    public FastenerAccessorPlayer createAccessor() {
        return new FastenerAccessorPlayer(this);
    }
}

