/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.renderer;

import com.pau101.fairylights.client.model.connection.ModelConnection;
import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.fastener.connection.Catenary;
import com.pau101.fairylights.server.fastener.connection.ConnectionType;
import com.pau101.fairylights.server.fastener.connection.type.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class FastenerRenderer {
    public static final ResourceLocation TEXTURE = new ResourceLocation("fairylights", "textures/entity/connections.png");
    public static final int TEXTURE_WIDTH = 128;
    public static final int TEXTURE_HEIGHT = 128;
    private static final ModelConnection[] CONNECTION_RENDERERS;

    private FastenerRenderer() {
    }

    public static void render(Fastener<?> fastener, float delta) {
        World world = fastener.getWorld();
        List<Connection> connections = FastenerRenderer.removeUnnecessaryConnections(fastener.getConnections().values(), world);
        GlStateManager.func_179091_B();
        GlStateManager.func_179084_k();
        GlStateManager.func_179094_E();
        if (Minecraft.func_71410_x().func_175598_ae().func_178634_b() && !Minecraft.func_71410_x().func_189648_am()) {
            FastenerRenderer.renderBoundingBox(fastener);
        }
        int blockBrightness = fastener.getWorld().func_175626_b(fastener.getPos(), 0);
        int skylight = blockBrightness % 65536;
        int moonlight = blockBrightness / 65536;
        boolean shouldRenderBow = true;
        class TexturedRender {
            Connection connection;
            ModelConnection renderer;

            TexturedRender(Connection connection, ModelConnection renderer) {
                this.connection = connection;
                this.renderer = renderer;
            }
        }
        ArrayList<TexturedRender> texturedRenders = new ArrayList<TexturedRender>();
        for (Connection connection : connections) {
            if (connection.isOrigin()) {
                ModelConnection renderer = CONNECTION_RENDERERS[connection.getType().ordinal()];
                renderer.render(fastener, connection, world, skylight, moonlight, delta);
                if (renderer.hasTexturedRender()) {
                    texturedRenders.add(new TexturedRender(connection, renderer));
                }
            }
            if (connection.getType() != ConnectionType.GARLAND || !shouldRenderBow) continue;
            FastenerRenderer.renderBow(fastener, connections, delta);
            shouldRenderBow = false;
        }
        TextureManager texturer = Minecraft.func_71410_x().func_110434_K();
        for (TexturedRender render : texturedRenders) {
            ResourceLocation tex = render.renderer.getAlternateTexture();
            if (tex != null) {
                texturer.func_110577_a(tex);
            }
            render.renderer.renderTexturePass(fastener, render.connection, world, skylight, moonlight, delta);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderBoundingBox(Fastener<?> fastener) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187441_d((float)2.0f);
        Vec3d offset = fastener.getConnectionPoint();
        RenderGlobal.func_189697_a((AxisAlignedBB)fastener.getBounds().func_72317_d(-offset.field_72450_a, -offset.field_72448_b, -offset.field_72449_c), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
    }

    private static void renderBow(Fastener fastener, Collection<Connection> connections, float delta) {
        EnumFacing facing = fastener.getFacing();
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            return;
        }
        Vec3d fastenerDir = new Vec3d(facing.func_176730_m());
        float yaw = (float)(-MathHelper.func_181159_b((double)fastenerDir.field_72449_c, (double)fastenerDir.field_72450_a)) - 1.5707964f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(fastenerDir.field_72450_a * 1.5 / 16.0), (double)0.0, (double)(fastenerDir.field_72449_c * 1.5 / 16.0));
        GlStateManager.func_179114_b((float)(yaw * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5625f, (float)-0.375f, (float)-0.03125f);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)2.5f);
        FastenerRenderer.render3DTexture(18, 12, 0, 72);
        GlStateManager.func_179121_F();
    }

    private static List<Connection> removeUnnecessaryConnections(Collection<Connection> connections, World world) {
        ArrayList<Connection> visibleConnections = new ArrayList<Connection>();
        for (Connection connection : connections) {
            Catenary catenary = connection.getCatenary();
            if (catenary == null || !connection.getDestination().isLoaded(world)) continue;
            visibleConnections.add(connection);
        }
        return visibleConnections;
    }

    public static void render3DTexture(int width, int height, int u, int v) {
        FastenerRenderer.render3DTexture(width, height, u, v, 128, 128);
    }

    public static void render3DTexture(int width, int height, int u, int v, int texWidth, int texHeight) {
        float vi;
        float ui;
        int p;
        float u1 = (float)u / (float)texWidth;
        float u2 = (float)(u + width) / (float)texWidth;
        float v1 = (float)v / (float)texHeight;
        float v2 = (float)(v + height) / (float)texHeight;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)((float)width / 16.0f), (float)((float)height / 16.0f), (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder render = tessellator.func_178180_c();
        float depth = 0.0625f;
        render.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)1.0f);
        render.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)u1, (double)v2).func_181675_d();
        render.func_181662_b(1.0, 0.0, 0.0).func_187315_a((double)u2, (double)v2).func_181675_d();
        render.func_181662_b(1.0, 1.0, 0.0).func_187315_a((double)u2, (double)v1).func_181675_d();
        render.func_181662_b(0.0, 1.0, 0.0).func_187315_a((double)u1, (double)v1).func_181675_d();
        tessellator.func_78381_a();
        render.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)-1.0f);
        render.func_181662_b(0.0, 1.0, (double)(-depth)).func_187315_a((double)u1, (double)v1).func_181675_d();
        render.func_181662_b(1.0, 1.0, (double)(-depth)).func_187315_a((double)u2, (double)v1).func_181675_d();
        render.func_181662_b(1.0, 0.0, (double)(-depth)).func_187315_a((double)u2, (double)v2).func_181675_d();
        render.func_181662_b(0.0, 0.0, (double)(-depth)).func_187315_a((double)u1, (double)v2).func_181675_d();
        tessellator.func_78381_a();
        float widthStretch = 0.5f * (u1 - u2) / (float)width;
        float heightStretch = 0.5f * (v2 - v1) / (float)height;
        render.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GlStateManager.func_187432_a((float)1.0f, (float)0.0f, (float)0.0f);
        for (p = 0; p < width; ++p) {
            float x = (float)p / (float)width;
            ui = u1 + (u2 - u1) * x - widthStretch;
            render.func_181662_b((double)x, 0.0, (double)(-depth)).func_187315_a((double)ui, (double)v2).func_181675_d();
            render.func_181662_b((double)x, 0.0, 0.0).func_187315_a((double)ui, (double)v2).func_181675_d();
            render.func_181662_b((double)x, 1.0, 0.0).func_187315_a((double)ui, (double)v1).func_181675_d();
            render.func_181662_b((double)x, 1.0, (double)(-depth)).func_187315_a((double)ui, (double)v1).func_181675_d();
        }
        tessellator.func_78381_a();
        render.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GlStateManager.func_187432_a((float)-1.0f, (float)0.0f, (float)0.0f);
        for (p = 0; p < width; ++p) {
            float xi = (float)p / (float)width;
            ui = u1 + (u2 - u1) * xi - widthStretch;
            float x = xi + 1.0f / (float)width;
            render.func_181662_b((double)x, 1.0, (double)(-depth)).func_187315_a((double)ui, (double)v1).func_181675_d();
            render.func_181662_b((double)x, 1.0, 0.0).func_187315_a((double)ui, (double)v1).func_181675_d();
            render.func_181662_b((double)x, 0.0, 0.0).func_187315_a((double)ui, (double)v2).func_181675_d();
            render.func_181662_b((double)x, 0.0, (double)(-depth)).func_187315_a((double)ui, (double)v2).func_181675_d();
        }
        tessellator.func_78381_a();
        render.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        for (p = 0; p < height; ++p) {
            float yi = (float)p / (float)height;
            vi = v2 + (v1 - v2) * yi - heightStretch;
            float y = yi + 1.0f / (float)height;
            render.func_181662_b(0.0, (double)y, 0.0).func_187315_a((double)u1, (double)vi).func_181675_d();
            render.func_181662_b(1.0, (double)y, 0.0).func_187315_a((double)u2, (double)vi).func_181675_d();
            render.func_181662_b(1.0, (double)y, (double)(-depth)).func_187315_a((double)u2, (double)vi).func_181675_d();
            render.func_181662_b(0.0, (double)y, (double)(-depth)).func_187315_a((double)u1, (double)vi).func_181675_d();
        }
        tessellator.func_78381_a();
        render.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GlStateManager.func_187432_a((float)0.0f, (float)-1.0f, (float)0.0f);
        for (p = 0; p < height; ++p) {
            float y = (float)p / (float)height;
            vi = v2 + (v1 - v2) * y - heightStretch;
            render.func_181662_b(1.0, (double)y, 0.0).func_187315_a((double)u2, (double)vi).func_181675_d();
            render.func_181662_b(0.0, (double)y, 0.0).func_187315_a((double)u1, (double)vi).func_181675_d();
            render.func_181662_b(0.0, (double)y, (double)(-depth)).func_187315_a((double)u1, (double)vi).func_181675_d();
            render.func_181662_b(1.0, (double)y, (double)(-depth)).func_187315_a((double)u2, (double)vi).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    static {
        ConnectionType[] types = ConnectionType.values();
        CONNECTION_RENDERERS = new ModelConnection[types.length];
        for (int i = 0; i < types.length; ++i) {
            FastenerRenderer.CONNECTION_RENDERERS[i] = types[i].createRenderer();
        }
    }
}

