/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.entity;

import com.google.common.base.Optional;
import com.rwtema.careerbees.ClientFunction;
import com.rwtema.careerbees.effects.ISpecialBeeEffect;
import com.rwtema.careerbees.entity.ParticleBeeSwarm;
import com.rwtema.careerbees.helpers.NBTSerializer;
import com.rwtema.careerbees.items.ItemBeeGun;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBeeSwarm
extends Entity
implements IProjectile {
    public static final ISpecialBeeEffect NONE = new ISpecialBeeEffect(){

        @Override
        public float getCooldown(IBeeGenome genome, Random random) {
            return 0.0f;
        }
    };
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(EntityBeeSwarm.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Optional<BlockPos>> POS = EntityDataManager.func_187226_a(EntityBeeSwarm.class, (DataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Integer> ENTITY_ID = EntityDataManager.func_187226_a(EntityBeeSwarm.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final ClientFunction<EntityBeeSwarm, Void> ticker = new ClientFunction<EntityBeeSwarm, Void>(){

        @Override
        public Void applyServer(EntityBeeSwarm entityBeeSwarm) {
            return null;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Void applyClient(EntityBeeSwarm entityBeeSwarm) {
            entityBeeSwarm.tickClient();
            return null;
        }
    };
    ISpecialBeeEffect cache;
    IAlleleBeeSpecies cacheSpecies;
    IBeeGenome cacheGenome;
    EnumFacing facing = null;
    @Nullable
    Entity owner;
    int buzzingTime = 0;
    int searchingTime = 0;
    private static NBTSerializer<EntityBeeSwarm> serializer = NBTSerializer.getEntitySeializer(EntityBeeSwarm.class).addInt("BuzzingTime", e -> e.buzzingTime, (e, v) -> {
        e.buzzingTime = v;
    }).addInt("SearchTime", e -> e.searchingTime, (e, v) -> {
        e.searchingTime = v;
    }).addByte("Facing", e -> e.facing != null ? (byte)e.facing.ordinal() : (byte)6, (e, v) -> {
        e.facing = v == 6 ? null : EnumFacing.values()[v];
    }).addDataManagerKey("Entity", ENTITY_ID, NBTSerializer::addInteger).addDataManagerKey("Item", ITEM, NBTSerializer::addItemStack).addDataManagerKey("Pos", POS, NBTSerializer::addOptionalBlockPos);
    @SideOnly(value=Side.CLIENT)
    ParticleBeeSwarm[] particles;

    public EntityBeeSwarm(@Nonnull World worldIn) {
        super(worldIn);
        this.func_70105_a(0.1f, 0.1f);
        this.field_70145_X = true;
    }

    public EntityBeeSwarm(@Nonnull World worldIn, @Nonnull ItemStack stack, @Nonnull Entity owner) {
        this(worldIn);
        this.owner = owner;
        this.func_70107_b(owner.field_70165_t, owner.field_70163_u + (double)owner.func_70047_e() - (double)0.1f, owner.field_70161_v);
        this.setItem(stack.func_77946_l());
    }

    protected void func_70088_a() {
        EntityDataManager dataManager = this.func_184212_Q();
        dataManager.func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
        dataManager.func_187214_a(POS, (Object)Optional.absent());
        dataManager.func_187214_a(ENTITY_ID, (Object)-1);
    }

    public Optional<BlockPos> getTargetPos() {
        return (Optional)this.func_184212_Q().func_187225_a(POS);
    }

    public Optional<Entity> getTargetEntity() {
        int integer = (Integer)this.func_184212_Q().func_187225_a(ENTITY_ID);
        if (integer == -1) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)this.field_70170_p.func_73045_a(integer));
    }

    @Nonnull
    public ItemStack getItem() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
    }

    public void setItem(@Nonnull ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM, (Object)stack);
        this.func_184212_Q().func_187217_b(ITEM);
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
        serializer.readFromNBT(this, compound);
        if (this.getItem().func_190926_b()) {
            this.func_70106_y();
        }
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
        serializer.writeToNBT(this, compound);
    }

    public void setAim(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += shooter.field_70159_w;
        this.field_70179_y += shooter.field_70179_y;
        if (!shooter.field_70122_E) {
            this.field_70181_x += shooter.field_70181_x;
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key == ITEM) {
            this.cache = null;
            this.cacheSpecies = null;
            this.cacheGenome = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void tickClient() {
        Entity entityByID;
        if (this.particles == null) {
            this.particles = new ParticleBeeSwarm[8];
        }
        for (int i = 0; i < this.particles.length; ++i) {
            if (this.particles[i] != null && this.particles[i].func_187113_k()) continue;
            this.particles[i] = new ParticleBeeSwarm(this.field_70170_p, this);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)this.particles[i]);
        }
        int id = (Integer)this.func_184212_Q().func_187225_a(ENTITY_ID);
        if (id != -1 && (entityByID = this.field_70170_p.func_73045_a(id)) != null) {
            this.func_70107_b(entityByID.field_70165_t, entityByID.field_70163_u, entityByID.field_70161_v);
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            return;
        }
        Optional blockPosOptional = (Optional)this.func_184212_Q().func_187225_a(POS);
        if (blockPosOptional.isPresent()) {
            BlockPos pos = (BlockPos)blockPosOptional.get();
            this.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            return;
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_70071_h_() {
        ISpecialBeeEffect.SpecialEffectItem effectItem;
        ISpecialBeeEffect.SpecialEffectEntity effectEntity;
        Entity closest;
        super.func_70071_h_();
        ISpecialBeeEffect effect = this.getEffect();
        if (effect == NONE) {
            this.func_70106_y();
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            ticker.apply(this);
            return;
        }
        IBee member = BeeManager.beeRoot.getMember(this.getItem());
        if (member == null) {
            this.func_70106_y();
            return;
        }
        IBeeGenome genome = member.getGenome();
        int id = (Integer)this.func_184212_Q().func_187225_a(ENTITY_ID);
        if (id != -1) {
            ++this.buzzingTime;
            Entity entityByID = this.field_70170_p.func_73045_a(id);
            if (entityByID != null && !entityByID.field_70128_L) {
                if ((entityByID.func_70090_H() || this.field_70170_p.func_175727_C(new BlockPos(entityByID))) && !genome.getToleratesRain()) {
                    this.func_70106_y();
                    return;
                }
                this.func_70107_b(entityByID.field_70165_t, entityByID.field_70163_u, entityByID.field_70161_v);
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                if (effect instanceof ISpecialBeeEffect.SpecialEffectEntity) {
                    ISpecialBeeEffect.SpecialEffectEntity effectEntity2 = (ISpecialBeeEffect.SpecialEffectEntity)effect;
                    if (!effectEntity2.canHandleEntity(entityByID, genome)) {
                        this.func_70106_y();
                        return;
                    }
                    ItemBeeGun.FakeHousingPlayer housing = new ItemBeeGun.FakeHousingPlayer(this, new BlockPos(entityByID), this.getItem());
                    effectEntity2.processingTick(entityByID, genome, housing);
                    if (!((float)this.buzzingTime > effectEntity2.getCooldown(entityByID, genome, this.field_70146_Z))) return;
                    effectEntity2.handleEntityLiving(entityByID, genome, housing);
                    this.func_70106_y();
                    return;
                }
                if (effect instanceof ISpecialBeeEffect.SpecialEffectItem && entityByID instanceof EntityItem) {
                    ISpecialBeeEffect.SpecialEffectItem effectItem2 = (ISpecialBeeEffect.SpecialEffectItem)effect;
                    ItemStack item = ((EntityItem)entityByID).func_92059_d();
                    if (!effectItem2.canHandleStack(item, genome)) {
                        this.func_70106_y();
                        return;
                    }
                    if (!((float)this.buzzingTime > effect.getCooldown(genome, this.field_70146_Z))) return;
                    ItemStack newItem = effectItem2.handleStack(item, genome, new ItemBeeGun.FakeHousingPlayer(this, new BlockPos(entityByID), this.getItem()));
                    if (newItem != null) {
                        ((EntityItem)entityByID).func_92058_a(newItem.func_77946_l());
                    }
                    this.func_70106_y();
                    return;
                }
                this.func_70106_y();
                return;
            }
            this.func_70106_y();
            return;
        }
        Optional blockPosOptional = (Optional)this.func_184212_Q().func_187225_a(POS);
        if (blockPosOptional.isPresent()) {
            ++this.buzzingTime;
            BlockPos pos = (BlockPos)blockPosOptional.get();
            this.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            if (!(effect instanceof ISpecialBeeEffect.SpecialEffectBlock)) {
                this.func_70106_y();
                return;
            }
            ISpecialBeeEffect.SpecialEffectBlock effectBlock = (ISpecialBeeEffect.SpecialEffectBlock)effect;
            if (!effectBlock.canHandleBlock(this.field_70170_p, pos, genome, this.facing)) {
                this.func_70106_y();
                return;
            }
            ItemBeeGun.FakeHousingPlayer housing = new ItemBeeGun.FakeHousingPlayer(this, pos, this.getItem());
            effectBlock.processingTick(this.field_70170_p, pos, genome, housing, this.facing);
            if (!((float)this.buzzingTime > effectBlock.getCooldown(this.field_70170_p, pos, genome, this.facing, this.field_70170_p.field_73012_v))) return;
            effectBlock.handleBlock(this.field_70170_p, pos, this.facing, genome, housing);
            this.func_70106_y();
            return;
        }
        ++this.searchingTime;
        if (this.searchingTime > 2 * genome.getLifespan()) {
            this.func_70106_y();
            return;
        }
        if ((this.func_70090_H() || this.field_70170_p.func_175727_C(new BlockPos((Entity)this))) && !genome.getToleratesRain()) {
            this.func_70106_y();
            return;
        }
        Vec3d start = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d end = start.func_72441_c(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        RayTraceResult trace = this.field_70170_p.func_147447_a(start, end, false, true, false);
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c);
        if (this.owner != null && (this.owner.field_70128_L || !this.owner.func_174813_aQ().func_186662_g(0.5).func_72326_a(axisAlignedBB))) {
            this.owner = null;
        }
        if (effect instanceof ISpecialBeeEffect.SpecialEffectEntity && (closest = this.getClosestEntityType(this.field_70170_p, start, end, axisAlignedBB, Entity.class, arg_0 -> this.lambda$onUpdate$6(effectEntity = (ISpecialBeeEffect.SpecialEffectEntity)effect, genome, arg_0))) != null) {
            this.func_184212_Q().func_187227_b(ENTITY_ID, (Object)closest.func_145782_y());
            this.func_184212_Q().func_187217_b(ENTITY_ID);
            return;
        }
        if (effect instanceof ISpecialBeeEffect.SpecialEffectItem && (closest = this.getClosestEntityType(this.field_70170_p, start, end, axisAlignedBB, EntityItem.class, arg_0 -> this.lambda$onUpdate$7(effectItem = (ISpecialBeeEffect.SpecialEffectItem)effect, genome, arg_0))) != null) {
            this.func_184212_Q().func_187227_b(ENTITY_ID, (Object)closest.func_145782_y());
            this.func_184212_Q().func_187217_b(ENTITY_ID);
            return;
        }
        if (trace == null) {
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            return;
        }
        BlockPos pos = trace.func_178782_a();
        if (!(effect instanceof ISpecialBeeEffect.SpecialEffectBlock)) {
            this.func_70106_y();
            return;
        }
        ISpecialBeeEffect.SpecialEffectBlock effectBlock = (ISpecialBeeEffect.SpecialEffectBlock)effect;
        if (effectBlock.canHandleBlock(this.field_70170_p, pos, genome, trace.field_178784_b)) {
            this.facing = trace.field_178784_b;
            this.func_184212_Q().func_187227_b(POS, (Object)Optional.of((Object)pos));
            this.func_184212_Q().func_187217_b(POS);
            return;
        }
        this.func_70106_y();
    }

    public ISpecialBeeEffect getEffect() {
        ISpecialBeeEffect cache = this.cache;
        if (cache == null) {
            IAlleleBeeEffect effect;
            IBee member = BeeManager.beeRoot.getMember(this.getItem());
            this.cache = member == null ? (cache = NONE) : ((effect = member.getGenome().getEffect()) instanceof ISpecialBeeEffect ? (cache = (ISpecialBeeEffect)effect) : (cache = NONE));
        }
        return cache;
    }

    @Nullable
    public <T extends Entity> T getClosestEntityType(@Nonnull World worldIn, @Nonnull Vec3d start, @Nonnull Vec3d end, @Nonnull AxisAlignedBB axisAlignedBB, @Nonnull Class<T> clazz, @Nonnull Predicate<T> filter) {
        Entity closest = null;
        double closest_dist = Double.MAX_VALUE;
        for (Entity entityLivingBase : worldIn.func_175647_a(clazz, axisAlignedBB, filter::test)) {
            AxisAlignedBB axisalignedbb = entityLivingBase.func_174813_aQ().func_186662_g((double)0.3f);
            RayTraceResult ray = axisalignedbb.func_72327_a(start, end);
            if (ray != null) {
                double v = start.func_72436_e(ray.field_72307_f);
                if (!(v < closest_dist)) continue;
                closest = entityLivingBase;
                closest_dist = v;
                continue;
            }
            if (!axisalignedbb.func_72318_a(start)) continue;
            return (T)entityLivingBase;
        }
        return (T)closest;
    }

    public IAlleleBeeSpecies getPrimary() {
        IBee member;
        IAlleleBeeSpecies cache = this.cacheSpecies;
        if (cache == null && (member = BeeManager.beeRoot.getMember(this.getItem())) != null) {
            IAlleleBeeSpecies effect;
            this.cacheSpecies = cache = (effect = member.getGenome().getPrimary());
        }
        return cache;
    }

    public IBeeGenome getGenome() {
        IBee member;
        IBeeGenome cache = this.cacheGenome;
        if (cache == null && (member = BeeManager.beeRoot.getMember(this.getItem())) != null) {
            this.cacheGenome = cache = member.getGenome();
        }
        return cache;
    }

    private /* synthetic */ boolean lambda$onUpdate$7(ISpecialBeeEffect.SpecialEffectItem effectItem, IBeeGenome genome, EntityItem t) {
        return EntitySelectors.field_94557_a.test((Object)t) && t != this.owner && !t.func_92059_d().func_190926_b() && effectItem.canHandleStack(t.func_92059_d(), genome);
    }

    private /* synthetic */ boolean lambda$onUpdate$6(ISpecialBeeEffect.SpecialEffectEntity effectEntity, IBeeGenome genome, Entity t) {
        return EntitySelectors.field_94557_a.test((Object)t) && t != this.owner && effectEntity.canHandleEntity(t, genome);
    }
}

