/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.event.HeatCoilVisualEvent;
import teamroots.embers.api.event.MachineRecipeEvent;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageCookItemFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.recipe.HeatCoilRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.tileentity.IMultiblockMachine;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityHeatCoil
extends TileEntity
implements ITileEntityBase,
ITickable,
IMultiblockMachine,
ISoundController,
IExtraDialInformation,
IExtraCapabilityInformation {
    public static final double EMBER_COST = 1.0;
    public static final double HEATING_SPEED = 1.0;
    public static final double COOLING_SPEED = 1.0;
    public static final double MAX_HEAT = 280.0;
    public static final int MIN_COOK_TIME = 20;
    public static final int MAX_COOK_TIME = 300;
    public static final Color DEFAULT_COLOR = new Color(255, 64, 16);
    public IEmberCapability capability = new DefaultEmberCapability();
    public ItemStackHandler inventory = new ItemStackHandler(1);
    protected Random random = new Random();
    protected int progress = 0;
    public double heat = 0.0;
    protected int ticksExisted = 0;
    public static final int SOUND_LOW_LOOP = 1;
    public static final int SOUND_MID_LOOP = 2;
    public static final int SOUND_HIGH_LOOP = 3;
    public static final int SOUND_PROCESS = 4;
    public static final int[] SOUND_IDS = new int[]{1, 2, 3, 4};
    HashSet<Integer> soundsPlaying = new HashSet();
    boolean isWorking;
    private List<IUpgradeProvider> upgrades;

    public TileEntityHeatCoil() {
        this.capability.setEmberCapacity(8000.0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        tag.func_74768_a("progress", this.progress);
        tag.func_74780_a("heat", this.heat);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
        }
        if (tag.func_74764_b("heat")) {
            this.heat = tag.func_74769_h("heat");
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175698_g(pos.func_177982_a(1, 0, 0));
        world.func_175698_g(pos.func_177982_a(0, 0, 1));
        world.func_175698_g(pos.func_177982_a(-1, 0, 0));
        world.func_175698_g(pos.func_177982_a(0, 0, -1));
        world.func_175698_g(pos.func_177982_a(1, 0, -1));
        world.func_175698_g(pos.func_177982_a(-1, 0, 1));
        world.func_175698_g(pos.func_177982_a(1, 0, 1));
        world.func_175698_g(pos.func_177982_a(-1, 0, -1));
        world.func_175690_a(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        if (this.func_145831_w().field_72995_K) {
            this.handleSound();
        }
        this.upgrades = UpgradeUtil.getUpgrades(this.field_145850_b, this.field_174879_c, new EnumFacing[]{EnumFacing.DOWN});
        UpgradeUtil.verifyUpgrades(this, this.upgrades);
        if (UpgradeUtil.doTick(this, this.upgrades)) {
            return;
        }
        double emberCost = UpgradeUtil.getTotalEmberConsumption(this, 1.0, this.upgrades);
        if (this.capability.getEmber() >= emberCost) {
            UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.CONSUME, emberCost), this.upgrades);
            this.capability.removeAmount(emberCost, true);
            if (this.ticksExisted % 20 == 0) {
                this.heat += UpgradeUtil.getOtherParameter((TileEntity)this, "heating_speed", 1.0, this.upgrades);
            }
        } else if (this.ticksExisted % 20 == 0) {
            this.heat -= UpgradeUtil.getOtherParameter((TileEntity)this, "cooling_speed", 1.0, this.upgrades);
        }
        double maxHeat = UpgradeUtil.getOtherParameter((TileEntity)this, "max_heat", 280.0, this.upgrades);
        this.heat = MathHelper.func_151237_a((double)this.heat, (double)0.0, (double)maxHeat);
        this.isWorking = false;
        boolean cancel = UpgradeUtil.doWork(this, this.upgrades);
        int cookTime = UpgradeUtil.getWorkTime(this, (int)Math.ceil(MathHelper.func_151238_b((double)20.0, (double)300.0, (double)(1.0 - this.heat / maxHeat))), this.upgrades);
        if (!cancel && this.heat > 0.0 && this.ticksExisted % cookTime == 0 && !this.func_145831_w().field_72995_K) {
            int i;
            EntityItem entityItem;
            HeatCoilRecipe recipe;
            List items = this.func_145831_w().func_72872_a(EntityItem.class, new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 2), (double)(this.func_174877_v().func_177956_o() + 2), (double)(this.func_174877_v().func_177952_p() + 2)));
            for (EntityItem item : items) {
                item.func_70288_d();
                item.lifespan = 10800;
            }
            if (items.size() > 0 && (recipe = this.getRecipe(entityItem = (EntityItem)items.get(i = this.random.nextInt(items.size())))) != null) {
                ArrayList returns = Lists.newArrayList((Object[])new ItemStack[]{recipe.getResult(this, entityItem.func_92059_d())});
                int inputCount = recipe.getInputConsumed();
                boolean dirty = false;
                UpgradeUtil.transformOutput((TileEntity)this, returns, this.upgrades);
                this.depleteItem(entityItem, inputCount);
                for (ItemStack stack : returns) {
                    ItemStack remainder = this.inventory.insertItem(0, stack, false);
                    dirty = true;
                    if (remainder.func_190926_b()) continue;
                    this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, remainder));
                }
                if (dirty) {
                    this.func_70296_d();
                }
            }
        }
        if (this.func_145831_w().field_72995_K && this.heat > 0.0) {
            int particleCount = (int)((float)(1 + this.random.nextInt(2)) * (1.0f + (float)Math.sqrt(this.heat)));
            HeatCoilVisualEvent event = new HeatCoilVisualEvent(this, DEFAULT_COLOR, particleCount, 0.0f);
            UpgradeUtil.throwEvent(this, event, this.upgrades);
            Color color = event.getColor();
            for (int i = 0; i < event.getParticles(); ++i) {
                ParticleUtil.spawnParticleGlow(this.func_145831_w(), (float)this.func_174877_v().func_177958_n() - 0.2f + this.random.nextFloat() * 1.4f, (float)this.func_174877_v().func_177956_o() + 1.275f, (float)this.func_174877_v().func_177952_p() - 0.2f + this.random.nextFloat() * 1.4f, 0.0f, this.random.nextFloat() * event.getVerticalSpeed(), 0.0f, color.getRed(), color.getGreen(), color.getBlue(), 2.0f, 24);
            }
        }
    }

    private HeatCoilRecipe getRecipe(EntityItem entityItem) {
        HeatCoilRecipe recipe = RecipeRegistry.getHeatCoilRecipe(entityItem.func_92059_d());
        MachineRecipeEvent<HeatCoilRecipe> event = new MachineRecipeEvent<HeatCoilRecipe>(this, recipe);
        UpgradeUtil.throwEvent(this, event, this.upgrades);
        return event.getRecipe();
    }

    public void depleteItem(EntityItem entityItem, int inputCount) {
        ItemStack stack = entityItem.func_92059_d();
        stack.func_190918_g(inputCount);
        entityItem.func_92058_a(stack);
        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageCookItemFX(entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v));
        if (stack.func_190926_b()) {
            entityItem.func_70106_y();
            this.func_145831_w().func_72900_e((Entity)entityItem);
        }
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.HEATCOIL_LOW, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
                break;
            }
            case 2: {
                Embers.proxy.playMachineSound(this, 2, SoundManager.HEATCOIL_MID, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
                break;
            }
            case 3: {
                Embers.proxy.playMachineSound(this, 3, SoundManager.HEATCOIL_HIGH, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
                break;
            }
            case 4: {
                Embers.proxy.playMachineSound(this, 4, SoundManager.HEATCOIL_COOK, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        double heatRatio = this.heat / 280.0;
        float highVolume = (float)MathHelper.func_151238_b((double)0.0, (double)1.0, (double)((heatRatio - 0.75) * 4.0));
        float midVolume = (float)MathHelper.func_151238_b((double)0.0, (double)1.0, (double)((heatRatio - 0.25) * 4.0)) - highVolume;
        float lowVolume = (float)MathHelper.func_151238_b((double)0.0, (double)1.0, (double)(heatRatio * 10.0)) - midVolume;
        switch (id) {
            case 1: {
                return lowVolume > 0.0f;
            }
            case 2: {
                return midVolume > 0.0f;
            }
            case 3: {
                return highVolume > 0.0f;
            }
        }
        return false;
    }

    @Override
    public float getCurrentVolume(int id, float volume) {
        double heatRatio = this.heat / 280.0;
        float highVolume = (float)MathHelper.func_151238_b((double)0.0, (double)1.0, (double)((heatRatio - 0.75) * 4.0));
        float midVolume = (float)MathHelper.func_151238_b((double)0.0, (double)1.0, (double)((heatRatio - 0.25) * 4.0)) - highVolume;
        float lowVolume = (float)MathHelper.func_151238_b((double)0.0, (double)1.0, (double)(heatRatio * 10.0)) - midVolume;
        switch (id) {
            case 1: {
                return lowVolume;
            }
            case 2: {
                return midVolume;
            }
            case 3: {
                return highVolume;
            }
        }
        return 0.0f;
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        if ("ember".equals(dialType)) {
            DecimalFormat heatFormat = Embers.proxy.getDecimalFormat("embers.decimal_format.heat");
            double maxHeat = UpgradeUtil.getOtherParameter((TileEntity)this, "max_heat", 280.0, this.upgrades);
            double heat = MathHelper.func_151237_a((double)this.heat, (double)0.0, (double)maxHeat);
            information.add(I18n.func_135052_a((String)"embers.tooltip.dial.heat", (Object[])new Object[]{heatFormat.format(heat), heatFormat.format(maxHeat)}));
        }
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.OUTPUT, "embers.tooltip.goggles.item", null));
        }
    }
}

