/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.gui;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.opengl.GL11;
import teamroots.embers.EventManager;
import teamroots.embers.SoundManager;
import teamroots.embers.research.ResearchBase;
import teamroots.embers.research.ResearchCategory;
import teamroots.embers.research.ResearchManager;
import teamroots.embers.util.Misc;
import teamroots.embers.util.RenderUtil;

public class GuiCodex
extends GuiScreen {
    public double mouseX = 0.0;
    public double mouseY = 0.0;
    public double smoothMouseX = 0.0;
    public double smoothMouseY = 0.0;
    public int selectedIndex = -1;
    public int selectedPageIndex = -1;
    public ResearchCategory researchCategory;
    public ResearchBase researchPage;
    public float ticks = 1.0f;
    public boolean showLeftArrow = false;
    public boolean showRightArrow = false;
    public int tooltipX = 0;
    public int tooltipY = 0;
    ItemStack tooltipStack = null;
    public boolean renderTooltip = false;
    public int framesExisted = 0;
    public float[] raise = null;
    public float[] raiseTargets = null;
    public String[] sentences = null;
    LinkedList<ResearchCategory> lastCategories = new LinkedList();
    public boolean nextPageSelected;
    public boolean previousPageSelected;
    public String searchString = "";
    public int searchDelay;
    public ArrayList<ResearchBase> searchResult = new ArrayList();

    public void markTooltipForRender(ItemStack stack, int x, int y) {
        this.renderTooltip = true;
        this.tooltipX = x;
        this.tooltipY = y;
        this.tooltipStack = stack;
    }

    public void doRenderTooltip() {
        if (this.renderTooltip) {
            this.func_146285_a(this.tooltipStack, this.tooltipX, this.tooltipY);
            this.renderTooltip = false;
        }
    }

    public void pushLastCategory(ResearchCategory category) {
        ListIterator iterator = this.lastCategories.listIterator();
        boolean clear = false;
        while (iterator.hasNext()) {
            ResearchCategory lastCategory = (ResearchCategory)iterator.next();
            if (lastCategory == category) {
                clear = true;
            }
            if (!clear) continue;
            iterator.remove();
        }
        this.lastCategories.add(category);
    }

    public ResearchCategory popLastCategory() {
        if (this.lastCategories.isEmpty()) {
            return null;
        }
        return this.lastCategories.removeLast();
    }

    public ResearchCategory peekLastCategory() {
        if (this.lastCategories.isEmpty()) {
            return null;
        }
        return this.lastCategories.getLast();
    }

    public void renderItemStackAt(ItemStack stack, int x, int y, int mouseX, int mouseY) {
        if (!stack.func_190926_b()) {
            RenderHelper.func_74518_a();
            RenderHelper.func_74520_c();
            this.field_146296_j.func_175042_a(stack, x, y);
            this.field_146296_j.func_180453_a(this.field_146289_q, stack, x, y, stack.func_190916_E() != 1 ? Integer.toString(stack.func_190916_E()) : "");
            if (mouseX >= x && mouseY >= y && mouseX < x + 16 && mouseY < y + 16) {
                this.markTooltipForRender(stack, mouseX, mouseY);
            }
            RenderHelper.func_74519_b();
        }
        GlStateManager.func_179140_f();
    }

    public void renderItemStackMinusTooltipAt(ItemStack stack, int x, int y) {
        if (!stack.func_190926_b()) {
            RenderHelper.func_74518_a();
            RenderHelper.func_74520_c();
            this.field_146296_j.func_175042_a(stack, x, y);
            this.field_146296_j.func_180453_a(this.field_146289_q, stack, x, y, stack.func_190916_E() != 1 ? Integer.toString(stack.func_190916_E()) : "");
            RenderHelper.func_74519_b();
        }
        GlStateManager.func_179140_f();
    }

    public void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 && this.researchCategory != null) {
            if (this.researchPage != null) {
                this.researchPage = null;
                this.playSound(SoundManager.CODEX_PAGE_CLOSE);
                return;
            }
            this.researchCategory = this.popLastCategory();
            this.playSound(this.researchCategory == null ? SoundManager.CODEX_CATEGORY_CLOSE : SoundManager.CODEX_CATEGORY_SWITCH);
            return;
        }
        if (this.researchPage != null && this.researchPage.hasMultiplePages()) {
            if (keyCode == 30) {
                this.switchPreviousPage();
                return;
            }
            if (keyCode == 32) {
                this.switchNextPage();
                return;
            }
        } else if (this.researchPage == null) {
            if (keyCode == 14) {
                if (!this.searchString.isEmpty()) {
                    this.setSearchString(this.searchString.substring(0, this.searchString.length() - 1));
                }
            } else if (!Character.isISOControl(typedChar)) {
                this.setSearchString(this.searchString + typedChar);
            }
        }
        super.func_73869_a(typedChar, keyCode);
    }

    private void setSearchString(String string) {
        this.searchString = string;
        this.searchDelay = 20;
    }

    private void switchNextPage() {
        this.researchPage = this.researchPage.getNextPage();
        this.playSound(SoundManager.CODEX_PAGE_SWITCH);
    }

    private void switchPreviousPage() {
        this.researchPage = this.researchPage.getPreviousPage();
        this.playSound(SoundManager.CODEX_PAGE_SWITCH);
    }

    public void playSound(SoundEvent sound) {
        this.playSound(sound, 1.0f);
    }

    public void playSound(SoundEvent sound, float pitch) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)sound, (float)pitch));
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        ResearchCategory selectedCategory;
        if (this.selectedIndex != -1 && this.researchCategory == null && (selectedCategory = ResearchManager.researches.get(this.selectedIndex)).isChecked()) {
            this.researchCategory = selectedCategory;
            this.playSound(SoundManager.CODEX_CATEGORY_OPEN);
        }
        if (this.selectedPageIndex != -1 && this.researchPage == null) {
            ResearchBase selectedResearchPage = this.researchCategory.researches.get(this.selectedPageIndex);
            if (mouseButton == 0) {
                if (selectedResearchPage.onOpen(this)) {
                    this.researchPage = selectedResearchPage;
                    this.playSound(SoundManager.CODEX_PAGE_OPEN);
                }
            } else if (mouseButton == 1) {
                boolean newChecked = !selectedResearchPage.isChecked();
                selectedResearchPage.check(newChecked);
                if (selectedResearchPage.isChecked() == newChecked) {
                    if (newChecked) {
                        this.playSound(SoundManager.CODEX_CHECK);
                    } else {
                        this.playSound(SoundManager.CODEX_UNCHECK);
                    }
                    ResearchManager.sendCheckmark(selectedResearchPage, newChecked);
                }
            }
        }
        if (this.researchPage != null && this.researchPage.hasMultiplePages()) {
            if (this.nextPageSelected) {
                this.switchNextPage();
            } else if (this.previousPageSelected) {
                this.switchPreviousPage();
            }
        }
    }

    public static void drawText(FontRenderer font, String s, int x, int y, int color) {
        RenderUtil.drawTextRGBA(font, s, x - 1, y, 0, 0, 0, 64);
        RenderUtil.drawTextRGBA(font, s, x + 1, y, 0, 0, 0, 64);
        RenderUtil.drawTextRGBA(font, s, x, y - 1, 0, 0, 0, 64);
        RenderUtil.drawTextRGBA(font, s, x, y + 1, 0, 0, 0, 64);
        font.func_78276_b(s, x, y, color);
    }

    public static void drawTextLessShadow(FontRenderer font, String s, int x, int y, int color) {
        RenderUtil.drawTextRGBA(font, s, x - 1, y, 0, 0, 0, 64);
        RenderUtil.drawTextRGBA(font, s, x + 1, y, 0, 0, 0, 64);
        RenderUtil.drawTextRGBA(font, s, x, y - 1, 0, 0, 0, 64);
        RenderUtil.drawTextRGBA(font, s, x, y + 1, 0, 0, 0, 64);
        font.func_78276_b(s, x, y, color);
    }

    public static void drawTextGlowing(FontRenderer font, String s, int x, int y) {
        float sine = 0.5f * ((float)Math.sin(Math.toRadians(4.0f * ((float)EventManager.ticks + Minecraft.func_71410_x().func_184121_ak()))) + 1.0f);
        String stringColorStripped = s.replaceAll(RenderUtil.COLOR_CODE_MATCHER.pattern(), "");
        RenderUtil.drawTextRGBA(font, stringColorStripped, x - 1, y, 0, 0, 0, 64);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x + 1, y, 0, 0, 0, 64);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x, y - 1, 0, 0, 0, 64);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x, y + 1, 0, 0, 0, 64);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x - 2, y, 0, 0, 0, 40);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x + 2, y, 0, 0, 0, 40);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x, y - 2, 0, 0, 0, 40);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x, y + 2, 0, 0, 0, 40);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x - 1, y + 1, 0, 0, 0, 40);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x + 1, y - 1, 0, 0, 0, 40);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x - 1, y - 1, 0, 0, 0, 40);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x + 1, y + 1, 0, 0, 0, 40);
        font.func_78276_b(s, x, y, Misc.intColor(255, 64 + (int)(64.0f * sine), 16));
    }

    public void drawModalRectGlowing(int x, int y, int textureX, int textureY, int width, int height) {
        float sine = 0.5f * ((float)Math.sin(Math.toRadians(4.0f * ((float)EventManager.ticks + Minecraft.func_71410_x().func_184121_ak()))) + 1.0f);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2509804f);
        this.func_73729_b(x - 1, y, textureX, textureY, width, height);
        this.func_73729_b(x + 1, y, textureX, textureY, width, height);
        this.func_73729_b(x, y - 1, textureX, textureY, width, height);
        this.func_73729_b(x, y + 1, textureX, textureY, width, height);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.15686275f);
        this.func_73729_b(x - 2, y, textureX, textureY, width, height);
        this.func_73729_b(x + 2, y, textureX, textureY, width, height);
        this.func_73729_b(x, y - 2, textureX, textureY, width, height);
        this.func_73729_b(x, y + 2, textureX, textureY, width, height);
        this.func_73729_b(x - 1, y + 1, textureX, textureY, width, height);
        this.func_73729_b(x + 1, y - 1, textureX, textureY, width, height);
        this.func_73729_b(x - 1, y - 1, textureX, textureY, width, height);
        this.func_73729_b(x + 1, y + 1, textureX, textureY, width, height);
        GlStateManager.func_179131_c((float)1.0f, (float)((64.0f + 64.0f * sine) / 255.0f), (float)0.0627451f, (float)1.0f);
        this.func_73729_b(x, y, textureX, textureY, width, height);
    }

    public static void drawTextGlowingAura(FontRenderer font, String s, int x, int y) {
        float sine = 0.5f * ((float)Math.sin(Math.toRadians(4.0f * ((float)EventManager.ticks + Minecraft.func_71410_x().func_184121_ak()))) + 1.0f);
        String stringColorStripped = s;
        RenderUtil.drawTextRGBA(font, stringColorStripped, x - 1, y, 255, 64 + (int)(64.0f * sine), 16, 40);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x + 1, y, 255, 64 + (int)(64.0f * sine), 16, 40);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x, y - 1, 255, 64 + (int)(64.0f * sine), 16, 40);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x, y + 1, 255, 64 + (int)(64.0f * sine), 16, 40);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x - 2, y, 255, 64 + (int)(64.0f * sine), 16, 20);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x + 2, y, 255, 64 + (int)(64.0f * sine), 16, 20);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x, y - 2, 255, 64 + (int)(64.0f * sine), 16, 20);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x, y + 2, 255, 64 + (int)(64.0f * sine), 16, 20);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x - 1, y + 1, 255, 64 + (int)(64.0f * sine), 16, 20);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x + 1, y - 1, 255, 64 + (int)(64.0f * sine), 16, 20);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x - 1, y - 1, 255, 64 + (int)(64.0f * sine), 16, 20);
        RenderUtil.drawTextRGBA(font, stringColorStripped, x + 1, y + 1, 255, 64 + (int)(64.0f * sine), 16, 20);
        font.func_78276_b(s, x, y, Misc.intColor(255, 64 + (int)(64.0f * sine), 16));
    }

    public static void drawTextGlowingAuraTransparent(FontRenderer font, String s, int x, int y, int r, int g, int b, int a) {
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        font.func_78276_b(s, x, y, Misc.intColor(r, g, b) + (a << 24));
        RenderUtil.drawTextRGBA(font, s, x - 1, y, r, g, b, 40 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x + 1, y, r, g, b, 40 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x, y - 1, r, g, b, 40 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x, y + 1, r, g, b, 40 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x - 2, y, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x + 2, y, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x, y - 2, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x, y + 2, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x - 1, y + 1, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x + 1, y - 1, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x - 1, y - 1, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x + 1, y + 1, r, g, b, 20 * a / 255);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    public static void drawTextGlowingAuraTransparentIntColor(FontRenderer font, String s, int x, int y, int color, int a) {
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        font.func_78276_b(s, x, y, color + (a << 24));
        font.func_78276_b(s, x - 1, y, color + (40 * a / 255 << 24));
        font.func_78276_b(s, x + 1, y, color + (40 * a / 255 << 24));
        font.func_78276_b(s, x, y - 1, color + (40 * a / 255 << 24));
        font.func_78276_b(s, x, y + 1, color + (40 * a / 255 << 24));
        font.func_78276_b(s, x - 2, y, color + (20 * a / 255 << 24));
        font.func_78276_b(s, x + 2, y, color + (20 * a / 255 << 24));
        font.func_78276_b(s, x, y - 2, color + (20 * a / 255 << 24));
        font.func_78276_b(s, x, y + 2, color + (20 * a / 255 << 24));
        font.func_78276_b(s, x - 1, y + 1, color + (20 * a / 255 << 24));
        font.func_78276_b(s, x + 1, y - 1, color + (20 * a / 255 << 24));
        font.func_78276_b(s, x - 1, y - 1, color + (20 * a / 255 << 24));
        font.func_78276_b(s, x + 1, y + 1, color + (20 * a / 255 << 24));
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    public static void drawTextGlowingAuraTransparent(FontRenderer font, String s, int x, int y, int a) {
        float sine = 0.5f * ((float)Math.sin(Math.toRadians(4.0f * ((float)EventManager.ticks + Minecraft.func_71410_x().func_184121_ak()))) + 1.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        int r = 255;
        int g = 64 + (int)(64.0f * sine);
        int b = 16;
        font.func_78276_b(s, x, y, Misc.intColor(r, g, b) + (a << 24));
        RenderUtil.drawTextRGBA(font, s, x - 1, y, r, g, b, 40 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x + 1, y, r, g, b, 40 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x, y - 1, r, g, b, 40 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x, y + 1, r, g, b, 40 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x - 2, y, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x + 2, y, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x, y - 2, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x, y + 2, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x - 1, y + 1, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x + 1, y - 1, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x - 1, y - 1, r, g, b, 20 * a / 255);
        RenderUtil.drawTextRGBA(font, s, x + 1, y + 1, r, g, b, 20 * a / 255);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    public static void drawCenteredText(FontRenderer font, String s, int x, int y, int color) {
        GuiCodex.drawText(font, s, x - font.func_78256_a(s) / 2, y, color);
    }

    public static void drawCenteredTextGlowing(FontRenderer font, String s, int x, int y) {
        GuiCodex.drawTextGlowing(font, s, x - font.func_78256_a(s) / 2, y);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        boolean showTooltips = true;
        boolean showSearchString = this.searchDelay >= 0 && !this.searchString.isEmpty();
        boolean doUpdateSynced = this.ticks > partialTicks;
        this.ticks = partialTicks;
        int numResearches = ResearchManager.researches.size();
        if (this.raise == null) {
            this.raise = new float[numResearches];
            for (i = 0; i < this.raise.length; ++i) {
                this.raise[i] = 0.0f;
            }
        }
        if (this.raiseTargets == null) {
            this.raiseTargets = new float[numResearches];
            for (i = 0; i < this.raiseTargets.length; ++i) {
                this.raiseTargets[i] = 0.0f;
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        int func = GL11.glGetInteger((int)3009);
        float ref = GL11.glGetFloat((int)3010);
        GlStateManager.func_179092_a((int)519, (float)0.0f);
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int basePosX = (int)((float)this.field_146294_l / 2.0f) - 96;
        int basePosY = (int)((float)this.field_146295_m / 2.0f) - 128;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        int lastSelectedIndex = this.selectedIndex;
        this.selectedIndex = -1;
        this.selectedPageIndex = -1;
        if (this.researchCategory == null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("embers:textures/gui/codex_index.png"));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(basePosX, basePosY, 0, 0, 192, 256);
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("embers:textures/gui/codex_parts.png"));
            this.func_73729_b(basePosX - 16, basePosY - 16, 0, 0, 48, 48);
            this.func_73729_b(basePosX + 160, basePosY - 16, 48, 0, 48, 48);
            this.func_73729_b(basePosX + 160, basePosY + 224, 96, 0, 48, 48);
            this.func_73729_b(basePosX - 16, basePosY + 224, 144, 0, 48, 48);
            this.func_73729_b(basePosX + 72, basePosY - 16, 0, 48, 48, 48);
            this.func_73729_b(basePosX + 72, basePosY + 224, 0, 48, 48, 48);
            this.func_73729_b(basePosX - 16, basePosY + 64, 0, 48, 48, 48);
            this.func_73729_b(basePosX + 160, basePosY + 64, 0, 48, 48, 48);
            for (float i2 = 0.0f; i2 < (float)numResearches; i2 += 1.0f) {
                float mouseDir = (float)Math.toDegrees(Math.atan2(mouseY - (basePosY + 88), mouseX - (basePosX + 96))) + 90.0f;
                float distSq = (mouseX - (basePosX + 96)) * (mouseX - (basePosX + 96)) + (mouseY - (basePosY + 96)) * (mouseY - (basePosY + 96));
                float angle = i2 * (360.0f / (float)numResearches);
                boolean selected = false;
                float diff = Math.min(Math.min(Math.abs(mouseDir - angle), Math.abs(mouseDir - 360.0f - angle)), Math.abs(mouseDir + 360.0f) - angle);
                ResearchCategory category = ResearchManager.researches.get((int)i2);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(category.getIndexTexture());
                boolean alreadyGlowing = category.researches.stream().anyMatch(entry -> this.searchResult.contains(entry));
                if (diff < 180.0f / (float)numResearches && distSq < 16000.0f) {
                    if (lastSelectedIndex != (int)i2) {
                        if (category.isChecked() && !alreadyGlowing) {
                            this.playSound(SoundManager.CODEX_CATEGORY_SELECT);
                        } else {
                            this.playSound(SoundManager.CODEX_CATEGORY_UNSELECT);
                        }
                    }
                    selected = true;
                    this.selectedIndex = (int)i2;
                    if (this.raise[(int)i2] < 1.0f && doUpdateSynced) {
                        this.raise[(int)i2] = this.raiseTargets[(int)i2];
                        this.raiseTargets[(int)i2] = this.raiseTargets[(int)i2] * 0.5f + 0.5f;
                    }
                } else {
                    if (lastSelectedIndex == (int)i2) {
                        this.playSound(SoundManager.CODEX_CATEGORY_UNSELECT);
                    }
                    if (doUpdateSynced) {
                        this.raise[(int)i2] = this.raiseTargets[(int)i2];
                        this.raiseTargets[(int)i2] = this.raiseTargets[(int)i2] * 0.5f;
                    }
                }
                float instRaise = this.raise[(int)i2] * (1.0f - partialTicks) + this.raiseTargets[(int)i2] * partialTicks;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(basePosX + 96), (float)(basePosY + 88), (float)0.0f);
                GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                boolean glowing = alreadyGlowing || selected && category.isChecked();
                this.func_175174_a(-16.0f, -88.0f - 12.0f * instRaise, 192, 112, 32, 64);
                this.func_175174_a(-6.0f, -80.0f - 12.0f * instRaise, (int)category.getIconU() + (glowing ? 16 : 0), (int)category.getIconV(), 12, 12);
                GlStateManager.func_179121_F();
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("embers:textures/gui/codex_index.png"));
            this.func_73729_b(basePosX + 64, basePosY + 56, 192, 176, 64, 64);
            if (!showSearchString && this.selectedIndex >= 0) {
                ResearchCategory category = ResearchManager.researches.get(this.selectedIndex);
                GuiCodex.drawCenteredTextGlowing(this.field_146289_q, category.getName(), basePosX + 96, basePosY + 207);
            } else if (!this.searchString.isEmpty()) {
                GuiCodex.drawCenteredTextGlowing(this.field_146289_q, this.getSearchStringPrint(), basePosX + 96, basePosY + 207);
            } else {
                GuiCodex.drawCenteredTextGlowing(this.field_146289_q, I18n.func_135052_a((String)"embers.research.null", (Object[])new Object[0]), basePosX + 96, basePosY + 207);
            }
            if (this.selectedIndex >= 0) {
                ResearchCategory category = ResearchManager.researches.get(this.selectedIndex);
                List<String> tooltip = category.getTooltip(showTooltips);
                if (!tooltip.isEmpty()) {
                    this.renderTooltip(tooltip, mouseX, mouseY);
                }
            } else if (mouseX > basePosX - 16 && mouseY > basePosY + 224 && mouseX < basePosX - 16 + 48 && mouseY < basePosY + 224 + 48) {
                ArrayList tooltip = Lists.newArrayList((Object[])I18n.func_135052_a((String)"embers.research.controls", (Object[])new Object[0]).split(";"));
                this.renderTooltip(tooltip, mouseX, mouseY);
            }
        } else if (this.researchPage == null) {
            ResearchBase page;
            List<String> tooltip;
            ResearchBase r;
            int i3;
            float showSpeed = 0.3f;
            boolean playUnlockSound = false;
            boolean playLockSound = false;
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_179141_d();
            basePosX = (int)((float)this.field_146294_l / 2.0f) - 192;
            basePosY = (int)((float)this.field_146295_m / 2.0f) - 136;
            int basePosY2 = Math.min(this.field_146295_m - 33, basePosY + 272);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.researchCategory.getBackgroundTexture());
            RenderUtil.drawTexturedModalRect(basePosX, basePosY, this.field_73735_i, 0.0, 0.0, 0.75, 0.53125, 384, 272);
            for (i3 = 0; i3 < this.researchCategory.researches.size(); ++i3) {
                float y;
                float x;
                BufferBuilder b;
                boolean isShown;
                r = this.researchCategory.researches.get(i3);
                if (r.isHidden()) continue;
                r.shownAmount = r.shownTarget;
                if (r.areAncestorsChecked()) {
                    if (r.shownTarget <= 0.0f) {
                        playUnlockSound = true;
                    }
                    r.shownTarget = Math.min(1.0f, r.shownTarget + partialTicks * 0.1f * showSpeed);
                } else {
                    if (r.shownTarget >= 1.0f) {
                        playLockSound = true;
                    }
                    r.shownTarget = Math.max(0.0f, r.shownTarget - partialTicks * 0.1f * showSpeed);
                }
                boolean bl = isShown = (double)r.shownAmount >= 1.0;
                if (isShown && mouseX >= basePosX + r.x - 24 && mouseY >= basePosY + r.y - 24 && mouseX <= basePosX + r.x + 24 && mouseY <= basePosY + r.y + 24) {
                    this.selectedPageIndex = i3;
                    if (r.selectedAmount < 1.0f) {
                        r.selectedAmount = r.selectionTarget;
                        r.selectionTarget = r.selectionTarget * (1.0f - partialTicks) + (r.selectionTarget * 0.8f + 0.2f) * partialTicks;
                    }
                } else if (r.selectedAmount > 0.0f) {
                    r.selectedAmount = r.selectionTarget;
                    r.selectionTarget = r.selectionTarget * (1.0f - partialTicks) + r.selectionTarget * 0.9f * partialTicks;
                }
                if (isShown && this.searchResult.contains(r)) {
                    Tessellator tess = Tessellator.func_178181_a();
                    b = tess.func_178180_c();
                    x = r.x;
                    y = r.y;
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    GlStateManager.func_179103_j((int)7425);
                    GlStateManager.func_179090_x();
                    int index = this.searchResult.indexOf(r);
                    float amt = (float)MathHelper.func_76125_a((int)(-this.searchDelay), (int)0, (int)10) / 10.0f;
                    amt = (float)((double)amt * MathHelper.func_151238_b((double)0.5, (double)1.0, (double)((float)(this.searchResult.size() - index) / (float)this.searchResult.size())));
                    for (float j = 0.0f; j < 3.0f; j += 1.0f) {
                        float coeff = (j + 1.0f) / 3.0f;
                        b.func_181668_a(4, DefaultVertexFormats.field_181706_f);
                        RenderUtil.renderHighlightCircle(b, (float)basePosX + x, (float)basePosY + y, (25.0f + 20.0f * coeff * coeff) * amt);
                        tess.func_78381_a();
                    }
                    GlStateManager.func_179103_j((int)7424);
                    GlStateManager.func_179098_w();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                }
                if (isShown && r.selectedAmount > 0.1f) {
                    Tessellator tess = Tessellator.func_178181_a();
                    b = tess.func_178180_c();
                    x = r.x;
                    y = r.y;
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    GlStateManager.func_179103_j((int)7425);
                    GlStateManager.func_179090_x();
                    float amt = r.selectedAmount;
                    for (float j = 0.0f; j < 8.0f; j += 1.0f) {
                        float coeff = (j + 1.0f) / 8.0f;
                        b.func_181668_a(4, DefaultVertexFormats.field_181706_f);
                        RenderUtil.renderHighlightCircle(b, (float)basePosX + x, (float)basePosY + y, (25.0f + 20.0f * coeff * coeff) * amt);
                        tess.func_78381_a();
                    }
                    GlStateManager.func_179103_j((int)7424);
                    GlStateManager.func_179098_w();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                }
                if (r.ancestors.size() <= 0) continue;
                for (int l = 0; l < r.ancestors.size(); ++l) {
                    Tessellator tess = Tessellator.func_178181_a();
                    BufferBuilder b2 = tess.func_178180_c();
                    ResearchBase ancestor = r.ancestors.get(l);
                    float x1 = r.x;
                    float y1 = r.y;
                    float x2 = ancestor.x;
                    float y2 = ancestor.y;
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    GlStateManager.func_179103_j((int)7425);
                    GlStateManager.func_179090_x();
                    for (float j = 0.0f; j < 8.0f; j += 1.0f) {
                        float coeff = (float)Math.pow((j + 1.0f) / 8.0f, 1.5);
                        float appearCoeff = Math.min(r.shownAmount, ancestor.shownAmount);
                        b2.func_181668_a(8, DefaultVertexFormats.field_181706_f);
                        RenderUtil.renderWavyEmberLine(b2, (float)basePosX + x1, (float)basePosY + y1, (float)basePosX + x2, (float)basePosY + y2, 4.0f * coeff, appearCoeff, new Color(255, 64, 16));
                        tess.func_78381_a();
                    }
                    GlStateManager.func_179103_j((int)7424);
                    GlStateManager.func_179098_w();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                }
            }
            for (i3 = 0; i3 < this.researchCategory.researches.size(); ++i3) {
                r = this.researchCategory.researches.get(i3);
                if (r.isHidden() || !((double)r.shownAmount > 0.5)) continue;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(r.getIconBackground());
                double u = r.getIconBackgroundU();
                double v = r.getIconBackgroundV();
                RenderUtil.drawTexturedModalRect(basePosX + r.x - 24, basePosY + r.y - 24, this.field_73735_i, u, v, u + 0.09375, v + 0.09375, 48, 48);
                if (r.isChecked()) {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(ResearchManager.PAGE_ICONS);
                    double uOverlay = 0.375;
                    double vOverlay = 0.0;
                    RenderUtil.drawTexturedModalRect(basePosX + r.x - 24, basePosY + r.y - 24, this.field_73735_i, uOverlay, vOverlay, uOverlay + 0.09375, vOverlay + 0.09375, 48, 48);
                }
                this.renderItemStackMinusTooltipAt(r.getIcon(), basePosX + r.x - 8, basePosY + r.y - 8);
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.researchCategory.getBackgroundTexture());
            RenderUtil.drawTexturedModalRect(basePosX, basePosY2, this.field_73735_i, 0.0, 0.53125, 0.75, 0.595703125, 384, 33);
            if (!showSearchString && this.selectedPageIndex >= 0) {
                ResearchBase research = this.researchCategory.researches.get(this.selectedPageIndex);
                GuiCodex.drawCenteredTextGlowing(this.field_146289_q, research.getName(), basePosX + 192, basePosY2 + 13);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else if (!this.searchString.isEmpty()) {
                GuiCodex.drawCenteredTextGlowing(this.field_146289_q, this.getSearchStringPrint(), basePosX + 192, basePosY2 + 13);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            for (int i4 = 0; i4 < this.researchCategory.researches.size(); ++i4) {
                r = this.researchCategory.researches.get(i4);
                if (r.isHidden() || !((double)r.shownAmount > 0.0) || !(r.shownAmount < 1.0f)) continue;
                Tessellator tess = Tessellator.func_178181_a();
                BufferBuilder b = tess.func_178180_c();
                float x = r.x;
                float y = r.y;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                GlStateManager.func_179103_j((int)7425);
                GlStateManager.func_179090_x();
                float amt = (float)Math.sin((double)r.shownAmount * Math.PI);
                for (float j = 0.0f; j < 8.0f; j += 1.0f) {
                    float coeff = (j + 1.0f) / 8.0f;
                    b.func_181668_a(4, DefaultVertexFormats.field_181706_f);
                    RenderUtil.renderHighlightCircle(b, (float)basePosX + x, (float)basePosY + y, (25.0f + 20.0f * coeff * coeff) * amt, 200.0, new Color(255, 64, 16));
                    tess.func_78381_a();
                }
                GlStateManager.func_179103_j((int)7424);
                GlStateManager.func_179098_w();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_179141_d();
            if (this.selectedPageIndex >= 0 && !(tooltip = (page = this.researchCategory.researches.get(this.selectedPageIndex)).getTooltip(showTooltips)).isEmpty()) {
                this.renderTooltip(tooltip, mouseX, mouseY);
            }
            if (playLockSound) {
                this.playSound(SoundManager.CODEX_LOCK, showSpeed);
            }
            if (playUnlockSound) {
                this.playSound(SoundManager.CODEX_UNLOCK, showSpeed);
            }
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.researchPage.getBackground());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_179141_d();
            this.func_73729_b(basePosX, basePosY, 0, 0, 192, 256);
            GuiCodex.drawCenteredTextGlowing(this.field_146289_q, this.researchPage.getTitle(), basePosX + 96, basePosY + 19);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.researchPage.renderPageContent(this, basePosX, basePosY, this.field_146289_q);
            if (this.researchPage.hasMultiplePages()) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.researchPage.getBackground());
                this.nextPageSelected = false;
                this.previousPageSelected = false;
                int arrowY = basePosY + 256 - 13;
                if (this.researchPage.getNextPage() != this.researchPage) {
                    int rightArrowX = basePosX + 192 - 9 - 8;
                    this.drawModalRectGlowing(rightArrowX, arrowY, 192, 24, 18, 13);
                    boolean bl = this.nextPageSelected = mouseX >= rightArrowX - 3 && mouseY >= arrowY - 3 && mouseX <= rightArrowX + 3 + 18 && mouseY <= arrowY + 3 + 13;
                }
                if (this.researchPage.getPreviousPage() != this.researchPage) {
                    int leftArrowX = basePosX - 9 + 8;
                    this.drawModalRectGlowing(leftArrowX, arrowY, 192, 37, 18, 13);
                    this.previousPageSelected = mouseX >= leftArrowX - 3 && mouseY >= arrowY - 3 && mouseX <= leftArrowX + 3 + 18 && mouseY <= arrowY + 3 + 13;
                }
            }
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.doRenderTooltip();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179118_c();
        GlStateManager.func_179092_a((int)func, (float)ref);
    }

    private String getSearchStringPrint() {
        String searchStringFormat = this.searchDelay > 0 ? "" : (this.searchResult.isEmpty() ? TextFormatting.DARK_GRAY.toString() : TextFormatting.GREEN.toString());
        return searchStringFormat + this.searchString;
    }

    public void renderTooltip(List<String> text, int x, int y) {
        GuiCodex.drawHoveringTextGlowing(text, x, y, this.field_146294_l, this.field_146295_m, -1, this.field_146289_q);
    }

    public void renderAura(float x, float y) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder b = tess.func_178180_c();
        b.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (float i = -80.0f; i < 80.0f; i += 10.0f) {
            RenderUtil.drawQuadGuiExt(b, x - 10.0f, y - 10.0f, x + 10.0f, y - 10.0f, x + 10.0f, y + 10.0f, x - 10.0f, y + 10.0f, 0, 0, 1, 1, 1, 1, 0.25f, 0.25f, 0.25f, 255.0f);
        }
        tess.func_78381_a();
    }

    public float getVert(float i, float f1, float f2) {
        float coeff = Math.abs(i) + EventManager.tickCounter + Minecraft.func_71410_x().func_184121_ak();
        float vert = Math.abs(10.0f * ((1.0f - Math.abs(i / 80.0f)) * (float)(Math.sin(coeff * f1) + (double)0.4f * Math.sin(coeff * f2))));
        return vert;
    }

    public void func_146281_b() {
        super.func_146281_b();
        for (ResearchCategory category : ResearchManager.researches) {
            for (ResearchBase base : category.researches) {
                base.selectedAmount = 0.0f;
            }
        }
        this.playSound(SoundManager.CODEX_CLOSE);
    }

    public void func_73876_c() {
        super.func_73876_c();
        --this.searchDelay;
        if (this.searchDelay == 0) {
            this.searchResult.clear();
            Map<ResearchBase, Integer> results = ResearchManager.findByTag(this.searchString);
            results.entrySet().stream().sorted((x, y) -> ((Integer)y.getValue()).compareTo((Integer)x.getValue())).map(Map.Entry::getKey).forEach(result -> this.searchResult.add((ResearchBase)result));
        }
    }

    public static void drawHoveringTextGlowing(List<String> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font) {
        if (!textLines.isEmpty()) {
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = font.func_78256_a(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<String> wrappedTextLines = new ArrayList<String>();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = textLines.get(i);
                    List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = font.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            int zLevel = 300;
            int backgroundColor = new Color(0, 0, 0, 128).getRGB();
            float sine = 0.5f * ((float)Math.sin(Math.toRadians(4.0f * ((float)EventManager.ticks + Minecraft.func_71410_x().func_184121_ak()))) + 1.0f);
            float cosine = 0.5f * ((float)Math.cos(Math.toRadians(4.0f * ((float)EventManager.ticks + Minecraft.func_71410_x().func_184121_ak()))) + 1.0f);
            int borderColorStart = new Color(255, 64 + (int)(64.0f * sine), 16, 128).getRGB();
            int borderColorEnd = new Color(255, 64 + (int)(64.0f * cosine), 16, 128).getRGB();
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = textLines.get(lineNumber);
                GuiCodex.drawTextGlowing(font, line, tooltipX, tooltipY);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }
}

