/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.misc.IMetalCoefficient;
import teamroots.embers.compat.crafttweaker.CTUtil;
import teamroots.embers.util.Misc;

@ZenRegister
@ZenClass(value="mods.embers.EmberGeneration")
public class EmberGeneration {
    public static final String NAME = "EmberGeneration";
    public static final String CLASS = "mods.embers.EmberGeneration";

    @ZenMethod
    public static void addEmberFuel(IIngredient item, double ember) {
        CraftTweakerAPI.apply((IAction)new AddEmberFuel(item, ember));
    }

    @ZenMethod
    public static void removeEmberFuel(IItemStack item) {
        CraftTweakerAPI.apply((IAction)new RemoveEmberFuel(item));
    }

    @ZenMethod
    public static void addCatalysisFuel(IIngredient item, double coefficient) {
        CraftTweakerAPI.apply((IAction)new AddCatalysisFuel(item, coefficient));
    }

    @ZenMethod
    public static void removeCatalysisFuel(IItemStack item) {
        CraftTweakerAPI.apply((IAction)new RemoveCatalysisFuel(item));
    }

    @ZenMethod
    public static void addCombustionFuel(IIngredient item, double coefficient) {
        CraftTweakerAPI.apply((IAction)new AddCombustionFuel(item, coefficient));
    }

    @ZenMethod
    public static void removeCombustionFuel(IItemStack item) {
        CraftTweakerAPI.apply((IAction)new RemoveCombustionFuel(item));
    }

    @ZenMethod
    public static void addMetalCoefficient(IIngredient block, double coefficient) {
        CraftTweakerAPI.apply((IAction)new AddMetalCoefficient(block.toString(), state -> block.matches(CraftTweakerMC.getIItemStack((ItemStack)Misc.getStackFromState(state))), coefficient));
    }

    @ZenMethod
    public static void addBoilerFluid(ILiquidStack liquid, ILiquidStack gas, double multiplier) {
        CraftTweakerAPI.apply((IAction)new AddBoilerFluid(liquid, gas, multiplier));
    }

    @ZenMethod
    public static void removeBoilerFluid(ILiquidStack liquid) {
        CraftTweakerAPI.apply((IAction)new RemoveBoilerFluid(liquid));
    }

    @ZenMethod
    public static void addSteamEngineFuel(ILiquidStack liquid, double multiplier) {
        CraftTweakerAPI.apply((IAction)new AddSteamEngineFuel(liquid, multiplier));
    }

    @ZenMethod
    public static void removeSteamEngineFuel(ILiquidStack liquid) {
        CraftTweakerAPI.apply((IAction)new RemoveSteamEngineFuel(liquid));
    }

    public static class RemoveSteamEngineFuel
    implements IAction {
        ILiquidStack liquid;

        public RemoveSteamEngineFuel(ILiquidStack liquid) {
            this.liquid = liquid;
        }

        public void apply() {
            EmbersAPI.unregisterSteamEngineFuel(EmbersAPI.getSteamEngineFuel(CraftTweakerMC.getLiquidStack((ILiquidStack)this.liquid)));
        }

        public String describe() {
            return "Removing steam engine fuel " + this.liquid.toString();
        }
    }

    public static class AddSteamEngineFuel
    implements IAction {
        double power;
        ILiquidStack liquid;

        public AddSteamEngineFuel(ILiquidStack liquid, double power) {
            this.liquid = liquid;
            this.power = power;
        }

        public void apply() {
            EmbersAPI.registerSteamEngineFuel(CraftTweakerMC.getLiquidStack((ILiquidStack)this.liquid).getFluid(), this.power);
        }

        public String describe() {
            return "Adding steam engine fuel " + this.liquid.toString() + " -> " + this.power;
        }
    }

    public static class RemoveBoilerFluid
    implements IAction {
        ILiquidStack liquid;

        public RemoveBoilerFluid(ILiquidStack liquid) {
            this.liquid = liquid;
        }

        public void apply() {
            EmbersAPI.unregisterBoilerFluid(EmbersAPI.getBoilerFluid(CraftTweakerMC.getLiquidStack((ILiquidStack)this.liquid)));
        }

        public String describe() {
            return "Removing boiler fuel " + this.liquid.toString();
        }
    }

    public static class AddBoilerFluid
    implements IAction {
        double multiplier;
        ILiquidStack liquid;
        ILiquidStack gas;

        public AddBoilerFluid(ILiquidStack liquid, ILiquidStack gas, double multiplier) {
            this.liquid = liquid;
            this.gas = gas;
            this.multiplier = multiplier;
        }

        public void apply() {
            EmbersAPI.registerBoilerFluid(CraftTweakerMC.getLiquidStack((ILiquidStack)this.liquid).getFluid(), CraftTweakerMC.getLiquidStack((ILiquidStack)this.gas).getFluid(), this.multiplier);
        }

        public String describe() {
            return "Adding boiler fluid " + this.liquid.toString() + " -> " + this.gas.toString() + ": " + this.multiplier;
        }
    }

    public static class AddMetalCoefficient
    implements IAction {
        String matchDesc;
        Predicate<IBlockState> match;
        double coefficient;

        public AddMetalCoefficient(String matchDesc, Predicate<IBlockState> match, double coefficient) {
            this.matchDesc = matchDesc;
            this.match = match;
            this.coefficient = coefficient;
        }

        public void apply() {
            EmbersAPI.registerMetalCoefficient(new IMetalCoefficient(){

                @Override
                public boolean matches(IBlockState state) {
                    return match.test(state);
                }

                @Override
                public double getCoefficient(IBlockState state) {
                    return coefficient;
                }
            });
        }

        public String describe() {
            return "Adding metal coefficient " + this.coefficient + " for " + this.matchDesc;
        }
    }

    public static class RemoveCombustionFuel
    implements IAction {
        IItemStack item;

        public RemoveCombustionFuel(IItemStack item) {
            this.item = item;
        }

        public void apply() {
            EmbersAPI.unregisterCombustionFuel(EmbersAPI.getCombustionFuel(CraftTweakerMC.getItemStack((IItemStack)this.item)));
        }

        public String describe() {
            return "Removing combustion fuel " + this.item.toString();
        }
    }

    public static class AddCombustionFuel
    implements IAction {
        double coefficient;
        IIngredient item;

        public AddCombustionFuel(IIngredient item, double coefficient) {
            this.item = item;
            this.coefficient = coefficient;
        }

        public void apply() {
            EmbersAPI.registerCombustionFuel(CTUtil.toIngredient(this.item), this.coefficient);
        }

        public String describe() {
            return "Adding combustion fuel " + this.item.toString() + " with coefficient " + this.coefficient;
        }
    }

    public static class RemoveCatalysisFuel
    implements IAction {
        IItemStack item;

        public RemoveCatalysisFuel(IItemStack item) {
            this.item = item;
        }

        public void apply() {
            EmbersAPI.unregisterCatalysisFuel(EmbersAPI.getCatalysisFuel(CraftTweakerMC.getItemStack((IItemStack)this.item)));
        }

        public String describe() {
            return "Removing catalysis fuel " + this.item.toString();
        }
    }

    public static class AddCatalysisFuel
    implements IAction {
        double coefficient;
        IIngredient item;

        public AddCatalysisFuel(IIngredient item, double coefficient) {
            this.item = item;
            this.coefficient = coefficient;
        }

        public void apply() {
            EmbersAPI.registerCatalysisFuel(CTUtil.toIngredient(this.item), this.coefficient);
        }

        public String describe() {
            return "Adding catalysis fuel " + this.item.toString() + " with coefficient " + this.coefficient;
        }
    }

    public static class RemoveEmberFuel
    implements IAction {
        IItemStack item;

        public RemoveEmberFuel(IItemStack item) {
            this.item = item;
        }

        public void apply() {
            EmbersAPI.unregisterEmberFuel(EmbersAPI.getEmberFuel(CraftTweakerMC.getItemStack((IItemStack)this.item)));
        }

        public String describe() {
            return "Removing ember fuel " + this.item.toString();
        }
    }

    public static class AddEmberFuel
    implements IAction {
        double ember;
        IIngredient item;

        public AddEmberFuel(IIngredient item, double ember) {
            this.ember = ember;
            this.item = item;
        }

        public void apply() {
            EmbersAPI.registerEmberFuel(CTUtil.toIngredient(this.item), this.ember);
        }

        public String describe() {
            return "Adding ember fuel " + this.item.toString() + " with value " + this.ember;
        }
    }
}

