/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.event;

import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.config.Configs;
import fi.dy.masa.justenoughdimensions.config.DimensionConfig;
import fi.dy.masa.justenoughdimensions.config.DimensionConfigEntry;
import fi.dy.masa.justenoughdimensions.event.DataTracker;
import fi.dy.masa.justenoughdimensions.event.JEDBorderListener;
import fi.dy.masa.justenoughdimensions.network.DimensionSyncPacket;
import fi.dy.masa.justenoughdimensions.util.world.WorldBorderUtils;
import fi.dy.masa.justenoughdimensions.util.world.WorldFileUtils;
import fi.dy.masa.justenoughdimensions.util.world.WorldInfoUtils;
import fi.dy.masa.justenoughdimensions.util.world.WorldUtils;
import fi.dy.masa.justenoughdimensions.world.IWorldProviderJED;
import fi.dy.masa.justenoughdimensions.world.WorldInfoJED;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.relauncher.Side;

public class JEDEventHandler {
    private static final Set<String> REDIRECTED_COMMANDS = new HashSet<String>();

    public JEDEventHandler() {
        REDIRECTED_COMMANDS.clear();
        REDIRECTED_COMMANDS.add("defaultgamemode");
        REDIRECTED_COMMANDS.add("difficulty");
        REDIRECTED_COMMANDS.add("gamerule");
        REDIRECTED_COMMANDS.add("seed");
        REDIRECTED_COMMANDS.add("setworldspawn");
        REDIRECTED_COMMANDS.add("time");
        REDIRECTED_COMMANDS.add("weather");
        REDIRECTED_COMMANDS.add("worldborder");
    }

    @SubscribeEvent
    public void onConnectionCreated(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        JustEnoughDimensions.logInfo("FMLNetworkEvent.ServerConnectionFromClientEvent: Syncing dimension data to client", new Object[0]);
        DimensionSyncPacket packet = new DimensionSyncPacket();
        packet.addDimensionData(DimensionConfig.instance().getRegisteredDimensions());
        FMLEmbeddedChannel channel = JustEnoughDimensions.channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DISPATCHER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set(event.getManager().channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
        channel.writeOutbound(new Object[]{packet});
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        int dimension = world.field_73011_w.getDimension();
        JustEnoughDimensions.logInfo("WorldEvent.Load - DIM: {}", dimension);
        if (!world.field_72995_K) {
            JEDEventHandler.overrideWorldInfoAndBiomeProvider(world);
            WorldFileUtils.createTemporaryWorldMarkerIfApplicable(world);
            if (world.field_73011_w.getDimension() != 0) {
                WorldUtils.findAndSetWorldSpawnIfApplicable(world);
                WorldUtils.placeSpawnStructureIfApplicable(world);
            }
            WorldUtils.centerWorldBorderIfApplicable(world);
            if (Configs.enableSeparateWorldBorders) {
                WorldBorderUtils.removeOverworldBorderListener(world);
                world.func_175723_af().func_177737_a((IBorderListener)new JEDBorderListener(dimension));
            }
        } else {
            WorldUtils.overrideWorldProviderIfApplicable(world);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            JustEnoughDimensions.logInfo("WorldEvent.Unload - DIM: {}", event.getWorld().field_73011_w.getDimension());
            WorldUtils.removeTemporaryWorldIfApplicable(event.getWorld());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWorldCreateSpawn(WorldEvent.CreateSpawnPosition event) {
        World world = event.getWorld();
        BlockPos origSpawn = world.func_175694_M();
        JustEnoughDimensions.logInfo("WorldEvent.CreateSpawnPosition - DIM: {}", world.field_73011_w.getDimension());
        JEDEventHandler.overrideWorldInfoAndBiomeProvider(world);
        WorldFileUtils.createTemporaryWorldMarkerIfApplicable(world);
        if (world.field_73011_w.getDimension() == 0) {
            WorldUtils.findAndSetWorldSpawnIfApplicable(world);
            WorldUtils.placeSpawnStructureIfApplicable(world);
        }
        if (!origSpawn.equals((Object)world.func_175694_M()) || world.field_73011_w instanceof IWorldProviderJED && ((IWorldProviderJED)world.field_73011_w).getShouldSkipSpawnSearch()) {
            if (event.getSettings().func_77167_c()) {
                JustEnoughDimensions.logInfo("WorldEvent.CreateSpawnPosition - Generating a bonus chest", new Object[0]);
                WorldUtils.createBonusChest(world);
            }
            JustEnoughDimensions.logInfo("WorldEvent.CreateSpawnPosition - Canceling the normal spawn point search, as JED set the world spawn", new Object[0]);
            event.setCanceled(true);
        }
    }

    private static void overrideWorldInfoAndBiomeProvider(World world) {
        WorldFileUtils.copyTemplateWorldIfApplicable(world);
        if (Configs.enableOverrideWorldProvider) {
            WorldUtils.overrideWorldProviderIfApplicable(world);
        }
        if (Configs.enableSeparateWorldInfo) {
            WorldInfoUtils.loadAndSetCustomWorldInfo(world);
        }
        if (Configs.enableOverrideBiomeProvider) {
            WorldUtils.overrideBiomeProvider(world);
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        WorldFileUtils.saveCustomWorldInfoToFile(event.getWorld());
        if (Configs.enableForcedGameModes && event.getWorld().field_73011_w.getDimension() == 0) {
            DataTracker.getInstance().writeToDisk();
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        JustEnoughDimensions.logInfo("PlayerEvent.PlayerLoggedInEvent - DIM: {}", event.player.func_130014_f_().field_73011_w.getDimension());
        this.syncAndSetPlayerData(event.player);
        DataTracker.getInstance().playerLoginOrRespawn(event.player);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        World world = player.func_130014_f_();
        boolean wasDeath = !event.isEndConquered();
        JustEnoughDimensions.logInfo("PlayerEvent.PlayerRespawnEvent - DIM: {}, death?: {}", world.field_73011_w.getDimension(), wasDeath);
        this.syncAndSetPlayerData(player);
        DataTracker.getInstance().playerLoginOrRespawn(player);
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        JustEnoughDimensions.logInfo("PlayerEvent.PlayerChangedDimensionEvent - DIM: {}", event.player.func_130014_f_().field_73011_w.getDimension());
        this.syncAndSetPlayerData(event.player);
        DataTracker.getInstance().playerChangedDimension(event.player, event.fromDim, event.toDim);
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        EntityPlayerMP player;
        if (event.getEntityLiving() instanceof EntityPlayerMP && (player = (EntityPlayerMP)event.getEntityLiving()).func_130014_f_().func_72912_H().func_76093_s()) {
            int dim = player.func_130014_f_().field_73011_w.getDimension();
            JustEnoughDimensions.logInfo("LivingDeathEvent: Player '{}' died in a hardcore mode dimension {}", player.func_70005_c_(), dim);
            player.func_71033_a(GameType.SPECTATOR);
            player.func_130014_f_().func_82736_K().func_82764_b("spectatorsGenerateChunks", "false");
            DataTracker.getInstance().playerDied((EntityPlayer)player);
        }
    }

    private void syncAndSetPlayerData(EntityPlayer player) {
        WorldBorderUtils.sendWorldBorder(player);
        WorldUtils.syncWorldProviderProperties(player);
        WorldUtils.setupRespawnDimension(player);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
        if (!DimensionManager.isDimensionRegistered((int)event.getDimension())) {
            JustEnoughDimensions.logInfo("EntityTravelToDimensionEvent: Dimension {} is not registered, canceling the TP", event.getDimension());
            event.setCanceled(true);
            return;
        }
        int dimFrom = event.getEntity().func_130014_f_().field_73011_w.getDimension();
        DimensionConfigEntry entryFrom = DimensionConfig.instance().getDimensionConfigFor(dimFrom);
        if (entryFrom != null && entryFrom.getDisableTeleportingFrom()) {
            JustEnoughDimensions.logInfo("EntityTravelToDimensionEvent: Teleporting from DIM {} has been disabled in the dimension config, canceling the TP", dimFrom);
            event.setCanceled(true);
            return;
        }
        DimensionConfigEntry entryTo = DimensionConfig.instance().getDimensionConfigFor(event.getDimension());
        if (entryTo != null && entryTo.getDisableTeleportingTo()) {
            JustEnoughDimensions.logInfo("EntityTravelToDimensionEvent: Teleporting to DIM {} has been disabled in the dimension config, canceling the TP", event.getDimension());
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onPlayerLoadingEvent(PlayerEvent.LoadFromFile event) {
        if (Configs.enableInitialSpawnDimensionOverride && !new File(event.getPlayerDirectory(), event.getPlayerUUID() + ".dat").exists()) {
            WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(Configs.initialSpawnDimensionId);
            EntityPlayer player = event.getEntityPlayer();
            if (world != null && Configs.initialSpawnDimensionId != player.field_71093_bK) {
                player.field_71093_bK = Configs.initialSpawnDimensionId;
                BlockPos pos = !(world.func_72912_H() instanceof DerivedWorldInfo) ? world.func_175694_M() : WorldUtils.findSuitableSpawnpoint((World)world);
                JustEnoughDimensions.logInfo("Player {} joined for the first time, moving them to dimension {}, at {}", player.func_70005_c_(), Configs.initialSpawnDimensionId, pos);
                player.func_174828_a(pos, 0.0f, 0.0f);
                DataTracker.getInstance().playerInitialSpawn(player);
            } else {
                JustEnoughDimensions.logger.warn("Player {} joined for the first time, but the currently set initial spawn dimension {} didn't exist", (Object)event.getEntityPlayer().func_70005_c_(), (Object)Configs.initialSpawnDimensionId);
            }
        }
    }

    @SubscribeEvent
    public void onCommand(CommandEvent event) {
        String command = event.getCommand().func_71517_b();
        if (Configs.enableCommandRedirecting && REDIRECTED_COMMANDS.contains(command) && event.getSender().func_130014_f_().func_72912_H() instanceof WorldInfoJED) {
            String newCommand = "jed " + command + " " + String.join((CharSequence)" ", event.getParameters());
            JustEnoughDimensions.logInfo("Redirecting a vanilla command '/{}' to the JED variant as '/{}'", command, newCommand);
            event.setCanceled(true);
            FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D().func_71556_a(event.getSender(), newCommand);
        }
    }
}

