/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.config;

import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.util.ConfigFileUtils;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.world.GameType;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Configs {
    private static File configDirGlobal;
    private static File configFileGlobal;
    public static String configurationFileName;
    public static Configuration config;
    public static final String CATEGORY_CLIENT = "Client";
    public static final String CATEGORY_CONFIG_HANDLING = "ConfigHandling";
    public static final String CATEGORY_GENERIC = "Generic";
    public static final String CATEGORY_VERSION = "Version";
    public static boolean enableColorOverrides;
    public static boolean enableCommandRedirecting;
    public static boolean enableForcedGameModes;
    public static boolean enableInitialSpawnDimensionOverride;
    public static boolean enableLoggingInfo;
    public static boolean enableOverrideBiomeProvider;
    public static boolean enableOverrideWorldProvider;
    public static boolean enableReplacingRegisteredDimensions;
    public static boolean enableSeparateWorldBorders;
    public static boolean enableSeparateWorldInfo;
    public static boolean enableUnregisteringDimensions;
    public static boolean copyDimensionConfigToWorld;
    public static boolean copyMainConfigToWorld;
    public static boolean usePerWorldDimensionConfig;
    public static boolean usePerWorldMainConfig;
    public static int initialSpawnDimensionId;
    public static GameType normalGameMode;

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("justenoughdimensions".equals(event.getModID())) {
            Configs.loadConfigs(config);
        }
    }

    public static File getConfigDir() {
        return configDirGlobal;
    }

    public static void loadConfigsFromMainConfigFile(File configDirCommon) {
        File configDir = new File(configDirCommon, "justenoughdimensions");
        File configFile = new File(configDir, "justenoughdimensions.cfg");
        configDirGlobal = configDir;
        configFileGlobal = configFile;
        ConfigFileUtils.createDirIfNotExists(configDir);
        File oldFile = new File(configDirCommon, "justenoughdimensions.cfg");
        ConfigFileUtils.tryCopyOrMoveConfigIfMissingOrOlder(configFile, oldFile, ConfigFileUtils.FileAction.MOVE, new ConfigComparatorMainConfig());
        Configs.loadConfigsFromFile(configFile);
    }

    public static void loadConfigsFromPerWorldConfigIfEnabled(@Nullable File worldDir) {
        if (worldDir != null) {
            File configDir = new File(new File(worldDir, "data"), "justenoughdimensions");
            File configFile = new File(configDir, "justenoughdimensions.cfg");
            if (copyMainConfigToWorld) {
                ConfigFileUtils.createDirIfNotExists(configDir);
                ConfigFileUtils.tryCopyOrMoveConfigIfMissingOrOlder(configFile, configFileGlobal, ConfigFileUtils.FileAction.COPY, new ConfigComparatorMainConfig());
            }
            if (usePerWorldMainConfig && configFile.exists() && configFile.isFile() && configFile.canRead()) {
                Configs.loadConfigsFromFile(configFile);
                return;
            }
        }
        Configs.loadConfigsFromFile(configFileGlobal);
    }

    public static void loadConfigsFromGlobalConfigFile() {
        Configs.loadConfigsFromFile(configFileGlobal);
    }

    private static void loadConfigsFromFile(File configFile) {
        configurationFileName = configFile.toString();
        config = new Configuration(configFile, null, true);
        Configs.reloadConfigsFromFile();
    }

    public static boolean reloadConfigsFromFile() {
        if (config != null) {
            JustEnoughDimensions.logger.info("Reloading the main configs from file '{}'", (Object)config.getConfigFile().getAbsolutePath());
            config.load();
            Configs.loadConfigs(config);
            return true;
        }
        return false;
    }

    public static void loadConfigs(Configuration conf) {
        Property prop = conf.get(CATEGORY_CONFIG_HANDLING, "copyDimensionConfigToWorld", true).setRequiresWorldRestart(true).setRequiresMcRestart(false);
        prop.setComment("If enabled, then the dimension config ('dimensions.json')\nwill be copied to each save and used from there, to avoid changes in the\nglobal/pack config from breaking the saves due to possibly differing settings between worlds.\nNOTE: This option ONLY affects whether or not the config is automatically _copied to_ each world.");
        copyDimensionConfigToWorld = prop.getBoolean();
        prop = conf.get(CATEGORY_CONFIG_HANDLING, "copyMainConfigToWorld", true).setRequiresWorldRestart(true).setRequiresMcRestart(false);
        prop.setComment("If enabled, then the \"main config\" ('justenoughdimensions.cfg')\nwill be copied to each save and used from there, to avoid changes in the\nglobal/pack config from breaking the saves due to possibly differing settings between worlds.\nNOTE: This option ONLY affects whether or not the config is automatically _copied to_ each world.");
        copyMainConfigToWorld = prop.getBoolean();
        prop = conf.get(CATEGORY_CONFIG_HANDLING, "usePerWorldDimensionConfig", false).setRequiresWorldRestart(true).setRequiresMcRestart(false);
        prop.setComment("If enabled, then the dimension config ('dimensions.json')\nwill read from within each world/save, if it exists there.\nAlso see the option 'copyDimensionConfigToWorld' to enable automatically copying it there.");
        usePerWorldDimensionConfig = prop.getBoolean();
        prop = conf.get(CATEGORY_CONFIG_HANDLING, "usePerWorldMainConfig", false).setRequiresWorldRestart(true).setRequiresMcRestart(false);
        prop.setComment("If enabled, then the \"main config\" ('justenoughdimensions.cfg')\nwill read from within each world/save, if it exists there.\nAlso see the option 'copyMainConfigToWorld' to enable automatically copying it there.");
        usePerWorldMainConfig = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "enableCommandRedirecting", true).setRequiresMcRestart(false);
        prop.setComment("Enables redirecting the vanilla /time, /weather etc. commands to the JED variants in WorldInfo-overridden dimensions");
        enableCommandRedirecting = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "enableForcedGameModes", false).setRequiresMcRestart(false);
        prop.setComment("Enables switching players' gamemode when they enter a dimension which has the ForceGameMode option set to true");
        enableForcedGameModes = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "enableInitialSpawnDimensionOverride", false).setRequiresMcRestart(false);
        prop.setComment("Enables overriding the initial spawning dimension to something other than dim 0 (overworld).");
        enableInitialSpawnDimensionOverride = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "enableLoggingInfo", false).setRequiresMcRestart(false);
        prop.setComment("Enables a bunch of extra logging on the INFO level for registrations etc.");
        enableLoggingInfo = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "enableOverrideBiomeProvider", true).setRequiresMcRestart(false);
        prop.setComment("If enabled, then a '\"biome\": \"registrynameofbiome\"' value in the dimensions.json config will override the\nBiomeProvider of that dimension with BiomeProviderSingle, using the biome given as the value.\nThis means that the entire dimension will use only that one biome set in the config.\nTo get the registry names of biomes, you can use the TellMe mod (the command '/tellme dump biomes').");
        enableOverrideBiomeProvider = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "enableOverrideWorldProvider", false);
        prop.setComment("If enabled, then a '\"WorldProviderOverride\": \"class name\"' value in JED options in the dimensions.json config\nwill override the WorldProvider of that dimension with one created by the provided class name.\nNOTE: This is normally not recommended!!!\nThis is provided for certain mod compatibility cases,\nwhere the other mod is checking the DimensionType against one of the vanilla values, and thus\nyou have to use an \"existing_dimensiontype\" key in the \"dimensiontype\" object, instead of\nregistering/defining a new custom entry as you would do normally.");
        enableOverrideWorldProvider = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "enableReplacingRegisteredDimensions", true).setRequiresMcRestart(false);
        prop.setComment("If enabled, then an 'override: true' boolean value for the dimension in\nthe dimensions.json config can be used to override an existing dimension.");
        enableReplacingRegisteredDimensions = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "enableUnregisteringDimensions", false).setRequiresMcRestart(false);
        prop.setComment("If enabled, then an 'unregister: true' boolean value for the dimension in\nthe dimensions.json config can be used to unregister existing dimension.");
        enableUnregisteringDimensions = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "enableSeparateWorldBorders", false).setRequiresWorldRestart(true).setRequiresMcRestart(false);
        prop.setComment("If enabled, adds custom WorldBorder syncing and removes default linking from other dimensions to the overworld border.");
        enableSeparateWorldBorders = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "enableSeparateWorldInfo", true).setRequiresWorldRestart(true).setRequiresMcRestart(false);
        prop.setComment("If enabled, all dimensions that exist in dimensions.json and have either a\"worldinfo\" or a \"worldinfo_onetime\" value present (an empty object is enough),\nwill use separate WorldInfo instances (separate time, weather, world border, gamerules etc.).\nThis works even if the dimension in question isn't registered by this mod\n(so vanilla, or other mod dimensions can have it too).");
        enableSeparateWorldInfo = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "initialSpawnDimensionId", 0).setRequiresWorldRestart(true).setRequiresMcRestart(false);
        prop.setComment("If enabled with the enableInitialSpawnDimensionOverride option, this will be used as the initial spawn dimension ID");
        initialSpawnDimensionId = prop.getInt();
        prop = conf.get(CATEGORY_GENERIC, "normalGameMode", "survival");
        prop.setComment("If the players first join into a ForceGameMode dimension, then this option sets the \"normal\"\ngame mode they should get when they leave that dimension for a non-ForceGameMode dimension.\nValid values are: adventure, creative, spectator and survival");
        Configs.setNormalGameMode(prop.getString());
        prop = conf.get(CATEGORY_VERSION, "configId", "__default").setRequiresMcRestart(false);
        prop.setComment("For the config file copying/replacement to happen, this id\nin the old per-world config must match the id in the current global/common config,\nfor the automatic config upgrade/override from the global config to the per-world config to happen.");
        prop = conf.get(CATEGORY_VERSION, "version", 0).setRequiresMcRestart(false);
        prop.setComment("Config version tracking.\nIf you are a mod pack developer and need to force a config change\nfor users (when using the per-world configs option), increase the version number here\nto tell the mod to copy this config version over an existing, older, per-world config.\nAlso note that the 'configId' value should be set to something mod pack specific,\nbasically to tie the per-world configs to the pack in question,\nand not overwrite the per-world config with one from a different pack.\n(Although it probably would be extremely rare for anyone to try to load the same world in a different pack...)");
        prop = conf.get(CATEGORY_CLIENT, "enableColorOverrides", true).setRequiresMcRestart(false);
        prop.setComment("Enables the Grass/Foliage/Water color customizations. This controls whether or not the event handlers get registered.");
        enableColorOverrides = prop.getBoolean();
        if (enableColorOverrides) {
            JustEnoughDimensions.proxy.registerClientEventHandler();
        } else {
            JustEnoughDimensions.proxy.unregisterClientEventHandler();
        }
        if (conf.hasChanged()) {
            conf.save();
        }
    }

    private static void setNormalGameMode(String name) {
        if (name.equalsIgnoreCase("adventure")) {
            normalGameMode = GameType.ADVENTURE;
        } else if (name.equalsIgnoreCase("creative")) {
            normalGameMode = GameType.CREATIVE;
        } else if (name.equalsIgnoreCase("spectator")) {
            normalGameMode = GameType.SPECTATOR;
        } else if (name.equalsIgnoreCase("survival")) {
            normalGameMode = GameType.SURVIVAL;
        } else {
            JustEnoughDimensions.logger.warn("Configs: Invalid normalGameMode value '{}', falling back to 'survival'", (Object)name);
            normalGameMode = GameType.SURVIVAL;
        }
    }

    static {
        normalGameMode = GameType.SURVIVAL;
    }

    public static class ConfigComparatorMainConfig
    extends ConfigFileUtils.ConfigComparator {
        @Override
        public boolean shouldReplace(File fileToReplace, File replacementFile) {
            if (!fileToReplace.exists()) {
                return true;
            }
            if (fileToReplace.exists() && fileToReplace.isFile() && fileToReplace.canRead() && replacementFile.exists() && replacementFile.isFile() && replacementFile.canRead()) {
                Configuration confOld = new Configuration(fileToReplace, null, true);
                Configuration confNew = new Configuration(replacementFile, null, true);
                if (confOld.hasKey(Configs.CATEGORY_VERSION, "configId") && confNew.hasKey(Configs.CATEGORY_VERSION, "configId")) {
                    String idOld = confOld.get(Configs.CATEGORY_VERSION, "configId", "").getString();
                    String idNew = confNew.get(Configs.CATEGORY_VERSION, "configId", "").getString();
                    int versionOld = confOld.get(Configs.CATEGORY_VERSION, "version", 0).getInt();
                    int versionNew = confNew.get(Configs.CATEGORY_VERSION, "version", 0).getInt();
                    return idOld.equals(idNew) && versionNew > versionOld;
                }
            }
            return false;
        }
    }
}

