/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.rendering;

import com.rwtema.funkylocomotion.blocks.TileMovingClient;
import com.rwtema.funkylocomotion.fakes.FakeWorldClient;
import com.rwtema.funkylocomotion.rendering.FLRenderHelper;
import com.rwtema.funkylocomotion.rendering.PassHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;

public class TESRMoving
extends TileEntitySpecialRenderer<TileMovingClient> {
    public static final TESRMoving INSTANCE = new TESRMoving();
    private BlockRendererDispatcher blockRenderer;

    public final void render(TileMovingClient te, double x, double y, double z, float partialTicks, int destroyStage, float partial) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        this.func_147499_a(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179147_l();
        GlStateManager.func_179089_o();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        this.renderTileEntityFast(te, x, y, z, partialTicks, destroyStage, partial, renderer);
        renderer.func_178969_c(0.0, 0.0, 0.0);
        RenderHelper.func_74519_b();
    }

    public void renderTileEntityFast(TileMovingClient te, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder renderer) {
        if (this.blockRenderer == null) {
            this.blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        }
        if (!te.init) {
            return;
        }
        if (te.maxTime == 0 || te.block == Blocks.field_150350_a) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        double h = te.offset(true);
        int dir = te.dir;
        if (dir == -1) {
            return;
        }
        this.func_147499_a(TextureMap.field_110575_b);
        boolean flag = false;
        int pass = MinecraftForgeClient.getRenderPass();
        if (te.render && te.getState().func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            GlStateManager.func_179094_E();
            renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            this.setupTranslations(x, y, z, te, h, dir, renderer);
            flag = this.renderStatic(te, pass, renderer);
            if (pass == 1) {
                BlockPos pos = te.func_174877_v();
                if (dir < 6) {
                    EnumFacing dir1 = EnumFacing.values()[dir];
                    renderer.func_181674_a(-((float)(x - (double)pos.func_177958_n() + (double)dir1.func_82601_c() * h)), -((float)(y - (double)pos.func_177956_o() + (double)dir1.func_96559_d() * h)), -((float)(z - (double)pos.func_177952_p() + (double)dir1.func_82599_e() * h)));
                } else {
                    renderer.func_181674_a(-((float)(x - (double)pos.func_177958_n())), -((float)(y - (double)pos.func_177956_o())), -((float)(z - (double)pos.func_177952_p())));
                }
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179089_o();
        }
        flag |= this.renderDynamic(x, y, z, partialTicks, partial, te, h, dir, pass, renderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean renderDynamic(double x, double y, double z, float f, float partial, TileMovingClient mover, double h, int dir, int pass, BufferBuilder renderer) {
        if (mover.tile == null || !mover.tile.shouldRenderInPass(pass)) {
            return false;
        }
        World world = mover.func_145831_w();
        if (!FakeWorldClient.isValid(world)) {
            return false;
        }
        FakeWorldClient fakeWorldClient = FakeWorldClient.getFakeWorldWrapper(world);
        EnumFacing dir1 = mover.getDir();
        if (dir1 != null) {
            fakeWorldClient.offset = mover.offset(true);
            fakeWorldClient.dir = dir1;
        } else {
            fakeWorldClient.offset = 0.0;
            fakeWorldClient.dir = null;
        }
        fakeWorldClient.dir_id = mover.dir;
        TileEntitySpecialRenderer specialRenderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(mover.tile);
        if (specialRenderer == null) {
            return false;
        }
        if (!mover.tile.shouldRenderInPass(pass)) {
            return false;
        }
        GlStateManager.func_179094_E();
        this.setupTranslations(x, y, z, mover, h, dir, renderer);
        try {
            WorldClient prevWorld1 = Minecraft.func_71410_x().field_71441_e;
            World prevWorld2 = Minecraft.func_71410_x().field_71439_g.field_70170_p;
            World prevWorld3 = this.field_147501_a.field_147550_f;
            try {
                Minecraft.func_71410_x().field_71441_e = fakeWorldClient;
                Minecraft.func_71410_x().field_71439_g.field_70170_p = fakeWorldClient;
                TileEntityRendererDispatcher.field_147556_a.field_147550_f = fakeWorldClient;
                renderer.func_178969_c(0.0, 0.0, 0.0);
                mover.tile.func_145836_u();
                RenderHelper.func_74519_b();
                specialRenderer.func_192841_a(mover.tile, (double)mover.func_174877_v().func_177958_n(), (double)mover.func_174877_v().func_177956_o(), (double)mover.func_174877_v().func_177952_p(), f, -1, partial);
                RenderHelper.func_74518_a();
                renderer.func_178969_c(0.0, 0.0, 0.0);
            }
            finally {
                Minecraft.func_71410_x().field_71441_e = prevWorld1;
                Minecraft.func_71410_x().field_71439_g.field_70170_p = prevWorld2;
                TileEntityRendererDispatcher.field_147556_a.field_147550_f = prevWorld3;
            }
        }
        catch (Exception e) {
            FLRenderHelper.clearTessellator();
            new RuntimeException("Unable to render TSER " + mover.tile.getClass().getName() + " for " + Block.field_149771_c.func_177774_c((Object)mover.block) + " with meta " + mover.meta + " at (" + mover.func_174877_v() + "). Disabling Rendering.", e).printStackTrace();
            TileMovingClient.renderErrorList.add(mover.tile.getClass());
            mover.error = true;
            mover.tile = null;
            mover.render = false;
        }
        GlStateManager.func_179121_F();
        return true;
    }

    private void setupTranslations(double x, double y, double z, TileMovingClient mover, double h, int dir, BufferBuilder renderer) {
        BlockPos pos = mover.func_174877_v();
        if (dir < 6) {
            EnumFacing dir1 = EnumFacing.values()[dir];
            renderer.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179137_b((double)(x - (double)pos.func_177958_n() + (double)dir1.func_82601_c() * h), (double)(y - (double)pos.func_177956_o() + (double)dir1.func_96559_d() * h), (double)(z - (double)pos.func_177952_p() + (double)dir1.func_82599_e() * h));
        } else {
            renderer.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
            double dh = dir == 6 ? h + 1.0 : -h;
            GlStateManager.func_179139_a((double)dh, (double)dh, (double)dh);
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
            GlStateManager.func_179109_b((float)(-pos.func_177958_n()), (float)(-pos.func_177956_o()), (float)(-pos.func_177952_p()));
        }
    }

    private boolean renderStatic(TileMovingClient tile, int pass, BufferBuilder vertexbuffer) {
        IBlockState state = tile.getState();
        Block block = state.func_177230_c();
        FakeWorldClient fakeWorldWrapper = FakeWorldClient.getFakeWorldWrapper(tile.func_145831_w());
        EnumFacing dir1 = tile.getDir();
        if (dir1 != null) {
            fakeWorldWrapper.offset = tile.offset(true);
            fakeWorldWrapper.dir = dir1;
        } else {
            fakeWorldWrapper.offset = 0.0;
            fakeWorldWrapper.dir = null;
        }
        fakeWorldWrapper.dir_id = tile.dir;
        boolean flag = false;
        for (BlockRenderLayer blockrenderlayer1 : PassHandler.getHandler((int)pass).layers) {
            if (!block.canRenderInLayer(state, blockrenderlayer1)) continue;
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)blockrenderlayer1);
            if (block.func_176223_P().func_185901_i() == EnumBlockRenderType.INVISIBLE) continue;
            flag |= this.blockRenderer.func_175018_a(state, tile.func_174877_v(), (IBlockAccess)fakeWorldWrapper, vertexbuffer);
        }
        ForgeHooksClient.setRenderLayer(null);
        return flag;
    }
}

