/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.helper;

import java.util.function.Supplier;

public class LazyField<T>
implements Supplier<T> {
    private static final Object NULL = new Object();
    private final Supplier<T> supplier;
    Object value;

    public LazyField(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public T get() {
        Object value = this.value;
        if (value == null) {
            T t = this.supplier.get();
            this.value = t != null ? t : NULL;
            value = this.value;
        }
        return (T)(value != NULL ? value : null);
    }

    public T compute() {
        T t = this.supplier.get();
        this.value = t != null ? t : NULL;
        Object value = this.value;
        return (T)(value != NULL ? value : null);
    }

    public void clearCache() {
        this.value = null;
    }
}

