/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.common.integration.modsupport;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.softc.armoryexpansion.common.integration.aelib.integration.JsonIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;

@Mod(modid="armoryexpansion-custommaterials", name="Armory Expansion - Custom Materials", version="1.3.1", dependencies="required-after:armoryexpansion; ", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class CustomMaterialsIntegration
extends JsonIntegration {
    private static final String INTEGRATION_ID = "custommaterials";
    private static final String INTEGRATION_NAME = "Custom Materials";
    static final String MODID = "armoryexpansion-custommaterials";
    static final String NAME = "Armory Expansion - Custom Materials";
    static final String DEPENDENCIES = "required-after:armoryexpansion; ";
    private static File configDir;

    public CustomMaterialsIntegration() {
        super(INTEGRATION_ID, "armoryexpansion", INTEGRATION_ID);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.modid = INTEGRATION_ID;
        this.enableForceJsonCreation();
        configDir = event.getModConfigurationDirectory();
        super.preInit(event);
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        this.exportAllTraitsToJson(configDir);
        this.exportAllPartsToJson(configDir);
    }

    @Override
    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        super.registerBlocks(event);
    }

    private void exportAllTraitsToJson(File configDir) {
        HashSet traits = new HashSet();
        TinkerRegistry.getAllMaterials().forEach(m -> m.getAllTraits().forEach(t -> traits.add(t.getIdentifier())));
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting().setLenient();
        Gson gson = builder.create();
        File output = new File(configDir.getPath() + "/armoryexpansion/traits.txt");
        try {
            FileWriter writer = new FileWriter(output);
            writer.write(gson.toJson(traits));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void exportAllPartsToJson(File configDir) {
    }

    @Override
    protected void loadMaterialsFromSource() {
    }

    @Override
    protected void loadAlloysFromSource() {
    }
}

