/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.entity;

import net.minecraft.entity.Entity;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntityListWrapper;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.api.spell.wrapper.EntityListWrapper;
import vazkii.psi.common.spell.trick.entity.PieceTrickBlink;

public class PieceTrickMassBlink
extends PieceTrick {
    SpellParam target;
    SpellParam distance;

    public PieceTrickMassBlink(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.target = new ParamEntityListWrapper("psi.spellparam.target", SpellParam.YELLOW, false, false);
        this.addParam(this.target);
        this.distance = new ParamNumber("psi.spellparam.distance", SpellParam.RED, false, true);
        this.addParam(this.distance);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double distanceVal = (Double)this.getParamEvaluation(this.distance);
        if (distanceVal == null) {
            distanceVal = 1.0;
        }
        meta.addStat(EnumSpellStat.POTENCY, (int)(Math.abs(distanceVal) * 80.0));
        meta.addStat(EnumSpellStat.COST, (int)(Math.abs(distanceVal) * 100.0));
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        EntityListWrapper targetVal = (EntityListWrapper)this.getParamValue(context, this.target);
        Double distanceVal = (Double)this.getParamValue(context, this.distance);
        for (Entity e : targetVal) {
            PieceTrickBlink.blink(context, e, distanceVal);
        }
        return null;
    }
}

