/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.lib;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public final class LibObfuscation {
    public static final String REMAINING_HIGHLIGHT_TICKS = "field_92017_k";
    public static final String CAPTURE_CURRENT_POSITION = "func_184342_d";

    public static void getDescriptor(Class<?> type, StringBuilder buf) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                buf.append('Z');
            } else if (type == Byte.TYPE) {
                buf.append('B');
            } else if (type == Character.TYPE) {
                buf.append('C');
            } else if (type == Double.TYPE) {
                buf.append('D');
            } else if (type == Float.TYPE) {
                buf.append('F');
            } else if (type == Integer.TYPE) {
                buf.append('I');
            } else if (type == Long.TYPE) {
                buf.append('J');
            } else if (type == Short.TYPE) {
                buf.append('S');
            } else if (type == Void.TYPE) {
                buf.append('V');
            }
        } else if (type.isArray()) {
            buf.append(type.getName());
        } else {
            buf.append('L').append(type.getName().replace('.', '/')).append(';');
        }
    }

    public static String getMethodDescriptor(Class<?> returnType, Class<?> ... argumentTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        for (Class<?> argumentType : argumentTypes) {
            LibObfuscation.getDescriptor(argumentType, buf);
        }
        buf.append(')');
        LibObfuscation.getDescriptor(returnType, buf);
        return buf.toString();
    }

    public static String remapMethodName(String className, String methodName, @Nonnull Class<?> returnType, Class<?> ... parameterTypes) {
        String internalClassName = FMLDeobfuscatingRemapper.INSTANCE.unmap(className.replace('.', '/'));
        String signature = FMLDeobfuscatingRemapper.INSTANCE.mapSignature(LibObfuscation.getMethodDescriptor(returnType, parameterTypes), false);
        return FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(internalClassName, methodName, signature);
    }

    public static Method findMethod(@Nonnull Class<?> clazz, @Nonnull String methodName, @Nonnull Class<?> returnType, Class<?> ... parameterTypes) {
        return ReflectionHelper.findMethod(clazz, (String)LibObfuscation.remapMethodName(clazz.getName(), methodName, returnType, parameterTypes), (String)methodName, (Class[])parameterTypes);
    }

    public static <T> Object callMethod(@Nonnull Class<? extends T> clazz, T instance, @Nonnull String methodName, Class<?>[] parameterTypes, @Nonnull Class<?> returnType, Object ... arguments) {
        Method method = LibObfuscation.findMethod(clazz, methodName, returnType, parameterTypes);
        try {
            return method.invoke(instance, arguments);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            FMLLog.log.error("Unable to access method {} on type {}", (Object)methodName, (Object)clazz.getName());
            throw new RuntimeException(e);
        }
    }
}

