/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.render.entity;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import vazkii.psi.api.cad.ICADColorizer;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.common.Psi;
import vazkii.psi.common.entity.EntitySpellCircle;

public class RenderSpellCircle
extends Render<EntitySpellCircle> {
    private static final ResourceLocation[] layers = new ResourceLocation[]{new ResourceLocation(String.format("psi:textures/misc/spell_circle%d.png", 0)), new ResourceLocation(String.format("psi:textures/misc/spell_circle%d.png", 1)), new ResourceLocation(String.format("psi:textures/misc/spell_circle%d.png", 2))};
    private static final float BRIGHTNESS_FACTOR = 0.7f;

    public RenderSpellCircle(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(@Nonnull EntitySpellCircle entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        int colorVal = 1295871;
        ItemStack colorizer = (ItemStack)entity.func_184212_Q().func_187225_a(EntitySpellCircle.COLORIZER_DATA);
        if (!colorizer.func_190926_b() && colorizer.func_77973_b() instanceof ICADColorizer) {
            colorVal = Psi.proxy.getColorForColorizer(colorizer);
        }
        float alive = (float)entity.getTimeAlive() + partialTicks;
        float s1 = Math.min(1.0f, alive / 5.0f);
        if (alive > 105.0f) {
            s1 = 1.0f - Math.min(1.0f, Math.max(0.0f, alive - 105.0f) / 5.0f);
        }
        RenderSpellCircle.renderSpellCircle(alive, s1, x, y, z, colorVal);
    }

    public static void renderSpellCircle(float alive, float scale, double x, double y, double z, int color) {
        RenderSpellCircle.renderSpellCircle(alive, scale, 1.0f, x, y, z, 0.0f, 1.0f, 0.0f, color);
    }

    public static void renderSpellCircle(float alive, float scale, float horizontalScale, double x, double y, double z, float xDir, float yDir, float zDir, int color) {
        GlStateManager.func_179094_E();
        double ratio = 0.0625 * (double)horizontalScale;
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        float mag = xDir * xDir + yDir * yDir + zDir * zDir;
        if ((zDir /= mag) == -1.0f) {
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (zDir != 1.0f) {
            GlStateManager.func_179114_b((float)((float)(Math.acos(zDir) * 180.0 / Math.PI)), (float)(-yDir / mag), (float)(xDir / mag), (float)0.0f);
        }
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.1);
        GlStateManager.func_179139_a((double)(ratio * (double)scale), (double)(ratio * (double)scale), (double)ratio);
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        float lastBrightnessX = OpenGlHelper.lastBrightnessX;
        float lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        int r = PsiRenderHelper.r(color);
        int g = PsiRenderHelper.g(color);
        int b = PsiRenderHelper.b(color);
        for (int i = 0; i < layers.length; ++i) {
            int rValue = r;
            int gValue = g;
            int bValue = b;
            if (i == 1) {
                bValue = 255;
                gValue = 255;
                rValue = 255;
            } else if (i == 2) {
                int minBrightness = 3;
                if (rValue == 0 && gValue == 0 && bValue == 0) {
                    gValue = bValue = minBrightness;
                    rValue = bValue;
                }
                if (rValue > 0 && rValue < minBrightness) {
                    rValue = minBrightness;
                }
                if (gValue > 0 && gValue < minBrightness) {
                    gValue = minBrightness;
                }
                if (bValue > 0 && bValue < minBrightness) {
                    bValue = minBrightness;
                }
                rValue = (int)Math.min((float)rValue / 0.7f, 255.0f);
                gValue = (int)Math.min((float)gValue / 0.7f, 255.0f);
                bValue = (int)Math.min((float)bValue / 0.7f, 255.0f);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)(i == 0 ? -alive : alive), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179124_c((float)((float)rValue / 255.0f), (float)((float)gValue / 255.0f), (float)((float)bValue / 255.0f));
            Minecraft.func_71410_x().field_71446_o.func_110577_a(layers[i]);
            Gui.func_146110_a((int)-32, (int)-32, (float)0.0f, (float)0.0f, (int)64, (int)64, (float)64.0f, (float)64.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.5);
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
        GlStateManager.func_179089_o();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation getEntityTexture(@Nonnull EntitySpellCircle entity) {
        return null;
    }
}

