/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki;

import codechicken.lib.colour.ColourARGB;
import com.brandon3055.brandonscore.client.gui.modulargui_old.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui_old.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui_old.lib.EnumAlignment;
import com.brandon3055.brandonscore.client.gui.modulargui_old.lib.IMGuiListener;
import com.brandon3055.brandonscore.client.gui.modulargui_old.lib.IScrollListener;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiButtonSolid;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiHoverPopup;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiList;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiScrollBar;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiSelectDialog;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import com.brandon3055.draconicevolution.client.gui.modwiki.GuiModWiki;
import com.brandon3055.draconicevolution.client.gui.modwiki.WikiConfig;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.WikiDocManager;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DisplayComponentBase;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DisplayComponentRegistry;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree.TreeBranchRoot;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WikiContentWindow
extends MGuiList
implements IMGuiListener {
    private GuiModWiki guiModWiki;
    public TreeBranchRoot activeBranch;
    public MGuiLabel label;
    private boolean initialized = false;
    public DisplayComponentBase editingComponent = null;
    public LinkedList<MGuiElementBase> editControls = new LinkedList();
    public MGuiButtonSolid add;
    public MGuiButtonSolid delete;
    public MGuiSelectDialog addSelector;

    public WikiContentWindow(GuiModWiki parentGui) {
        super((IModularGui)parentGui);
        this.guiModWiki = parentGui;
        this.topPadding = 12;
        this.rightPadding = 4;
    }

    public void initElement() {
        this.toRemove.addAll(this.childElements);
        this.label = new MGuiLabel((IModularGui)this.guiModWiki, this.xPos, this.yPos + 1, this.xSize, 12, this.activeBranch.branchID.equals("ROOT") ? "Project Intelligence" : this.activeBranch.branchName){

            public int getTextColour() {
                return WikiConfig.NAV_TEXT;
            }

            public boolean getDropShadow() {
                ColourARGB colour = new ColourARGB(WikiConfig.NAV_TEXT);
                long l = ((colour.r & 0xFF) + (colour.g & 0xFF) + (colour.b & 0xFF)) / 3;
                return l > 80L;
            }
        }.setAlignment(EnumAlignment.LEFT);
        this.addChild((MGuiElementBase)this.label);
        this.delete = (MGuiButtonSolid)new MGuiButtonSolid((IModularGui)this.guiModWiki, "DELETE", this.xPos + this.xSize - 12, this.yPos, 12, 12, "X"){

            public int getFillColour(boolean hovering, boolean disabled) {
                return disabled ? -8947849 : (hovering ? -1 : -65536);
            }

            public int getBorderColour(boolean hovering, boolean disabled) {
                return disabled ? -11184811 : (hovering ? -65536 : -1);
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Delete Selected Display Component"});
        this.addChild((MGuiElementBase)this.delete);
        this.delete.disabled = true;
        this.add = (MGuiButtonSolid)new MGuiButtonSolid(this.modularGui, "ADD", this.xPos + this.xSize - 38, this.yPos, 25, 12, "Add"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Add New Display Component"});
        this.addChild((MGuiElementBase)this.add);
        this.delete.setEnabled(WikiConfig.editMode && this.activeBranch.branchData != null);
        this.add.setEnabled(WikiConfig.editMode && this.activeBranch.branchData != null);
        super.initElement();
        this.initialized = true;
    }

    protected void initScrollBar() {
        this.scrollBar = new MGuiScrollBar(this.modularGui, this.xPos + this.xSize - 5, this.yPos + 11, 6, this.ySize - 12){

            public int getScrollColour() {
                return 4.mixColours((int)WikiConfig.CONTENT_WINDOW, (int)0x505050);
            }
        };
        this.scrollBar.addChild((MGuiElementBase)new MGuiHoverPopup(this.modularGui, new String[]{"Pro Tip.", "Hold shift while scrolling to scroll faster!"}, (MGuiElementBase)this.scrollBar));
        this.scrollBar.borderColour = 0;
        this.scrollBar.backColour = 0;
        this.addChild((MGuiElementBase)this.scrollBar);
        this.scrollBar.setListener((IScrollListener)this);
        this.scrollBar.parentScrollable = this;
    }

    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        int navWindowColour = WikiConfig.CONTENT_WINDOW;
        int neg15 = WikiContentWindow.mixColours((int)navWindowColour, (int)0x151515, (boolean)true);
        int pos20 = WikiContentWindow.mixColours((int)navWindowColour, (int)0x202020);
        int neg30 = WikiContentWindow.mixColours((int)navWindowColour, (int)0x303030, (boolean)true);
        this.drawColouredRect(this.xPos, this.yPos, this.xSize, this.ySize, navWindowColour);
        this.drawColouredRect(this.xPos, this.yPos, this.xSize, 0.5, pos20);
        this.drawColouredRect(this.xPos, (double)this.yPos + 0.5, this.xSize, 0.6, neg15);
        this.drawColouredRect(this.xPos, this.yPos + 1, this.xSize, 11.0, WikiContentWindow.mixColours((int)navWindowColour, (int)526344, (boolean)true));
        this.drawColouredRect(this.xPos, (double)this.yPos + 11.5, this.xSize, 0.5, neg30);
        this.drawColouredRect(this.xPos, this.yPos + this.ySize - 1, this.xSize, 1.0, neg30);
        this.drawColouredRect(this.xPos, this.yPos, 0.6, this.ySize, pos20);
        this.drawColouredRect((double)this.xPos + 0.6, (double)this.yPos + 0.5, 0.6, this.ySize - 1, neg15);
        this.drawColouredRect((double)(this.xPos + this.xSize) - 0.6, this.yPos, 0.6, 12.0, pos20);
        this.drawColouredRect((double)(this.xPos + this.xSize) - 1.2, (double)this.yPos + 0.5, 0.6, 11.0, neg15);
        if (this.scrollBar.isEnabled() && GuiHelper.isInRect((int)this.scrollBar.xPos, (int)this.scrollBar.yPos, (int)this.scrollBar.xSize, (int)this.scrollBar.ySize, (int)mouseX, (int)mouseY)) {
            this.drawColouredRect(this.xPos + this.xSize - 4, this.yPos + 12, 4.0, this.ySize - 12, WikiContentWindow.mixColours((int)this.scrollBar.scrollColour, (int)-872415232, (boolean)true));
        }
        if (this.activeBranch.branchData == null) {
            this.drawString(this.fontRenderer, "[Error: Failed to load page content]", this.xPos + 3, this.yPos + 15, 0xFF0000);
        }
        super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    public void renderForegroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderForegroundLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    public void updatePositions() {
        if (!this.initialized) {
            return;
        }
        this.label.xPos = this.xPos;
        this.label.yPos = this.yPos + 1;
        this.label.xSize = this.xSize;
    }

    public void setEditingComponent(DisplayComponentBase component) {
        this.topPadding = 12;
        if (!this.initialized) {
            return;
        }
        if (this.editingComponent != null) {
            this.editingComponent.isBeingEdited = false;
            if (this.editingComponent.requiresSave) {
                this.editingComponent.requiresSave = false;
                this.editingComponent.save();
            }
        }
        this.editingComponent = component;
        this.toRemove.addAll(this.editControls);
        this.editControls.clear();
        boolean bl = this.delete.disabled = component == null;
        if (this.editingComponent == null) {
            this.label.setEnabled(true);
            this.updateEntriesAndScrollBar();
            return;
        }
        this.editingComponent.isBeingEdited = true;
        this.label.setEnabled(false);
        this.editControls.addAll(this.editingComponent.getEditControls());
        int offset = 0;
        int yOffset = 0;
        for (MGuiElementBase element : this.editControls) {
            if (this.xPos + offset + element.xSize > this.xPos + this.xSize - 40) {
                offset = 0;
                this.topPadding = 12 + (yOffset += 12);
            }
            this.addChild(element);
            element.xPos = this.xPos + offset;
            offset += element.xSize + 1;
            element.yPos = this.yPos + yOffset;
        }
        this.updateEntriesAndScrollBar();
    }

    public void onMGuiEvent(String eventString, MGuiElementBase eventElement) {
        if (eventElement == this.delete && this.editingComponent != null) {
            this.editingComponent.element.getParentNode().removeChild(this.editingComponent.element);
            try {
                this.activeBranch.save();
                WikiDocManager.reload(false, true, true);
                this.guiModWiki.wikiDataTree.reOpenLast();
                this.setEditingComponent(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (eventElement == this.add) {
            if (this.addSelector != null) {
                this.modularGui.getManager().remove((MGuiElementBase)this.addSelector);
                this.addSelector = null;
                return;
            }
            this.addSelector = new MGuiSelectDialog(this.modularGui, this.xPos, this.yPos, 10, 50);
            ArrayList<MGuiLabel> list = new ArrayList<MGuiLabel>();
            int width = 10;
            for (String option : DisplayComponentRegistry.REGISTRY.keySet()) {
                int optionWidth = this.fontRenderer.func_78256_a(option) + 4;
                if (optionWidth + 10 > width) {
                    width = optionWidth + 10;
                }
                list.add(new MGuiLabel(this.modularGui, 0, 0, optionWidth, 12, option));
            }
            this.addSelector.xPos = this.xPos + this.xSize - (width + 4);
            this.addSelector.yPos = this.yPos + 12;
            this.addSelector.ySize = Math.min(list.size() * 12 + 4, this.ySize - 12);
            this.addSelector.initElement();
            this.addSelector.setOptions(list);
            this.addSelector.setListener((IMGuiListener)this);
            this.modularGui.getManager().add((MGuiElementBase)this.addSelector, 2);
        } else if (eventString.equals("SELECTOR_PICK") && eventElement instanceof MGuiLabel) {
            String type = ((MGuiLabel)eventElement).displayString;
            Element element = this.activeBranch.branchData.getOwnerDocument().createElement("content");
            int index = this.activeBranch.branchContent.size() == 0 ? 0 : this.activeBranch.branchContent.getLast().posIndex + 1;
            element.setAttribute("index", String.valueOf(index));
            element.setAttribute("type", type);
            Node node = this.activeBranch.branchData.getFirstChild();
            if (node == null) {
                this.activeBranch.branchData.appendChild(element);
            } else {
                this.activeBranch.branchData.insertBefore(element, node);
            }
            DisplayComponentBase component = DisplayComponentRegistry.createComponent(this.guiModWiki, type, element, this.activeBranch);
            if (component == null) {
                LogHelper.error("Failed to create display component... This should not happen.");
                return;
            }
            this.modularGui.getManager().remove((MGuiElementBase)this.addSelector);
            this.addSelector = null;
            component.onCreated();
            try {
                this.activeBranch.save();
                WikiDocManager.reload(false, true, true);
                this.guiModWiki.wikiDataTree.reOpenLast();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setActiveBranch(TreeBranchRoot activeBranch) {
        if (activeBranch != this.activeBranch && this.scrollBar != null) {
            this.scrollBar.setScrollPos(0.0);
        }
        this.activeBranch = activeBranch;
        this.setEditingComponent(null);
        if (this.label != null) {
            this.label.setDisplayString(activeBranch.branchID.equals("ROOT") ? "Project Intelligence" : activeBranch.branchName);
        }
        this.clear();
        for (DisplayComponentBase entry : activeBranch.branchContent) {
            entry.setXSize(this.xSize - this.leftPadding - this.rightPadding);
            this.addEntry(entry);
            entry.initElement();
        }
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (super.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.editingComponent != null && !this.editingComponent.isMouseOver(mouseX, mouseY)) {
            this.setEditingComponent(null);
        }
        if (this.addSelector != null && !this.addSelector.isMouseOver(mouseX, mouseY)) {
            this.modularGui.getManager().remove((MGuiElementBase)this.addSelector);
            this.addSelector = null;
        }
        return false;
    }
}

