/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.utility;

import ca.wescook.nutrition.capabilities.INutrientManager;
import ca.wescook.nutrition.effects.EffectsList;
import ca.wescook.nutrition.effects.JsonEffect;
import ca.wescook.nutrition.nutrients.JsonNutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.nutrients.NutrientUtils;
import ca.wescook.nutrition.utility.Config;
import ca.wescook.nutrition.utility.DataParser;
import ca.wescook.nutrition.utility.Log;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import org.apache.commons.io.FilenameUtils;

public class DataImporter {
    @CapabilityInject(value=INutrientManager.class)
    private static final Capability<INutrientManager> NUTRITION_CAPABILITY = null;
    private static final Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();

    public static void reload() {
        NutrientList.register(DataParser.parseNutrients(DataImporter.loadJsonNutrients()));
        EffectsList.register(DataParser.parseEffects(DataImporter.loadJsonEffects()));
        if (Config.logMissingNutrients) {
            NutrientUtils.findRegisteredFoods();
        }
    }

    public static void updatePlayerCapabilitiesOnServer(MinecraftServer server) {
        for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
            if (server.func_71218_a((int)0).field_72995_K) continue;
            ((INutrientManager)player.getCapability(NUTRITION_CAPABILITY, null)).updateCapability();
        }
    }

    private static List<JsonNutrient> loadJsonNutrients() {
        ArrayList nutrientFiles = Lists.newArrayList((Object[])new String[]{"dairy.json", "example.json", "fruit.json", "grain.json", "protein.json", "vegetable.json"});
        File nutrientDirectory = new File(Config.configDirectory, "nutrition/nutrients");
        DataImporter.createConfigurationDirectory("assets/nutrition/configs/nutrients", nutrientDirectory, nutrientFiles);
        return DataImporter.readConfigurationDirectory(JsonNutrient.class, nutrientDirectory);
    }

    private static List<JsonEffect> loadJsonEffects() {
        ArrayList effectsFiles = Lists.newArrayList((Object[])new String[]{"example.json", "mining_fatigue.json", "resistance.json", "strength.json", "toughness.json", "weakness.json"});
        File effectsDirectory = new File(Config.configDirectory, "nutrition/effects");
        DataImporter.createConfigurationDirectory("assets/nutrition/configs/effects", effectsDirectory, effectsFiles);
        return DataImporter.readConfigurationDirectory(JsonEffect.class, effectsDirectory);
    }

    private static void createConfigurationDirectory(String inputDirectory, File outputDirectory, List<String> files) {
        if (outputDirectory.exists()) {
            return;
        }
        outputDirectory.mkdir();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (String file : files) {
            try {
                InputStream inputStream = loader.getResourceAsStream(inputDirectory + "/" + file);
                Throwable throwable = null;
                try {
                    Files.copy(inputStream, new File(outputDirectory + "/" + file).toPath(), new CopyOption[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static <T> List<T> readConfigurationDirectory(Class<T> classImport, File configDirectory) {
        File[] files = configDirectory.listFiles();
        ArrayList<Object> jsonObjectList = new ArrayList<Object>();
        for (File file : files) {
            if (!FilenameUtils.isExtension((String)file.getName(), (String)"json")) continue;
            try {
                JsonReader jsonReader = new JsonReader((Reader)new FileReader(file));
                jsonObjectList.add(gson.fromJson(jsonReader, classImport));
            }
            catch (JsonSyntaxException | IOException e) {
                Log.fatal("The file " + file.getName() + " has invalid JSON and could not be loaded.");
                throw new IllegalArgumentException("Unable to load " + file.getName() + ".  Is the JSON valid?", e);
            }
        }
        return jsonObjectList;
    }
}

