/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import shetiphian.terraqueous.Values;

public class BlueFlowerHandler {
    public static BlueFlowerHandler INSTANCE = new BlueFlowerHandler();
    public static final String[] DEFAULTS = BlueFlowerHandler.getDefaults();
    private static List<EffectEntry> EFFECTS = new ArrayList<EffectEntry>();
    private static long TRANSMUTE_DELAY;
    private Random rand = new Random();
    private HashMap<UUID, Short> blueFlower = new HashMap();

    private static String[] getDefaults() {
        String[] list = new String[]{"effect[minecraft:speed];time[30-60];level[0-1]", "effect[minecraft:slowness];time[10-20];level[0-1]", "effect[minecraft:haste];time[60-120];level[0-1]", "effect[minecraft:mining_fatigue];time[60-120];level[0-1]", "effect[minecraft:jump_boost];time[60-120];level[0-1]", "effect[minecraft:nausea];time[10];level[0]", "effect[minecraft:fire_resistance];time[150-300];level[0-1]", "effect[minecraft:water_breathing];time[150-300];level[0-1]", "effect[minecraft:invisibility];time[60-300];level[0-1]", "effect[minecraft:blindness];time[30-60];level[0-1]", "effect[minecraft:night_vision];time[60-120];level[0-1]", "effect[minecraft:hunger];time[10-30];level[0-1]", "effect[minecraft:weakness];time[10-20];level[0-1]", "effect[minecraft:wither];time[3-5];level[0]", "effect[minecraft:absorption];time[30-60];level[0-1]", "effect[minecraft:saturation];time[15-30];level[0-1]", "effect[minecraft:glowing];time[30-60];level[0-1]", "effect[minecraft:levitation];time[10-20];level[0-1]", "effect[minecraft:luck];time[30-60];level[0-1]", "effect[minecraft:unluck];time[20-40];level[0-1]"};
        return list;
    }

    public void buildList(String[] list) {
        EFFECTS.clear();
        for (String entry : list) {
            int[] level;
            int[] time;
            String[] groups = new String[3];
            for (String string : entry.split(";")) {
                if (string.toLowerCase().startsWith("effect")) {
                    groups[0] = string.substring(7, string.length() - 1);
                    continue;
                }
                if (string.toLowerCase().startsWith("time")) {
                    groups[1] = string.substring(5, string.length() - 1);
                    continue;
                }
                if (!string.toLowerCase().startsWith("level")) continue;
                groups[2] = string.substring(6, string.length() - 1);
            }
            try {
                time = this.getValues(groups[1]);
                level = this.getValues(groups[2]);
            }
            catch (Exception ignored) {
                Values.logTerraqueous.error("Skipping invalid listTricksterBloomEffects entry: " + entry);
                continue;
            }
            EFFECTS.add(new EffectEntry(groups[0].contains(":") ? groups[0] : "minecraft:" + groups[0], time, level));
        }
    }

    private int[] getValues(String input) {
        int[] numbers = new int[2];
        String[] split = input.split("-");
        numbers[0] = Integer.parseInt(split[0]);
        numbers[1] = split.length > 1 ? Integer.parseInt(split[1]) : numbers[0];
        return numbers;
    }

    public void blueAdd(EntityPlayer player) {
        UUID uuid;
        if (!(player.func_130014_f_().field_72995_K || EFFECTS.isEmpty() || this.blueFlower.containsKey(uuid = player.func_110124_au()))) {
            short delay = (short)((this.rand.nextInt(90) + 30) * 20);
            this.blueFlower.put(uuid, delay);
        }
    }

    public void blueUpdate(EntityPlayer player) {
        UUID uuid;
        if (!player.func_130014_f_().field_72995_K && !EFFECTS.isEmpty() && this.blueFlower.containsKey(uuid = player.func_110124_au())) {
            short value = this.blueFlower.get(uuid);
            if (value > 0) {
                value = (short)(value - 1);
                this.blueFlower.put(uuid, value);
                return;
            }
            this.blueFlower.remove(uuid);
            EffectEntry pick = EFFECTS.get(this.rand.nextInt(EFFECTS.size()));
            Potion potion = Potion.func_180142_b((String)pick.getName());
            if (potion != null) {
                player.func_70690_d(new PotionEffect(potion, pick.getTime(this.rand), pick.getLevel(this.rand)));
            } else {
                EFFECTS.remove(pick);
            }
        }
    }

    public void mobTransmute(Entity entity, boolean toHostile) {
        if (entity != null && !entity.field_70170_p.field_72995_K && entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer)) {
            if (TRANSMUTE_DELAY > System.currentTimeMillis()) {
                return;
            }
            TRANSMUTE_DELAY = System.currentTimeMillis() + 20L;
            Entity entityNew = toHostile ? this.getHostileMobTransmute(entity) : this.getNeutralMobTransmute(entity);
            if (entityNew != null) {
                entity.func_70106_y();
                entityNew.field_70170_p.func_72838_d(entityNew);
            }
        }
    }

    private Entity getHostileMobTransmute(Entity entity) {
        if (entity.func_145818_k_() || entity instanceof EntityTameable && ((EntityTameable)entity).func_70909_n()) {
            return null;
        }
        EntityEnderman entityNew = null;
        if (entity instanceof EntitySheep) {
            entityNew = this.rand.nextInt(3) == 0 ? new EntityCaveSpider(entity.field_70170_p) : new EntitySpider(entity.field_70170_p);
        } else if (entity instanceof EntityRabbit) {
            entityNew = new EntityEnderman(entity.field_70170_p);
        } else if (entity instanceof EntityOcelot) {
            entityNew = new EntityCreeper(entity.field_70170_p);
        } else if (entity instanceof EntityWolf) {
            entityNew = this.rand.nextInt(3) == 0 ? new EntityWitherSkeleton(entity.field_70170_p) : new EntitySkeleton(entity.field_70170_p);
        } else if (entity instanceof EntityPig) {
            entityNew = new EntityPigZombie(entity.field_70170_p);
        } else if (entity instanceof EntityChicken) {
            entityNew = new EntityZombie(entity.field_70170_p);
        } else if (entity instanceof EntityCow) {
            entityNew = new EntitySlime(entity.field_70170_p);
        } else if (entity instanceof EntityBat) {
            entityNew = this.rand.nextBoolean() ? new EntityEndermite(entity.field_70170_p) : new EntitySilverfish(entity.field_70170_p);
        } else if (entity instanceof EntityVillager) {
            if (this.rand.nextInt(3) == 0) {
                entityNew = new EntityWitch(entity.field_70170_p);
            } else {
                entityNew = new EntityZombieVillager(entity.field_70170_p);
                ((EntityZombieVillager)entityNew).setForgeProfession(((EntityVillager)entity).getProfessionForge());
            }
        }
        if (entityNew != null) {
            entityNew.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        }
        return entityNew;
    }

    private Entity getNeutralMobTransmute(Entity entity) {
        if (entity.func_145818_k_() || entity instanceof EntityTameable && ((EntityTameable)entity).func_70909_n()) {
            return null;
        }
        EntitySheep entityNew = null;
        if (entity instanceof EntityCaveSpider || entity instanceof EntitySpider) {
            entityNew = new EntitySheep(entity.field_70170_p);
        } else if (entity instanceof EntityEnderman) {
            entityNew = new EntityRabbit(entity.field_70170_p);
        } else if (entity instanceof EntityCreeper) {
            entityNew = new EntityOcelot(entity.field_70170_p);
        } else if (entity instanceof AbstractSkeleton) {
            entityNew = new EntityWolf(entity.field_70170_p);
        } else if (entity instanceof EntityPigZombie) {
            entityNew = new EntityPig(entity.field_70170_p);
        } else if (entity instanceof EntityZombieVillager) {
            entityNew = new EntityVillager(entity.field_70170_p);
            ((EntityVillager)entityNew).setProfession(((EntityZombieVillager)entity).getForgeProfession());
        } else if (entity instanceof EntityZombie) {
            entityNew = new EntityChicken(entity.field_70170_p);
        } else if (entity instanceof EntitySlime) {
            entityNew = this.rand.nextInt(3) == 0 ? new EntityMooshroom(entity.field_70170_p) : new EntityCow(entity.field_70170_p);
        } else if (entity instanceof EntitySilverfish || entity instanceof EntityEndermite) {
            entityNew = new EntityBat(entity.field_70170_p);
        } else if (entity instanceof EntityWitch) {
            entityNew = new EntityVillager(entity.field_70170_p);
            VillagerRegistry.setRandomProfession((EntityVillager)((EntityVillager)entityNew), (Random)this.rand);
        }
        if (entityNew != null) {
            entityNew.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        }
        return entityNew;
    }

    private class EffectEntry {
        private final String name;
        private final short tBase;
        private final short tAdd;
        private final byte lBase;
        private final byte lAdd;

        EffectEntry(String name, int[] time, int[] level) {
            this.name = name;
            this.tBase = (short)MathHelper.func_76125_a((int)Math.min(time[0], time[1]), (int)0, (int)Short.MAX_VALUE);
            this.tAdd = (short)MathHelper.func_76125_a((int)(Math.max(time[0] - time[1], time[1] - time[0]) + 1), (int)1, (int)Short.MAX_VALUE);
            this.lBase = (byte)MathHelper.func_76125_a((int)Math.min(level[0], level[1]), (int)0, (int)127);
            this.lAdd = (byte)MathHelper.func_76125_a((int)(Math.max(level[0] - level[1], level[1] - level[0]) + 1), (int)1, (int)127);
        }

        String getName() {
            return this.name;
        }

        int getTime(Random rand) {
            return (this.tAdd < 2 ? this.tBase : rand.nextInt(this.tAdd) + this.tBase) * 20;
        }

        int getLevel(Random rand) {
            return this.lAdd < 2 ? this.lBase : rand.nextInt(this.lAdd) + this.lBase;
        }
    }
}

