/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.core.common.item.ItemMulti;
import shetiphian.core.common.item.ItemToolWithDamageSource;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.machines.IStormForgeStackHandler;
import shetiphian.terraqueous.common.misc.StormForgeHelper;
import shetiphian.terraqueous.common.network.NetworkHandler;
import shetiphian.terraqueous.common.network.PacketBolt;

public class ItemHammer
extends ItemMulti
implements IStormForgeStackHandler {
    private static final short maxCharge = 25;

    public ItemHammer() {
        super("ItemHammer", Values.nameMapper);
        this.func_77637_a((CreativeTabs)Values.tabTerraqueous);
        this.func_77625_d(1);
    }

    public void getSubItems(NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Item)this, 1, 0));
    }

    private static void addCharge(ItemStack stack, int value) {
        if (stack.func_77952_i() != 1) {
            return;
        }
        int charge = ItemHammer.getCharge(stack) + value;
        stack.func_77978_p().func_74777_a("charge", (short)MathHelper.func_76125_a((int)charge, (int)0, (int)25));
    }

    private static short getCharge(ItemStack stack) {
        if (stack.func_77952_i() != 1) {
            return 0;
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74777_a("charge", (short)25);
        }
        return (short)MathHelper.func_76125_a((int)stack.func_77978_p().func_74765_d("charge"), (int)0, (int)25);
    }

    private static void useCharge(ItemStack stack) {
        ItemHammer.addCharge(stack, -1);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, EntityPlayer player, IBlockState state) {
        return (toolClass = toolClass.toLowerCase()).equals("wrench") || toolClass.equals("hammer") ? 1 : -1;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        facing = player.func_70093_af() ? facing.func_176734_d() : facing;
        world.func_180495_p(pos).func_177230_c().rotateBlock(world, pos, facing);
        player.func_184609_a(hand);
        return EnumActionResult.SUCCESS;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return stack.func_77952_i() == 1 ? EnumRarity.EPIC : super.func_77613_e(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77952_i() == 1;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return stack.func_77952_i() != 1 ? 0.0 : 1.0 - (double)ItemHammer.getCharge(stack) / 25.0;
    }

    public boolean func_77629_n_() {
        return true;
    }

    @Override
    public boolean handleStack(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack processStack(ItemStack stack, int ticks, boolean struck, World world, BlockPos pos) {
        if (stack.func_77952_i() != 1) {
            stack.func_77964_b(1);
        }
        world.func_72942_c((Entity)new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false));
        StormForgeHelper.moveFire(world, pos);
        ItemHammer.addCharge(stack, 25);
        return stack;
    }

    @Override
    public boolean isFinished(ItemStack stack, int ticks, boolean struck, World world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean showBar(ItemStack stack) {
        return false;
    }

    @Override
    public int ticksToComplete(ItemStack stack) {
        return 0;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ItemHammer.getCharge(stack) > 0) {
            player.func_184609_a(hand);
            Vec3d end = null;
            Entity entityInFront = Function.getEntityInFront((World)world, (EntityPlayer)player, (double)50.0);
            if (entityInFront != null) {
                end = entityInFront.func_174791_d();
            } else {
                Function.BlockInfo info = Function.getBlockInfront((World)world, (EntityPlayer)player, (double)50.0, (boolean)false);
                if (info != null) {
                    BlockPos firePos = info.pos.func_177972_a(info.face);
                    Vec3d vec3d = end = world.func_175623_d(firePos) ? info.vec : null;
                    if (!world.field_72995_K && world.field_73012_v.nextBoolean() && world.func_82736_K().func_82766_b("doFireTick") && Blocks.field_150480_ab.func_176196_c(world, firePos)) {
                        world.func_175656_a(firePos, Blocks.field_150480_ab.func_176223_P());
                    }
                }
            }
            if (end != null) {
                if (!world.field_72995_K) {
                    Vec3d start = player.func_174791_d().func_72441_c(0.0, (double)(player.func_70047_e() / 2.0f), 0.0);
                    PacketBolt packet = new PacketBolt(start, end, 0xFF80FF);
                    List entityList = world.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(start.field_72450_a, start.field_72448_b, start.field_72449_c, start.field_72450_a + 1.0, start.field_72448_b + 1.0, start.field_72449_c + 1.0).func_72321_a(16.0, 16.0, 16.0));
                    List entityList2 = world.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(end.field_72450_a, end.field_72448_b, end.field_72449_c, end.field_72450_a + 1.0, end.field_72448_b + 1.0, end.field_72449_c + 1.0).func_72321_a(16.0, 16.0, 16.0));
                    for (EntityPlayerMP entityPlayerMP : entityList2) {
                        if (entityList.contains(entityPlayerMP)) continue;
                        entityList.add(entityPlayerMP);
                    }
                    NetworkHandler.sendToList(packet, entityList);
                    world.func_184148_a(null, start.field_72450_a, start.field_72448_b, start.field_72449_c, Values.soundArc, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    world.func_184148_a(null, end.field_72450_a, end.field_72448_b, end.field_72449_c, Values.soundSpark, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    EntityLightningBolt passedBolt = new EntityLightningBolt(world, end.field_72450_a, end.field_72448_b, end.field_72449_c, false);
                    List list = world.func_72872_a(Entity.class, new AxisAlignedBB(end.field_72450_a, end.field_72448_b, end.field_72449_c, end.field_72450_a + 1.0, end.field_72448_b + 1.0, end.field_72449_c + 1.0).func_72321_a(2.0, 2.0, 2.0));
                    for (Entity entity : list) {
                        if (ForgeEventFactory.onEntityStruckByLightning((Entity)entity, (EntityLightningBolt)passedBolt)) continue;
                        entity.func_70077_a(passedBolt);
                    }
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    ItemHammer.useCharge(stack);
                }
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity victim) {
        ItemStack extraModifiers = new ItemStack(Items.field_151055_y);
        extraModifiers.func_77966_a(Enchantments.field_180313_o, stack.func_77952_i() == 1 ? 8 : 3);
        extraModifiers.func_77966_a(Enchantments.field_185302_k, 3);
        player.func_184185_a(Values.soundHammer, 1.0f, 1.0f);
        return ItemToolWithDamageSource.onLeftClickEntity((EntityPlayer)player, (Entity)victim, null, (ItemStack)extraModifiers);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack.func_77946_l();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77952_i() == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advancedTooltips) {
        if (stack.func_77952_i() == 0) {
            tooltip.add(Localization.get((String)"info.terraqueous.hammer.txt"));
        }
    }

    protected void addToNameMap() {
        this.add(0, "", "hammer", "normal");
        this.add(1, "", "hammer", "activated");
    }
}

