/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.common.block.BlockClouds;
import shetiphian.terraqueous.common.block.BlockTypeBase;
import shetiphian.terraqueous.common.block.BlockTypeCloud;
import shetiphian.terraqueous.common.item.IToolMode;

public class ItemCloudStaff
extends ItemTool
implements IToolMode {
    private static final int maxCharge = 1024000;

    public ItemCloudStaff() {
        super(0.0f, 0.0f, Item.ToolMaterial.GOLD, (Set)Sets.newHashSet((Object[])new Block[0]));
        this.func_77637_a((CreativeTabs)Values.tabTerraqueous);
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.setNoRepair();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = ItemCloudStaff.newTool(EnumMode.LIGHT, false);
            list.add((Object)stack.func_77946_l());
            ItemCloudStaff.setFluid(stack, new FluidStack(FluidRegistry.WATER, 1024000));
            list.add((Object)stack);
        }
    }

    public static ItemStack newTool(EnumMode mode, boolean base_fill) {
        ItemStack stack = ItemCloudStaff.setType(new ItemStack(Values.itemCloudStaff), mode);
        if (base_fill) {
            ItemCloudStaff.setFluid(stack, new FluidStack(FluidRegistry.WATER, (int)(mode.getMultiplier() * 1000.0 * 8.0)));
        }
        return stack;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return CloudAPI.isCloud(state) ? this.field_77864_a : 1.0f;
    }

    @Nonnull
    private static NBTTagCompound getTag(@Nonnull ItemStack stack) {
        NBTTagCompound nbtTag = stack.func_77978_p();
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
            stack.func_77982_d(nbtTag);
            nbtTag.func_74778_a("mode", EnumMode.LIGHT.toString());
        }
        return nbtTag;
    }

    public static EnumMode getEnumMode(ItemStack stack) {
        return EnumMode.byName(ItemCloudStaff.getTag(stack).func_74779_i("mode"));
    }

    private static ItemStack setType(ItemStack stack, EnumMode type) {
        ItemCloudStaff.getTag(stack).func_74778_a("mode", type.toString());
        return stack;
    }

    @Override
    public boolean changeMode(EntityPlayer player, ItemStack stack, boolean next) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemCloudStaff) {
            EnumMode type = ItemCloudStaff.getEnumMode(stack);
            int value = type.getValue() + (next ? -1 : 1);
            ItemCloudStaff.setType(stack, EnumMode.byValue(value));
            return true;
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumActionResult toolResult = EnumActionResult.PASS;
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            RayTraceResult raytraceresult;
            FluidStack fluidStack = ItemCloudStaff.getFluid(heldItem);
            if (!player.func_70093_af() && (fluidStack == null || fluidStack.amount < 1024000) && (raytraceresult = this.func_77621_a(world, player, true)) != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK && player.func_175151_a(raytraceresult.func_178782_a(), facing, heldItem)) {
                FluidStack drained;
                IFluidHandler handler = FluidUtil.getFluidHandler((World)world, (BlockPos)raytraceresult.func_178782_a(), (EnumFacing)raytraceresult.field_178784_b);
                FluidStack wanted = new FluidStack(FluidRegistry.WATER, fluidStack == null ? 1000 : Math.min(1000, 1024000 - fluidStack.amount));
                if (handler != null && handler.drain(wanted, false) != null && (drained = handler.drain(wanted, true)) != null) {
                    if (fluidStack != null) {
                        fluidStack.amount += drained.amount;
                    } else {
                        fluidStack = wanted;
                        fluidStack.amount = drained.amount;
                    }
                    player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                    ItemCloudStaff.setFluid(heldItem, fluidStack);
                    toolResult = EnumActionResult.SUCCESS;
                }
            }
            if (toolResult == EnumActionResult.PASS && (player.field_71075_bZ.field_75098_d || ItemCloudStaff.getBlockCount(heldItem) >= 1.0)) {
                EnumMode mode = ItemCloudStaff.getEnumMode(heldItem);
                IBlockState state = null;
                if (mode == EnumMode.VAPOR) {
                    if (Values.blockTypeCloud != null) {
                        state = Values.blockTypeCloud.func_176223_P().func_177226_a((IProperty)BlockTypeCloud.VARIANT, (Comparable)((Object)BlockTypeBase.EnumType.COLORED));
                    }
                } else if (Values.blockClouds != null) {
                    switch (mode) {
                        case LIGHT: {
                            state = Values.blockClouds.func_176223_P().func_177226_a(CloudAPI.VARIANT, (Comparable)((Object)CloudAPI.CloudType.LIGHT));
                            break;
                        }
                        case DENSE: {
                            state = Values.blockClouds.func_176223_P().func_177226_a(CloudAPI.VARIANT, (Comparable)((Object)CloudAPI.CloudType.DENSE));
                            break;
                        }
                        case STORM: {
                            state = Values.blockClouds.func_176223_P().func_177226_a(CloudAPI.VARIANT, (Comparable)((Object)CloudAPI.CloudType.STORM));
                        }
                    }
                }
                if (state != null && fluidStack != null) {
                    boolean placed = false;
                    if (pos == null) {
                        pos = this.getAirPos(player);
                        player.func_184609_a(hand);
                    } else {
                        pos = pos.func_177972_a(facing);
                    }
                    if (world.func_175623_d(pos) && player.func_175151_a(pos, facing, heldItem) && CloudAPI.canPlaceCloudAt((IBlockAccess)world, pos)) {
                        world.func_184133_a(player, pos, state.func_177230_c().func_185467_w().func_185841_e(), SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                        placed = Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state, (boolean)true);
                    }
                    if (placed) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            fluidStack.amount = (int)((double)fluidStack.amount - 1000.0 * mode.getMultiplier());
                            ItemCloudStaff.setFluid(heldItem, fluidStack);
                        }
                        toolResult = EnumActionResult.SUCCESS;
                    }
                }
            }
        }
        return toolResult;
    }

    private BlockPos getAirPos(EntityPlayer player) {
        int posX = 0;
        int posZ = 0;
        int camY = 0 - MathHelper.func_76128_c((double)((double)(player.field_70125_A * 6.0f / 180.0f) + 0.5));
        int camX = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 12.0f / 360.0f) + 0.5)) % 12;
        if (camY == 3 || camY == -3) {
            posX = 0;
            posZ = 0;
            camY = camY == 3 ? 2 : -2;
        } else {
            camX = camX < 0 ? (camX += 12) : camX;
            switch (camX) {
                case 11: {
                    ++posX;
                    posZ += 2;
                    break;
                }
                case 0: {
                    posX += 0;
                    posZ += 2;
                    break;
                }
                case 1: {
                    --posX;
                    posZ += 2;
                    break;
                }
                case 2: {
                    posX -= 2;
                    ++posZ;
                    break;
                }
                case 3: {
                    posX -= 2;
                    posZ += 0;
                    break;
                }
                case 4: {
                    posX -= 2;
                    --posZ;
                    break;
                }
                case 5: {
                    --posX;
                    posZ -= 2;
                    break;
                }
                case 6: {
                    posX += 0;
                    posZ -= 2;
                    break;
                }
                case 7: {
                    ++posX;
                    posZ -= 2;
                    break;
                }
                case 8: {
                    posX += 2;
                    --posZ;
                    break;
                }
                case 9: {
                    posX += 2;
                    posZ += 0;
                    break;
                }
                case 10: {
                    posX += 2;
                    ++posZ;
                }
            }
            if (camY == -2 || camY == 2) {
                int n = camX >= 2 && camX <= 4 ? posX + 1 : (posX = camX >= 8 && camX <= 10 ? posX - 1 : posX);
                posZ = camX >= 5 && camX <= 7 ? posZ + 1 : (camX <= 1 || camX == 11 ? posZ - 1 : posZ);
            }
        }
        int[] blockXZ = Function.getBlockXZ((double)player.field_70165_t, (double)player.field_70161_v);
        return new BlockPos(blockXZ[0] + posX, (int)player.field_70163_u + camY + 1, blockXZ[1] + posZ);
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entity) {
        if (!stack.func_190926_b()) {
            int amount = 0;
            if (state.func_177230_c() instanceof BlockClouds) {
                amount = (int)Math.pow(4.0, CloudAPI.getCloudType(state).getID()) * 1000;
            } else if (state.func_177230_c() instanceof BlockTypeCloud && BlockTypeBase.getEnumType(state) == BlockTypeBase.EnumType.COLORED) {
                amount = 250;
            }
            if (amount > 0) {
                FluidStack fluidStack = ItemCloudStaff.getFluid(stack);
                if (fluidStack == null) {
                    fluidStack = new FluidStack(FluidRegistry.WATER, amount);
                } else if (fluidStack.amount + amount <= 1024000) {
                    fluidStack.amount += amount;
                } else {
                    fluidStack = null;
                }
                if (fluidStack != null) {
                    if (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                        ItemCloudStaff.setFluid(stack, fluidStack);
                    }
                    world.func_175698_g(pos);
                }
            }
            return true;
        }
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return stack.func_190926_b() ? null : new CloudStaffFluidHandlerItemStack(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        FluidStack fluidStack = ItemCloudStaff.getFluid(stack);
        int amount = fluidStack == null ? 0 : fluidStack.amount;
        return 1.0 - (double)amount / 1024000.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 2122170;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (!stack.func_190926_b()) {
            EnumMode mode = ItemCloudStaff.getEnumMode(stack);
            FluidStack fluidStack = ItemCloudStaff.getFluid(stack);
            if (fluidStack != null) {
                fluidStack.amount = (int)((double)fluidStack.amount - mode.getMultiplier() * 1000.0 * 8.0);
                ItemCloudStaff.setFluid(stack, (FluidStack)(fluidStack.amount > 0 ? fluidStack : null));
            }
        }
        return stack.func_77946_l();
    }

    private static FluidStack getFluid(@Nonnull ItemStack stack) {
        NBTTagCompound nbtTag = ItemCloudStaff.getTag(stack);
        if (!nbtTag.func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTag.func_74775_l("Fluid"));
    }

    private static void setFluid(@Nonnull ItemStack stack, FluidStack fluid) {
        NBTTagCompound nbtTag = ItemCloudStaff.getTag(stack);
        if (fluid == null || fluid.amount < 1) {
            nbtTag.func_82580_o("Fluid");
        } else {
            NBTTagCompound fluidTag = new NBTTagCompound();
            fluid.writeToNBT(fluidTag);
            nbtTag.func_74782_a("Fluid", (NBTBase)fluidTag);
        }
    }

    public static double getBlockCount(ItemStack stack) {
        double placeable = 0.0;
        if (!stack.func_190926_b()) {
            EnumMode mode = ItemCloudStaff.getEnumMode(stack);
            FluidStack fluidStack = ItemCloudStaff.getFluid(stack);
            double amount = fluidStack == null ? 0.0 : (double)fluidStack.amount / 1000.0;
            placeable = amount / mode.getMultiplier();
            placeable = (double)((int)(placeable * 100.0)) / 100.0;
        }
        return placeable;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advancedTooltips) {
        if (!stack.func_190926_b()) {
            EnumMode mode = ItemCloudStaff.getEnumMode(stack);
            String[] text = String.format(Localization.get((String)"msg.terraqueous.cloudstaff.placing.txt"), Localization.get((String)mode.getTooltip()), ItemCloudStaff.getBlockCount(stack)).split("<br>");
            Collections.addAll(tooltip, text);
            tooltip.add(Localization.get((String)"info.terraqueous.cloudstaff.mode.txt"));
        }
    }

    public class CloudStaffFluidHandlerItemStack
    extends FluidHandlerItemStack {
        public CloudStaffFluidHandlerItemStack(ItemStack container) {
            super(container, 1024000);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && fluid.getFluid().equals(FluidRegistry.WATER);
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        public boolean canDrainFluidType(FluidStack fluid) {
            return false;
        }
    }

    public static enum EnumMode {
        VAPOR(0, 0.25, "tile.terraqueous.typecloud.vapor.name"),
        LIGHT(1, 1.0, "tile.terraqueous.clouds.light.name"),
        DENSE(2, 4.0, "tile.terraqueous.clouds.dense.name"),
        STORM(3, 16.0, "tile.terraqueous.clouds.storm.name");

        private static EnumMode[] array;
        private static final Map<String, EnumMode> map;
        private final byte value;
        private final double multiplier;
        private final String tooltip;

        private EnumMode(int value, double multiplier, String tooltip) {
            this.value = (byte)value;
            this.multiplier = multiplier;
            this.tooltip = tooltip;
        }

        public byte getValue() {
            return this.value;
        }

        public double getMultiplier() {
            return this.multiplier;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public static EnumMode byValue(int value) {
            return array[value < 0 ? 3 : (value > 3 ? 0 : value)];
        }

        public static EnumMode byName(String name) {
            return map.containsKey(name = name.toLowerCase().trim()) ? map.get(name) : VAPOR;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            map = new HashMap<String, EnumMode>();
            map.clear();
            array = new EnumMode[EnumMode.values().length];
            EnumMode[] enumModeArray = EnumMode.values();
            int n = enumModeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumMode value;
                EnumMode.array[value.getValue()] = value = enumModeArray[i];
                map.put(value.toString(), value);
            }
        }
    }
}

