/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.misc.PlantFunctions;

public class EntityCoconut
extends Entity {
    private int fallTime;
    public float size;
    private int age;
    private byte delay;
    private static DataParameter dataWatcherSize = EntityDataManager.func_187226_a(EntityCoconut.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityCoconut(World world) {
        super(world);
        this.field_70177_z = (float)(Math.random() * 360.0);
    }

    public EntityCoconut(World world, double x, double y, double z) {
        this(world, x, y, z, false);
    }

    public EntityCoconut(World world, BlockPos pos, boolean treeSpawned) {
        this(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, treeSpawned);
    }

    public EntityCoconut(World world, double x, double y, double z, boolean treeSpawned) {
        super(world);
        if (treeSpawned) {
            x = x - 0.2 + (double)Function.random.nextInt(4) / 10.0;
            y -= 0.02;
            z = z - 0.2 + (double)Function.random.nextInt(4) / 10.0;
        }
        this.func_70107_b(x, y, z);
        this.size = treeSpawned ? 0.2f : 1.0f;
        this.age = treeSpawned ? 1 : -1;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.field_70180_af.func_187227_b(dataWatcherSize, (Object)Float.valueOf(this.size));
        this.field_70177_z = (float)(Math.random() * 360.0);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(dataWatcherSize, (Object)Float.valueOf(this.size));
        this.func_70105_a(0.3f, 0.35f);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return this.size >= 1.0f;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return this.func_70046_E();
    }

    public AxisAlignedBB func_70046_E() {
        if (this.size < 1.0f) {
            return null;
        }
        return new AxisAlignedBB(this.field_70165_t - (double)0.15f, this.field_70163_u - (double)0.15f, this.field_70161_v - (double)0.15f, this.field_70165_t + (double)0.15f, this.field_70163_u + (double)0.15f, this.field_70161_v + (double)0.15f);
    }

    public void func_70071_h_() {
        if (!this.func_130014_f_().field_72995_K && this.age == 0) {
            this.func_70106_y();
        }
        this.size = ((Float)this.field_70180_af.func_187225_a(dataWatcherSize)).floatValue();
        if (this.size < 1.0f) {
            if (this.delay < 1) {
                if (this.field_70163_u > this.field_70167_r) {
                    this.field_70163_u -= this.field_70163_u - this.field_70167_r;
                }
                this.field_70167_r = this.field_70163_u;
                boolean onLeaf = this.getWorld().func_180495_p(this.func_180425_c()).func_177230_c() instanceof BlockLeaves;
                if (this.size + 0.0025f >= 1.0f && onLeaf && !PlantFunctions.dropFruit((IBlockAccess)this.func_130014_f_(), this.func_180425_c(), PlantAPI.TreeType.COCONUT)) {
                    this.size = 0.9999f;
                    this.delay = (byte)20;
                    if (this.field_70131_O < 0.35f) {
                        this.func_70105_a(0.3f, 0.35f);
                    }
                } else {
                    this.size += 0.0025f;
                    this.field_70163_u -= (double)0.0011f;
                    this.delay = 1;
                    this.func_70105_a(0.3f, 0.35f * this.size);
                }
                if (!onLeaf && this.size < 1.0f) {
                    this.func_70106_y();
                }
            } else {
                this.delay = (byte)(this.delay - 1);
            }
        } else {
            if (this.field_70131_O < 0.35f) {
                this.func_70105_a(0.3f, 0.35f);
            }
            if (!this.field_70122_E) {
                ++this.fallTime;
            } else if (this.fallTime > 0) {
                this.fallTime = 0;
            }
            super.func_70071_h_();
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70181_x -= (double)0.04f;
            this.field_70145_X = this.func_145771_j(this.field_70165_t, (this.func_70046_E().field_72338_b + this.func_70046_E().field_72337_e) / 2.0, this.field_70161_v);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
            IBlockState state = this.func_130014_f_().func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block instanceof BlockFluidBase || block instanceof IFluidBlock || block.func_149688_o(state) == Material.field_151586_h || block.func_149688_o(state) == Material.field_151587_i) {
                this.func_85031_j(null);
                return;
            }
            this.collideWithNearbyEntities();
            float f = 0.98f;
            if (this.field_70122_E) {
                f = 0.58800006f;
                pos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_70046_E().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                Block ground = this.func_130014_f_().func_180495_p(pos).func_177230_c();
                if (ground != null) {
                    f = ground.field_149765_K * 0.98f;
                }
            }
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)0.98f;
            this.field_70179_y *= (double)f;
            if (!this.func_130014_f_().field_72995_K) {
                int y = MathHelper.func_76128_c((double)this.field_70163_u);
                if (this.fallTime > 100 && (y < 1 || y > 256)) {
                    this.func_70106_y();
                }
                if (this.field_70122_E && this.age > 0) {
                    ++this.age;
                }
                if (this.age >= 6000) {
                    this.func_85031_j(null);
                }
            }
        }
        this.field_70180_af.func_187227_b(dataWatcherSize, (Object)Float.valueOf(this.size));
    }

    private void collideWithNearbyEntities() {
        List list = this.func_130014_f_().func_72839_b((Entity)this, this.func_70046_E().func_72321_a((double)0.2f, 0.0, (double)0.2f));
        if (list != null && !list.isEmpty()) {
            this.field_70177_z = (float)(Math.random() * 360.0);
            this.field_70165_t += this.field_70146_Z.nextBoolean() ? -0.01 : 0.01;
            this.field_70161_v += this.field_70146_Z.nextBoolean() ? -0.01 : 0.01;
            for (Entity entity : list) {
                if (entity instanceof EntityPlayer) continue;
                this.func_70108_f(entity);
            }
        }
    }

    protected boolean func_145771_j(double x, double y, double z) {
        return this.size >= 1.0f && super.func_145771_j(x, y, z);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        int i = MathHelper.func_76123_f((float)(distance - 1.0f));
        if (i > 0) {
            ArrayList list = new ArrayList(this.func_130014_f_().func_72839_b((Entity)this, this.func_70046_E().func_72321_a(0.25, 0.25, 0.25)));
            for (Entity entity : list) {
                entity.func_70097_a((DamageSource)Values.damageCoconut, (float)Math.min(MathHelper.func_76141_d((float)((float)i * 2.0f)), 15));
            }
        }
    }

    public boolean func_85031_j(Entity entity) {
        if (this.size >= 0.9975f) {
            this.func_70106_y();
            ItemStack itemStack = this.getPickedResult(null);
            if (itemStack != null) {
                Function.dropItem((World)this.func_130014_f_(), (BlockPos)new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), (ItemStack)itemStack);
            }
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound nbtTag) {
        nbtTag.func_74774_a("Time", (byte)this.fallTime);
        nbtTag.func_74776_a("Size", this.size);
        nbtTag.func_74768_a("Age", this.age);
    }

    public void func_70037_a(NBTTagCompound nbtTag) {
        this.fallTime = nbtTag.func_74771_c("Time") & 0xFF;
        this.size = nbtTag.func_74760_g("Size");
        this.age = nbtTag.func_74762_e("Age");
        this.field_70180_af.func_187227_b(dataWatcherSize, (Object)Float.valueOf(this.size));
    }

    public World getWorld() {
        return this.func_130014_f_();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        if (Values.itemMultiFood != null) {
            return Values.stacks.get("coconut", new int[0]);
        }
        return null;
    }
}

