/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.api.machines;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.terraqueous.api.machines.IEnderTableRecipe;

public class SimpleEnderTableRecipe
implements IEnderTableRecipe {
    protected final Ingredient enchant;
    protected final Ingredient material;
    protected final ItemStack output;
    protected final int expCost;
    protected final int matCost;
    protected final float ePower;
    protected final String tooltip;
    protected final boolean obfuscate;

    public SimpleEnderTableRecipe(ItemStack result, Object inputEnchant, Object inputMaterial, int materialCost, int experienceCost, float enchantPower, String tooltip, boolean obfuscate) {
        this.output = result.func_77946_l();
        this.enchant = this.processInput(inputEnchant);
        this.material = this.processInput(inputMaterial);
        this.matCost = materialCost;
        this.expCost = Math.max(0, experienceCost);
        this.ePower = enchantPower;
        this.tooltip = tooltip;
        this.obfuscate = obfuscate;
        if (this.enchant == Ingredient.field_193370_a || this.material == Ingredient.field_193370_a && inputMaterial != null) {
            String ret = "Invalid simple EnderTable recipe: " + inputEnchant + ", " + inputMaterial + ", " + this.output;
            throw new RuntimeException(ret);
        }
    }

    private Ingredient processInput(Object input) {
        Ingredient ingredient = CraftingHelper.getIngredient((Object)input);
        return ingredient == null ? Ingredient.field_193370_a : ingredient;
    }

    @Override
    public boolean matches(ItemStack enchantStack, ItemStack materialStack, float enchantPower, IEnderTableRecipe.EnumOption option, World world) {
        return enchantPower >= this.ePower && option == IEnderTableRecipe.EnumOption.SECOND && this.checkMatch(this.enchant, enchantStack, false) && this.checkMatch(this.material, materialStack, true);
    }

    private boolean checkMatch(Ingredient target, ItemStack tableItem, boolean checksize) {
        if (target == Ingredient.field_193370_a) {
            return tableItem.func_190926_b();
        }
        if (checksize && (tableItem.func_190926_b() || tableItem.func_190916_E() < this.matCost)) {
            return false;
        }
        return target.apply(tableItem);
    }

    @Override
    public Pair<Ingredient, Ingredient> getInput(IEnderTableRecipe.EnumOption option) {
        if (option == IEnderTableRecipe.EnumOption.SECOND) {
            return Pair.of((Object)this.enchant, (Object)this.material);
        }
        return Pair.of((Object)Ingredient.field_193370_a, (Object)Ingredient.field_193370_a);
    }

    @Override
    @Nonnull
    public ItemStack getResult(ItemStack enchantStack, ItemStack materialStack, IEnderTableRecipe.EnumOption option) {
        return option == IEnderTableRecipe.EnumOption.SECOND ? this.output.func_77946_l() : ItemStack.field_190927_a;
    }

    @Override
    public int getExpCost(ItemStack enchantStack, ItemStack materialStack, IEnderTableRecipe.EnumOption option) {
        return option == IEnderTableRecipe.EnumOption.SECOND ? this.expCost : 0;
    }

    @Override
    public int getMaterialCost(ItemStack enchantStack, ItemStack materialStack, IEnderTableRecipe.EnumOption option) {
        return option == IEnderTableRecipe.EnumOption.SECOND ? this.matCost : 0;
    }

    @Override
    public float getEPower(ItemStack enchantStack, ItemStack materialStack, IEnderTableRecipe.EnumOption option) {
        return option == IEnderTableRecipe.EnumOption.SECOND ? this.ePower : 0.0f;
    }

    @Override
    public String getTooltip(ItemStack enchantStack, ItemStack materialStack, IEnderTableRecipe.EnumOption option) {
        return this.tooltip;
    }

    @Override
    public boolean obfuscateTooltip(ItemStack enchantStack, ItemStack materialStack, IEnderTableRecipe.EnumOption option) {
        return this.obfuscate;
    }

    @Override
    public void doneEnchant(ItemStack enchantStack, ItemStack materialStack, float enchantPower, IEnderTableRecipe.EnumOption option, World world) {
    }
}

