/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.api.machines;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import shetiphian.terraqueous.api.machines.IEnderTableRecipe;

public class EnderTableRecipeHandler {
    public static final EnderTableRecipeHandler INSTANCE = new EnderTableRecipeHandler();
    private List<IEnderTableRecipe> tableRecipes = new ArrayList<IEnderTableRecipe>();

    public void addEnderTableRecipe(IEnderTableRecipe recipe) {
        this.tableRecipes.add(recipe);
    }

    public void removeEnderTableRecipe(IEnderTableRecipe recipe) {
        if (this.tableRecipes.contains(recipe)) {
            this.tableRecipes.remove(recipe);
        }
    }

    public List<IEnderTableRecipe> getTableRecipes() {
        return ImmutableList.copyOf(this.tableRecipes);
    }

    public RecipeSet getRecipes(@Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, float enchantPower, World world) {
        return RecipeSet.create(enchantStack, materialStack, enchantPower, world);
    }

    public IEnderTableRecipe getRecipe(@Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, float enchantPower, @Nonnull IEnderTableRecipe.EnumOption option, World world) {
        for (IEnderTableRecipe recipe : this.tableRecipes) {
            if (!recipe.matches(enchantStack, materialStack, enchantPower, option, world)) continue;
            return recipe;
        }
        return null;
    }

    public boolean hasAnyEnchantResult(@Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, float enchantPower, World world) {
        return this.hasAnyEnchantResult(this.getRecipes(enchantStack, materialStack, enchantPower, world), enchantStack, materialStack);
    }

    public boolean hasAnyEnchantResult(RecipeSet recipes, @Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack) {
        if (recipes != null && !recipes.isEmpty()) {
            for (int index = 0; index < 3; ++index) {
                if (!this.hasEnchantResult(recipes.get(index), enchantStack, materialStack, IEnderTableRecipe.EnumOption.byIndex(index))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasEnchantResult(IEnderTableRecipe recipe, @Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, @Nonnull IEnderTableRecipe.EnumOption option) {
        return !this.getEnchantResult(recipe, enchantStack, materialStack, option).func_190926_b();
    }

    @Nonnull
    public ItemStack getEnchantResult(IEnderTableRecipe recipe, @Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, @Nonnull IEnderTableRecipe.EnumOption option) {
        return recipe == null ? ItemStack.field_190927_a : recipe.getResult(enchantStack, materialStack, option);
    }

    public int getExpCost(IEnderTableRecipe recipe, @Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, @Nonnull IEnderTableRecipe.EnumOption option) {
        return recipe == null ? 0 : recipe.getExpCost(enchantStack, materialStack, option);
    }

    public int getMaterialCost(IEnderTableRecipe recipe, @Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, @Nonnull IEnderTableRecipe.EnumOption option) {
        return recipe == null ? 0 : recipe.getMaterialCost(enchantStack, materialStack, option);
    }

    public String getTooltip(IEnderTableRecipe recipe, @Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, @Nonnull IEnderTableRecipe.EnumOption option) {
        return recipe == null ? "" : recipe.getTooltip(enchantStack, materialStack, option);
    }

    public boolean obfuscateTooltip(IEnderTableRecipe recipe, @Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, @Nonnull IEnderTableRecipe.EnumOption option) {
        return recipe == null || recipe.obfuscateTooltip(enchantStack, materialStack, option);
    }

    public void doneEnchant(IEnderTableRecipe recipe, @Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, float enchantPower, @Nonnull IEnderTableRecipe.EnumOption option, World world) {
        if (recipe != null) {
            recipe.doneEnchant(enchantStack, materialStack, enchantPower, option, world);
        }
    }

    public static class RecipeSet {
        public static final RecipeSet EMPTY = new RecipeSet(null, null, null);
        private final IEnderTableRecipe first;
        private final IEnderTableRecipe second;
        private final IEnderTableRecipe third;

        public static RecipeSet create(@Nonnull ItemStack enchantStack, @Nonnull ItemStack materialStack, float enchantPower, World world) {
            IEnderTableRecipe first = INSTANCE.getRecipe(enchantStack, materialStack, enchantPower, IEnderTableRecipe.EnumOption.FIRST, world);
            IEnderTableRecipe second = INSTANCE.getRecipe(enchantStack, materialStack, enchantPower, IEnderTableRecipe.EnumOption.SECOND, world);
            IEnderTableRecipe third = INSTANCE.getRecipe(enchantStack, materialStack, enchantPower, IEnderTableRecipe.EnumOption.THIRD, world);
            return first == null && second == null && third == null ? EMPTY : new RecipeSet(first, second, third);
        }

        private RecipeSet(IEnderTableRecipe first, IEnderTableRecipe second, IEnderTableRecipe third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }

        public boolean isEmpty() {
            return this == EMPTY;
        }

        public IEnderTableRecipe get(IEnderTableRecipe.EnumOption option) {
            return this.get(option.ordinal());
        }

        public IEnderTableRecipe get(int index) {
            switch (MathHelper.func_76125_a((int)index, (int)0, (int)2)) {
                case 0: {
                    return this.first;
                }
                case 1: {
                    return this.second;
                }
                case 2: {
                    return this.third;
                }
            }
            return null;
        }
    }
}

