/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.api.cloud;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shetiphian.terraqueous.api.cloud.CloudAPI;

public class CloudPresets {
    public static boolean isFullCube() {
        return false;
    }

    public static boolean isOpaqueCube() {
        return false;
    }

    public static boolean isFlammable() {
        return false;
    }

    public static EnumPushReaction getMobilityFlag() {
        return EnumPushReaction.DESTROY;
    }

    public static boolean isFoliage() {
        return true;
    }

    public static boolean shouldAddCollisionBoxToList(IBlockState state, World world, BlockPos pos, Entity entity) {
        if (CloudAPI.isCloud(state, (IBlockAccess)world, pos)) {
            return entity instanceof EntityLivingBase && CloudAPI.entityCanBeOnClouds((EntityLivingBase)entity);
        }
        return true;
    }

    public static void onEntityWalking(World world, BlockPos pos, Entity entity) {
        if (!CloudAPI.isCloud(world.func_180495_p(pos), (IBlockAccess)world, pos)) {
            return;
        }
        if (!(entity instanceof EntityLivingBase)) {
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 0.02, (double)pos.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
        }
    }

    public static void onEntityCollidedWithBlock(IBlockState state, World world, BlockPos pos, Entity entity) {
        if (!CloudAPI.isCloud(state, (IBlockAccess)world, pos)) {
            return;
        }
        if (entity instanceof EntityLiving) {
            CloudPresets.hitCloud(state, world, pos, entity);
            if (!CloudAPI.entityCanBeOnClouds((EntityLivingBase)entity)) {
                if (entity instanceof EntityPlayer) {
                    entity.field_70181_x = 0.0;
                } else {
                    entity.func_70110_aj();
                    entity.field_70181_x = -2.0;
                }
            }
        }
    }

    public static void onFallenUpon(World world, BlockPos pos, Entity entity) {
        IBlockState state = world.func_180495_p(pos);
        if (!CloudAPI.isCloud(state, (IBlockAccess)world, pos)) {
            return;
        }
        CloudPresets.hitCloud(state, world, pos, entity);
        CloudPresets.onEntityWalking(world, pos, entity);
    }

    private static void hitCloud(IBlockState state, World world, BlockPos pos, Entity entity) {
        if (!CloudAPI.isCloud(state, (IBlockAccess)world, pos)) {
            return;
        }
        if (entity.field_70143_R >= 3.0f && !world.field_72995_K) {
            entity.field_70143_R = 0.0f;
        }
    }

    public static void onNeighborBlockChange(IBlockState state, World world, BlockPos pos) {
        if (!world.field_72995_K && CloudAPI.isCloud(state, (IBlockAccess)world, pos) && !CloudPresets.checkBlocks(state, world, pos)) {
            CloudPresets.blockPop(world, pos);
        }
    }

    private static boolean checkBlocks(IBlockState state, World world, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.values()) {
            BlockPos sPos = pos.func_177972_a(dir);
            if (CloudAPI.canBlockTouchClouds(state, (IBlockAccess)world, sPos)) continue;
            if (world.func_180495_p(sPos).func_177230_c() == Blocks.field_150332_K) {
                state.func_177230_c().func_176226_b(world, pos, state, 0);
                world.func_175698_g(pos);
                return true;
            }
            return false;
        }
        return true;
    }

    private static void blockPop(World world, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.values()) {
            BlockPos sPos = pos.func_177972_a(dir);
            IBlockState sState = world.func_180495_p(sPos);
            if (CloudAPI.canBlockTouchClouds(sState, (IBlockAccess)world, sPos)) continue;
            Block block = sState.func_177230_c();
            if (block instanceof BlockContainer) {
                block.func_180663_b(world, sPos, sState);
            }
            if (block.canSilkHarvest(world, sPos, sState, null)) {
                CloudPresets.dropItem(world, sPos, new ItemStack(block, 1, block.func_176201_c(sState)));
            } else {
                block.func_176226_b(world, pos, sState, 0);
            }
            world.func_175698_g(sPos);
        }
    }

    public static void dropItem(World world, BlockPos pos, ItemStack itemStack) {
        if (!world.field_72995_K && itemStack != null) {
            double rndX = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double rndY = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double rndZ = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + rndX, (double)pos.func_177956_o() + rndY, (double)pos.func_177952_p() + rndZ, itemStack);
            entityItem.func_174867_a(10);
            if (itemStack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d(itemStack.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)entityItem);
        }
    }

    public static boolean placeBlockAt(Block block, ItemStack stack, EntityPlayer player, World world, BlockPos pos, IBlockState state) {
        if (!world.func_180501_a(pos, state, 3)) {
            return false;
        }
        if (CloudAPI.isCloud(state, (IBlockAccess)world, pos) && !CloudPresets.canPlaceAt(world, pos)) {
            world.func_175698_g(pos);
            return false;
        }
        state = world.func_180495_p(pos);
        if (state.func_177230_c() == block) {
            ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
        }
        return true;
    }

    public static boolean canPlaceAt(World world, BlockPos pos) {
        return CloudAPI.canPlaceCloudAt((IBlockAccess)world, pos);
    }
}

