/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.acintegration.integrations.minetweaker;

import com.shinoow.abyssalcraft.api.ritual.NecronomiconEnchantmentRitual;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import com.shinoow.abyssalcraft.api.ritual.RitualRegistry;
import com.shinoow.acintegration.integrations.minetweaker.ACMT;
import com.shinoow.acintegration.integrations.minetweaker.ACMTMisc;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.abyssalcraft.EnchantmentRitual")
public class EnchantmentRitual {
    @ZenMethod
    public static void addRitual(String unlocalizedName, int bookType, int dimension, float requiredEnergy, boolean requiresSacrifice, String enchantment, IIngredient[] offerings) {
        EnchantmentRitual.addRitual(unlocalizedName, bookType, dimension, requiredEnergy, requiresSacrifice, enchantment, offerings, false);
    }

    @ZenMethod
    public static void addRitual(String unlocalizedName, int bookType, int dimension, float requiredEnergy, boolean requiresSacrifice, String enchantment, IIngredient[] offerings, boolean nbt) {
        Object[] offers = ACMT.toObjects(offerings);
        EnchantmentData ench = EnchantmentRitual.getEnch(enchantment);
        if (ench == null) {
            return;
        }
        NecronomiconEnchantmentRitual ritual = new NecronomiconEnchantmentRitual(unlocalizedName, bookType, dimension, requiredEnergy, requiresSacrifice, ench, offers);
        if (nbt) {
            ritual.setNBTSensitive();
        }
        ACMTMisc.TASKS.add(new Add(ritual));
    }

    private static EnchantmentData getEnch(String string) {
        if (string.length() > 0) {
            String[] stuff = string.split(":");
            Enchantment ench = Enchantment.func_180305_b((String)String.format("%s:%s", stuff[0], stuff[1]));
            int level = 1;
            if (stuff.length > 2) {
                level = Integer.valueOf(stuff[2]);
            }
            if (ench != null) {
                return new EnchantmentData(ench, level);
            }
        }
        return null;
    }

    @ZenMethod
    public static void removeRitual(String enchantment) {
        EnchantmentData ench = EnchantmentRitual.getEnch(enchantment);
        if (ench == null) {
            return;
        }
        ACMTMisc.TASKS.add(new Remove(ench));
    }

    private static class Remove
    implements IAction {
        private final EnchantmentData ench;

        public Remove(EnchantmentData ench) {
            this.ench = ench;
        }

        public void apply() {
            ArrayList<NecronomiconEnchantmentRitual> temp = new ArrayList<NecronomiconEnchantmentRitual>();
            for (NecronomiconRitual necronomiconRitual : RitualRegistry.instance().getRituals()) {
                if (!(necronomiconRitual instanceof NecronomiconEnchantmentRitual)) continue;
                temp.add((NecronomiconEnchantmentRitual)necronomiconRitual);
            }
            for (NecronomiconEnchantmentRitual necronomiconEnchantmentRitual : temp) {
                if (necronomiconEnchantmentRitual.getEnchantment().field_76302_b != this.ench.field_76302_b || necronomiconEnchantmentRitual.getEnchantment().field_76303_c != this.ench.field_76303_c) continue;
                RitualRegistry.instance().getRituals().remove(necronomiconEnchantmentRitual);
            }
        }

        public String describe() {
            return "Removing Necronomicon Enchantment Ritual for " + this.ench.field_76302_b.func_77316_c(this.ench.field_76303_c);
        }
    }

    private static class Add
    implements IAction {
        private final NecronomiconEnchantmentRitual ritual;

        public Add(NecronomiconEnchantmentRitual ritual) {
            this.ritual = ritual;
        }

        public void apply() {
            RitualRegistry.instance().registerRitual((NecronomiconRitual)this.ritual);
        }

        public String describe() {
            return "Adding Necronomicon Enchantment Ritual for " + this.ritual.getEnchantment().field_76302_b.func_77316_c(this.ritual.getEnchantment().field_76303_c);
        }
    }
}

