/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.extrarails.block.base;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowfacts.extrarails.block.base.BlockExtraRail;

public abstract class BlockExtraRailPowered
extends BlockExtraRail {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    protected BlockExtraRailPowered() {
        super(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SHAPE, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
    }

    protected void func_189541_b(IBlockState state, World world, BlockPos pos, Block block) {
        boolean flag1;
        boolean flag = (Boolean)state.func_177229_b((IProperty)POWERED);
        boolean bl = flag1 = world.func_175640_z(pos) || this.findPoweredRailSignal(world, pos, state, true, 0) || this.findPoweredRailSignal(world, pos, state, false, 0);
        if (flag1 != flag) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag1)), 3);
            world.func_175685_c(pos.func_177977_b(), (Block)this, false);
        }
    }

    private boolean findPoweredRailSignal(World world, BlockPos pos, IBlockState state, boolean p_176566_4_, int p_176566_5_) {
        if (p_176566_5_ >= 8) {
            return false;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockRailBase.EnumRailDirection dir = (BlockRailBase.EnumRailDirection)state.func_177229_b((IProperty)SHAPE);
        switch (dir) {
            case NORTH_SOUTH: {
                if (p_176566_4_) {
                    ++z;
                    break;
                }
                --z;
                break;
            }
            case EAST_WEST: {
                if (p_176566_4_) {
                    --x;
                    break;
                }
                ++x;
            }
        }
        return this.isSameRailWithPower(world, new BlockPos(x, y, z), p_176566_4_, p_176566_5_, dir) || this.isSameRailWithPower(world, new BlockPos(x, y - 1, z), p_176566_4_, p_176566_5_, dir);
    }

    private boolean isSameRailWithPower(World world, BlockPos pos, boolean p_176567_3_, int distance, BlockRailBase.EnumRailDirection dir) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return false;
        }
        BlockRailBase.EnumRailDirection shape = (BlockRailBase.EnumRailDirection)state.func_177229_b((IProperty)SHAPE);
        return (dir != BlockRailBase.EnumRailDirection.EAST_WEST || shape != BlockRailBase.EnumRailDirection.NORTH_SOUTH && shape != BlockRailBase.EnumRailDirection.ASCENDING_NORTH && shape != BlockRailBase.EnumRailDirection.ASCENDING_SOUTH) && (dir != BlockRailBase.EnumRailDirection.NORTH_SOUTH || shape != BlockRailBase.EnumRailDirection.EAST_WEST && shape != BlockRailBase.EnumRailDirection.ASCENDING_EAST && shape != BlockRailBase.EnumRailDirection.ASCENDING_WEST) && (Boolean)state.func_177229_b((IProperty)POWERED) != false && (world.func_175640_z(pos) || this.findPoweredRailSignal(world, pos, state, p_176567_3_, distance + 1));
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED, SHAPE, FACING});
    }

    @Override
    @Nonnull
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        boolean powered = (meta & 1) == 1;
        BlockRailBase.EnumRailDirection shape = BlockRailBase.EnumRailDirection.func_177016_a((int)(meta >> 1 & 1));
        EnumFacing facing = EnumFacing.func_176731_b((int)(meta >> 2));
        return this.func_176223_P().func_177226_a((IProperty)SHAPE, (Comparable)shape).func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        BlockRailBase.EnumRailDirection shape = (BlockRailBase.EnumRailDirection)state.func_177229_b((IProperty)SHAPE);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        boolean powered = (Boolean)state.func_177229_b((IProperty)POWERED);
        int meta = powered ? 1 : 0;
        meta |= shape.func_177015_a() << 1;
        return meta |= facing.func_176736_b() << 2;
    }
}

