/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.client.gui.necronomicon;

import com.shinoow.abyssalcraft.api.necronomicon.CraftingStack;
import com.shinoow.abyssalcraft.api.necronomicon.GuiInstance;
import com.shinoow.abyssalcraft.api.necronomicon.INecroData;
import com.shinoow.abyssalcraft.api.necronomicon.NecroData;
import com.shinoow.abyssalcraft.client.gui.necronomicon.GuiNecronomicon;
import com.shinoow.abyssalcraft.client.gui.necronomicon.buttons.ButtonCategory;
import com.shinoow.abyssalcraft.client.gui.necronomicon.buttons.ButtonHome;
import com.shinoow.abyssalcraft.client.gui.necronomicon.buttons.ButtonNextPage;
import com.shinoow.abyssalcraft.lib.NecronomiconResources;
import com.shinoow.abyssalcraft.lib.NecronomiconText;
import java.net.URL;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class GuiNecronomiconEntry
extends GuiNecronomicon {
    private ButtonNextPage buttonNextPage;
    private ButtonNextPage buttonNextPageLong;
    private ButtonNextPage buttonPreviousPage;
    private ButtonNextPage buttonPreviousPageLong;
    private ButtonCategory[] buttons;
    private GuiButton buttonDone;
    private ButtonHome buttonHome;
    private NecroData data;
    private GuiNecronomicon parent;
    private Item icon;
    private int currentData;

    public GuiNecronomiconEntry(int bookType, NecroData nd, GuiNecronomicon gui) {
        super(bookType);
        this.data = nd;
        this.parent = gui;
        this.icon = this.getItem(nd.getDisplayIcon());
        this.buttons = new ButtonCategory[this.data.getContainedData().size()];
    }

    public GuiNecronomiconEntry(int bookType, NecroData nd, GuiNecronomicon gui, Item item) {
        this(bookType, nd, gui);
        this.icon = item;
    }

    @Override
    public GuiNecronomicon withBookType(int par1) {
        super.withBookType(par1);
        if (this.data != null && !this.isUnlocked(this.data.getCondition())) {
            this.isInvalid = true;
        }
        return this;
    }

    @Override
    public void func_73866_w_() {
        if (this.isInvalid) {
            this.field_146297_k.func_147108_a((GuiScreen)this.parent.withBookType(this.getBookType()));
        }
        currentNecro = this;
        if (this.isInfo) {
            this.drawButtons();
        } else {
            this.field_146292_n.clear();
            Keyboard.enableRepeatEvents((boolean)true);
            this.buttonDone = new GuiButton(0, this.field_146294_l / 2 - 100, 196, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
            this.field_146292_n.add(this.buttonDone);
            int i = (this.field_146294_l - 255) / 2;
            int b0 = 2;
            this.buttonNextPage = new ButtonNextPage(1, i + 215, b0 + 154, true, false);
            this.field_146292_n.add(this.buttonNextPage);
            this.buttonNextPageLong = new ButtonNextPage(2, i + 203, b0 + 167, true, true);
            this.field_146292_n.add(this.buttonNextPageLong);
            this.buttonPreviousPage = new ButtonNextPage(3, i + 18, b0 + 154, false, false);
            this.field_146292_n.add(this.buttonPreviousPage);
            this.buttonPreviousPageLong = new ButtonNextPage(4, i + 23, b0 + 167, false, true);
            this.field_146292_n.add(this.buttonPreviousPageLong);
            this.buttonHome = new ButtonHome(5, i + 118, b0 + 167);
            this.field_146292_n.add(this.buttonHome);
            if (this.data != null) {
                for (int n = 0; n < this.data.getContainedData().size(); ++n) {
                    INecroData nd = this.data.getContainedData().get(n);
                    this.buttons[n] = new ButtonCategory(6 + n, i + (n < 7 ? 14 : 132), b0 + 24 + 17 * (n < 7 ? n : n - 7), this, nd.getTitle(), !this.isUnlocked(nd.getCondition()), this.getItem(nd.getDisplayIcon()));
                    this.field_146292_n.add(this.buttons[n]);
                }
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = this.currTurnup < this.getTurnupLimit() - 1 && this.isInfo;
        this.buttonNextPageLong.field_146125_m = this.currTurnup < this.getTurnupLimit() - 5;
        this.buttonPreviousPage.field_146125_m = true;
        this.buttonPreviousPageLong.field_146125_m = this.currTurnup > 4;
        this.buttonDone.field_146125_m = true;
        this.buttonHome.field_146125_m = true;
        if (this.data != null) {
            for (int i = 0; i < this.data.getContainedData().size(); ++i) {
                this.buttons[i].field_146125_m = !this.isInfo;
            }
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)null);
            } else if (button.field_146127_k == 1) {
                if (this.currTurnup < this.getTurnupLimit() - 1) {
                    ++this.currTurnup;
                }
            } else if (button.field_146127_k == 2) {
                if (this.currTurnup < this.getTurnupLimit() - 5) {
                    this.currTurnup += 5;
                }
            } else if (button.field_146127_k == 3) {
                if (this.currTurnup == 0 && !this.isInfo) {
                    this.field_146297_k.func_147108_a((GuiScreen)this.parent.withBookType(this.getBookType()));
                } else if (this.currTurnup == 0 && this.isInfo) {
                    this.isInfo = false;
                    this.func_73866_w_();
                    this.currentData = -1;
                    this.setTurnupLimit(2);
                } else if (this.currTurnup > 0) {
                    --this.currTurnup;
                }
            } else if (button.field_146127_k == 4) {
                if (this.currTurnup > 4) {
                    this.currTurnup -= 5;
                }
            } else if (button.field_146127_k == 5) {
                if (!this.isInfo) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiNecronomicon(this.getBookType()));
                } else {
                    this.currTurnup = 0;
                    this.isInfo = false;
                    this.func_73866_w_();
                    this.currentData = -1;
                    this.setTurnupLimit(2);
                }
            } else if (button.field_146127_k >= 6 && this.data.getContainedData().size() >= button.field_146127_k - 5) {
                int i = button.field_146127_k - 6;
                INecroData nd = this.data.getContainedData().get(i);
                if (this.isUnlocked(nd.getCondition())) {
                    if (nd instanceof GuiInstance) {
                        this.field_146297_k.func_147108_a(((GuiInstance)nd).getOpenGui(this.getBookType(), this));
                    } else if (nd instanceof NecroData) {
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiNecronomiconEntry(this.getBookType(), (NecroData)nd, this));
                    } else {
                        this.currentData = i;
                        this.isInfo = true;
                        this.drawButtons();
                    }
                }
            }
            this.updateButtons();
        }
    }

    private void drawButtons() {
        this.field_146292_n.clear();
        this.buttonDone = new GuiButton(0, this.field_146294_l / 2 - 100, 196, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonDone);
        int i = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        this.buttonNextPage = new ButtonNextPage(1, i + 215, b0 + 154, true, false);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonNextPageLong = new ButtonNextPage(2, i + 203, b0 + 167, true, true);
        this.field_146292_n.add(this.buttonNextPageLong);
        this.buttonPreviousPage = new ButtonNextPage(3, i + 18, b0 + 154, false, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.buttonPreviousPageLong = new ButtonNextPage(4, i + 23, b0 + 167, false, true);
        this.field_146292_n.add(this.buttonPreviousPageLong);
        this.buttonHome = new ButtonHome(5, i + 118, b0 + 167);
        this.field_146292_n.add(this.buttonHome);
    }

    @Override
    protected void drawInformationText(int x, int y) {
        if (this.currentData != -1) {
            this.drawChapterOrPage(this.data.getContainedData().get(this.currentData), x, y);
        }
        this.updateButtons();
    }

    private void drawChapterOrPage(INecroData data, int x, int y) {
        if (data instanceof NecroData.Chapter) {
            this.drawChapter((NecroData.Chapter)data, x, y);
        } else {
            this.setTurnupLimit(1);
            this.addPage((NecroData.Page)data, null, 2, x, y);
        }
    }

    private void drawChapter(NecroData.Chapter chapter, int x, int y) {
        int k = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        String stuff = I18n.func_135052_a((String)chapter.getTitle(), (Object[])new Object[0]);
        this.field_146289_q.func_78279_b(stuff, k + 20, b0 + 16, 116, 0xC40000);
        this.setTurnupLimit(chapter.getTurnupAmount());
        int num = (this.currTurnup + 1) * 2;
        this.addPage(chapter.getPage(num - 1), chapter.getPage(num), num, x, y);
    }

    private void addPage(NecroData.Page page1, NecroData.Page page2, int displayNum, int x, int y) {
        int k = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        String text1 = "";
        String text2 = "";
        Object icon1 = null;
        Object icon2 = null;
        boolean locked1 = false;
        boolean locked2 = false;
        if (page1 != null) {
            text1 = page1.getText();
            icon1 = page1.getIcon();
            boolean bl = locked1 = !this.isUnlocked(page1.getCondition());
        }
        if (page2 != null) {
            text2 = page2.getText();
            icon2 = page2.getIcon();
            locked2 = !this.isUnlocked(page2.getCondition());
        }
        this.tooltipStack = null;
        this.writeTexts(icon1, icon2, text1, text2, locked1, locked2);
        this.writeText(1, String.valueOf(displayNum - 1), 165, 50);
        this.writeText(2, String.valueOf(displayNum), 165, 50);
        if (icon1 != null) {
            if (icon1 instanceof ItemStack) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (locked1) {
                    this.field_146297_k.field_71446_o.func_110577_a(MISSING_ITEM);
                    this.func_73729_b(k, b0, 0, 0, 256, 256);
                } else {
                    this.field_146297_k.field_71446_o.func_110577_a(NecronomiconResources.ITEM);
                    this.func_73729_b(k, b0, 0, 0, 256, 256);
                    this.renderItem(k + 60, b0 + 28, (ItemStack)icon1, x, y);
                }
            }
            if (icon1 instanceof ResourceLocation) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(locked1 ? MISSING_PICTURE : (ResourceLocation)icon1);
                this.func_73729_b(k, b0, 0, 0, 256, 256);
            }
            if (icon1 instanceof CraftingStack) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (locked1) {
                    this.field_146297_k.field_71446_o.func_110577_a(MISSING_RECIPE);
                    this.func_73729_b(k, b0, 0, 0, 256, 256);
                } else {
                    this.field_146297_k.field_71446_o.func_110577_a(NecronomiconResources.CRAFTING);
                    this.func_73729_b(k, b0, 0, 0, 256, 256);
                    boolean unicode = this.field_146289_q.func_82883_a();
                    this.field_146289_q.func_78264_a(false);
                    this.renderItem(k + 93, b0 + 52, ((CraftingStack)icon1).getOutput(), x, y);
                    this.field_146289_q.func_78264_a(unicode);
                    for (int i = 0; i <= 2; ++i) {
                        this.renderObject(k + 24 + i * 21, b0 + 31, ((CraftingStack)icon1).getRecipe()[i], x, y);
                        this.renderObject(k + 24 + i * 21, b0 + 52, ((CraftingStack)icon1).getRecipe()[3 + i], x, y);
                        this.renderObject(k + 24 + i * 21, b0 + 73, ((CraftingStack)icon1).getRecipe()[6 + i], x, y);
                    }
                }
            }
            if (icon1 instanceof String) {
                if (locked1) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.field_71446_o.func_110577_a(MISSING_PICTURE);
                    this.func_73729_b(k, b0, 0, 0, 256, 256);
                } else if (failcache.contains(icon1)) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.field_71446_o.func_110577_a(MISSING_PICTURE);
                    this.func_73729_b(k, b0, 0, 0, 256, 256);
                } else if (successcache.get(icon1) != null) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179144_i((int)((DynamicTexture)successcache.get(icon1)).func_110552_b());
                    this.func_73729_b(k, b0, 0, 0, 256, 256);
                } else {
                    DynamicTexture t = null;
                    try {
                        t = new DynamicTexture(ImageIO.read(new URL((String)icon1)));
                        successcache.put((String)icon1, t);
                    }
                    catch (Exception e) {
                        failcache.add((String)icon1);
                    }
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (t != null) {
                        GlStateManager.func_179144_i((int)t.func_110552_b());
                    } else {
                        this.field_146297_k.field_71446_o.func_110577_a(MISSING_PICTURE);
                    }
                    this.func_73729_b(k, b0, 0, 0, 256, 256);
                }
            }
        }
        if (icon2 != null) {
            int n = 123;
            if (icon2 instanceof ItemStack) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (locked2) {
                    this.field_146297_k.field_71446_o.func_110577_a(MISSING_ITEM);
                    this.func_73729_b(k + n, b0, 0, 0, 256, 256);
                } else {
                    this.field_146297_k.field_71446_o.func_110577_a(NecronomiconResources.ITEM);
                    this.func_73729_b(k + n, b0, 0, 0, 256, 256);
                    this.renderItem(k + 60 + n, b0 + 28, (ItemStack)icon2, x, y);
                }
            }
            if (icon2 instanceof ResourceLocation) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(locked2 ? MISSING_PICTURE : (ResourceLocation)icon2);
                this.func_73729_b(k + n, b0, 0, 0, 256, 256);
            }
            if (icon2 instanceof CraftingStack) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (locked2) {
                    this.field_146297_k.field_71446_o.func_110577_a(MISSING_RECIPE);
                    this.func_73729_b(k + n, b0, 0, 0, 256, 256);
                } else {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    this.field_146297_k.field_71446_o.func_110577_a(NecronomiconResources.CRAFTING);
                    this.func_73729_b(k + n, b0, 0, 0, 256, 256);
                    GlStateManager.func_179091_B();
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179140_f();
                    boolean unicode = this.field_146289_q.func_82883_a();
                    this.field_146289_q.func_78264_a(false);
                    this.renderItem(k + 93 + n, b0 + 52, ((CraftingStack)icon2).getOutput(), x, y);
                    this.field_146289_q.func_78264_a(unicode);
                    for (int i = 0; i <= 2; ++i) {
                        this.renderObject(k + 24 + n + i * 21, b0 + 31, ((CraftingStack)icon2).getRecipe()[i], x, y);
                        this.renderObject(k + 24 + n + i * 21, b0 + 52, ((CraftingStack)icon2).getRecipe()[3 + i], x, y);
                        this.renderObject(k + 24 + n + i * 21, b0 + 73, ((CraftingStack)icon2).getRecipe()[6 + i], x, y);
                    }
                }
            }
            if (icon2 instanceof String) {
                if (locked2) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.field_71446_o.func_110577_a(MISSING_PICTURE);
                    this.func_73729_b(k + n, b0, 0, 0, 256, 256);
                } else if (failcache.contains(icon2)) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.field_71446_o.func_110577_a(MISSING_PICTURE);
                    this.func_73729_b(k + n, b0, 0, 0, 256, 256);
                } else if (successcache.get(icon2) != null) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179144_i((int)((DynamicTexture)successcache.get(icon2)).func_110552_b());
                    this.func_73729_b(k + n, b0, 0, 0, 256, 256);
                } else {
                    DynamicTexture t = null;
                    try {
                        t = new DynamicTexture(ImageIO.read(new URL((String)icon2)));
                        successcache.put((String)icon2, t);
                    }
                    catch (Exception e) {
                        failcache.add((String)icon2);
                    }
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (t != null) {
                        GlStateManager.func_179144_i((int)t.func_110552_b());
                    } else {
                        this.field_146297_k.field_71446_o.func_110577_a(MISSING_PICTURE);
                    }
                    this.func_73729_b(k + n, b0, 0, 0, 256, 256);
                }
            }
        }
        this.renderTooltip(x, y);
    }

    private void writeTexts(Object icon1, Object icon2, String text1, String text2, boolean locked1, boolean locked2) {
        if (icon1 != null) {
            if (icon1 instanceof ItemStack) {
                this.writeText(1, locked1 ? NecronomiconText.TEST_95 : text1, 50, locked1);
            }
            if (icon1 instanceof ResourceLocation || icon1 instanceof String) {
                this.writeText(1, locked1 ? NecronomiconText.TEST_50_1 : text1, 100, locked1);
            }
            if (icon1 instanceof CraftingStack) {
                this.writeText(1, locked1 ? NecronomiconText.TEST_50_2 : text1, 95, locked1);
            }
        } else {
            this.writeText(1, locked1 ? NecronomiconText.TEST : text1, locked1);
        }
        if (icon2 != null) {
            if (icon2 instanceof ItemStack) {
                this.writeText(2, locked2 ? NecronomiconText.TEST_95 : text2, 50, locked2);
            }
            if (icon2 instanceof ResourceLocation || icon2 instanceof String) {
                this.writeText(2, locked2 ? NecronomiconText.TEST_50_1 : text2, 100, locked2);
            }
            if (icon2 instanceof CraftingStack) {
                this.writeText(2, locked2 ? NecronomiconText.TEST_50_2 : text2, 95, locked2);
            }
        } else {
            this.writeText(2, locked2 ? NecronomiconText.TEST : text2, locked2);
        }
    }

    @Override
    protected void drawIndexText() {
        int k = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        String stuff = this.localize(this.data.getTitle());
        boolean b = !this.isUnlocked(this.data.getCondition());
        this.getFontRenderer(b).func_78279_b(b ? NecronomiconText.LABEL_TEST : stuff, k + 20, b0 + 16, 116, 0xC40000);
        if (this.data.hasText()) {
            this.writeText(2, b ? NecronomiconText.TEST : this.data.getText(), b);
        }
    }
}

