/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.ritual;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.necronomicon.condition.DefaultCondition;
import com.shinoow.abyssalcraft.api.necronomicon.condition.IUnlockCondition;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public abstract class NecronomiconRitual {
    private Object[] offerings = new Object[8];
    protected Object sacrifice;
    private String unlocalizedName;
    private int bookType;
    private int dimension;
    private float requiredEnergy;
    private boolean requiresSacrifice;
    private boolean nbtSensitive;
    private boolean nbtSensitiveSacrifice;
    private IUnlockCondition condition = new DefaultCondition();

    public NecronomiconRitual(String unlocalizedName, int bookType, int dimension, float requiredEnergy, boolean requiresSacrifice, Object ... offerings) {
        this.unlocalizedName = unlocalizedName;
        this.bookType = bookType;
        this.dimension = dimension;
        this.requiredEnergy = requiredEnergy;
        this.requiresSacrifice = requiresSacrifice;
        if (offerings.length < 8) {
            this.offerings = new Object[offerings.length];
            for (int i = 0; i < offerings.length; ++i) {
                this.offerings[i] = offerings[i];
            }
        } else {
            this.offerings = offerings;
        }
    }

    public NecronomiconRitual(String unlocalizedName, int bookType, int dimension, float requiredEnergy, Object ... offerings) {
        this(unlocalizedName, bookType, dimension, requiredEnergy, false, offerings);
    }

    public NecronomiconRitual(String unlocalizedName, int bookType, float requiredEnergy, Object ... offerings) {
        this(unlocalizedName, bookType, -1, requiredEnergy, offerings);
    }

    public NecronomiconRitual setNBTSensitive() {
        this.nbtSensitive = true;
        return this;
    }

    public NecronomiconRitual setNBTSensitiveSacrifice() {
        this.nbtSensitiveSacrifice = true;
        return this;
    }

    public NecronomiconRitual setUnlockCondition(IUnlockCondition condition) {
        this.condition = condition;
        return this;
    }

    public Object[] getOfferings() {
        return this.offerings;
    }

    public boolean requiresSacrifice() {
        return this.requiresSacrifice;
    }

    public int getBookType() {
        return this.bookType;
    }

    public int getDimension() {
        return this.dimension;
    }

    public float getReqEnergy() {
        return this.requiredEnergy;
    }

    public String getUnlocalizedName() {
        return "ac.ritual." + this.unlocalizedName;
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)this.getUnlocalizedName());
    }

    public String getDescription() {
        return I18n.func_74838_a((String)(this.getUnlocalizedName() + ".desc"));
    }

    public boolean requiresItemSacrifice() {
        return false;
    }

    public boolean isNBTSensitive() {
        return this.nbtSensitive;
    }

    public boolean isSacrificeNBTSensitive() {
        return this.nbtSensitiveSacrifice;
    }

    public IUnlockCondition getUnlockCondition() {
        return this.condition;
    }

    public Object getSacrifice() {
        return this.sacrifice;
    }

    public abstract boolean canCompleteRitual(World var1, BlockPos var2, EntityPlayer var3);

    public void completeRitual(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K) {
            this.completeRitualServer(world, pos, player);
            AbyssalCraftAPI.getInternalMethodHandler().completeRitualClient(pos, player, this.unlocalizedName);
        }
        if (world.field_72995_K) {
            this.completeRitualClient(world, pos, player);
        }
    }

    protected abstract void completeRitualClient(World var1, BlockPos var2, EntityPlayer var3);

    protected abstract void completeRitualServer(World var1, BlockPos var2, EntityPlayer var3);
}

