/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.items;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import sonar.core.SonarCore;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.client.gui.GuiHelpOverlay;
import sonar.core.client.gui.GuiSonar;
import sonar.core.client.gui.SonarTextField;
import sonar.core.helpers.RenderHelper;
import sonar.core.network.FlexibleGuiHandler;
import sonar.core.utils.SortingDirection;
import sonar.logistics.PL2;
import sonar.logistics.PL2Translate;
import sonar.logistics.base.gui.GuiSelectionGrid;
import sonar.logistics.base.gui.buttons.LogisticsButton;
import sonar.logistics.base.utils.ListPacket;
import sonar.logistics.core.tiles.displays.info.types.items.MonitoredItemStack;
import sonar.logistics.core.tiles.readers.items.ContainerInventoryReader;
import sonar.logistics.core.tiles.readers.items.InventoryReader;
import sonar.logistics.core.tiles.readers.items.TileInventoryReader;
import sonar.logistics.network.packets.PacketInventoryReader;
import sonar.logistics.network.packets.PacketNodeFilter;

public class GuiInventoryReader
extends GuiSelectionGrid<MonitoredItemStack> {
    public static final ResourceLocation sorting_icons = new ResourceLocation("practicallogistics2:textures/gui/sorting_icons.png");
    private TileInventoryReader part;
    private SonarTextField slotField;
    private SonarTextField searchField;
    public EntityPlayer player;

    public GuiInventoryReader(TileInventoryReader tileInventoryReader, EntityPlayer player) {
        super((Container)new ContainerInventoryReader(tileInventoryReader, player), tileInventoryReader);
        this.part = tileInventoryReader;
        this.player = player;
    }

    public InventoryReader.Modes getSetting() {
        return (InventoryReader.Modes)this.part.setting.getObject();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.initButtons();
        switch (this.getSetting()) {
            case SLOT: 
            case POS: {
                this.slotField = new SonarTextField(0, this.field_146289_q, 63, 10, 32, 14);
                this.slotField.func_146203_f(7);
                this.slotField.setDigitsOnly(true);
                if (this.getSetting() == InventoryReader.Modes.SLOT) {
                    this.slotField.func_146180_a("" + this.part.targetSlot.getObject());
                } else if (this.getSetting() == InventoryReader.Modes.POS) {
                    this.slotField.func_146180_a("" + this.part.posSlot.getObject());
                }
                this.fieldList.add(this.slotField);
                break;
            }
        }
        this.searchField = new SonarTextField(1, this.field_146289_q, 135, 10, 104, 14);
        this.searchField.func_146203_f(20);
        this.fieldList.add(this.searchField);
    }

    public void initButtons() {
        super.initButtons();
        int start = 8;
        this.field_146292_n.add(new LogisticsButton.CHANNELS((GuiSonar)this, 2, this.field_147003_i + start, this.field_147009_r + 9));
        this.field_146292_n.add(new LogisticsButton.HELP((GuiSonar)this, 5, this.field_147003_i + start + 18, this.field_147009_r + 9));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, -1, this.field_147003_i + start + 36, this.field_147009_r + 9, 96, 16 * ((InventoryReader.Modes)this.part.setting.getObject()).ordinal(), this.getSettingsString(), ""));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 0, this.field_147003_i + this.field_146999_f - 168 + 18, this.field_147009_r + 9, 32, 16 * ((SortingDirection)this.part.sortingOrder.getObject()).ordinal(), PL2Translate.BUTTON_SORTING_ORDER.t(), ""));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 1, this.field_147003_i + this.field_146999_f - 168 + 36, this.field_147009_r + 9, 112, 16 * ((InventoryReader.SortingType)this.part.sortingType.getObject()).ordinal(), ((InventoryReader.SortingType)this.part.sortingType.getObject()).getClientName(), ""));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 3, this.field_147003_i + 203, this.field_147009_r + 174, 32, 0, PL2Translate.BUTTON_DUMP_PLAYER.t(), ""));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 4, this.field_147003_i + 203 + 18, this.field_147009_r + 174, 32, 16, PL2Translate.BUTTON_DUMP_NETWORK.t(), ""));
        if (this.part.setting.getObject() == InventoryReader.Modes.FILTERED) {
            this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 6, this.field_147003_i + start + 54, this.field_147009_r + 9, 32, 64, PL2Translate.BUTTON_CONFIGURE_FILTERS.t(), "button.TileFilters"));
            this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 7, this.field_147003_i + start + 72, this.field_147009_r + 9, 32, 96, PL2Translate.BUTTON_CLEAR_ALL.t(), "button.ClearAllFilter"));
        }
    }

    public void func_146284_a(GuiButton button) {
        if (button != null) {
            switch (button.field_146127_k) {
                case -1: {
                    this.part.setting.incrementEnum();
                    this.part.sendByteBufPacket(2);
                    this.switchState();
                    this.reset();
                    break;
                }
                case 0: {
                    this.part.sortingOrder.incrementEnum();
                    this.part.sendByteBufPacket(5);
                    this.initButtons();
                    break;
                }
                case 1: {
                    this.part.sortingType.incrementEnum();
                    this.part.sendByteBufPacket(6);
                    this.initButtons();
                    break;
                }
                case 2: {
                    FlexibleGuiHandler.changeGui((IFlexibleGui)this.part, (int)1, (int)0, (World)this.player.func_130014_f_(), (EntityPlayer)this.player);
                    break;
                }
                case 3: {
                    PL2.network.sendToServer((IMessage)new PacketInventoryReader(this.part.getSlotID(), this.part.func_174877_v(), null, 3));
                    break;
                }
                case 4: {
                    PL2.network.sendToServer((IMessage)new PacketInventoryReader(this.part.getSlotID(), this.part.func_174877_v(), null, 4));
                    break;
                }
                case 5: {
                    GuiHelpOverlay.enableHelp = !GuiHelpOverlay.enableHelp;
                    this.reset();
                    break;
                }
                case 6: {
                    FlexibleGuiHandler.changeGui((IFlexibleGui)this.part, (int)2, (int)0, (World)this.player.func_130014_f_(), (EntityPlayer)this.player);
                    break;
                }
                case 7: {
                    PL2.network.sendToServer((IMessage)new PacketNodeFilter(this.part.getSlotID(), this.part.getCoords().getBlockPos(), ListPacket.CLEAR));
                }
            }
        }
    }

    public void switchState() {
        SonarCore.refreshFlexibleContainer((EntityPlayer)this.player);
    }

    @Override
    public void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        if (k == 1) {
            this.searchField.func_146180_a("");
        }
    }

    public void onTextFieldChanged(SonarTextField field) {
        if (field == this.slotField) {
            String text = this.slotField.func_146179_b();
            int num = field.getIntegerFromText();
            if (this.getSetting() == InventoryReader.Modes.SLOT) {
                this.part.targetSlot.setObject((Object)num);
                this.part.sendByteBufPacket(this.part.targetSlot.id);
            }
            if (this.getSetting() == InventoryReader.Modes.POS) {
                this.part.posSlot.setObject((Object)num);
                this.part.sendByteBufPacket(this.part.posSlot.id);
            }
        }
    }

    public String getSettingsString() {
        return ((InventoryReader.Modes)this.part.setting.getObject()).getClientName();
    }

    @Override
    public List<MonitoredItemStack> getGridList() {
        String search = this.searchField.func_146179_b();
        if (search.isEmpty() || search.equals(" ")) {
            return this.part.getMonitoredList().createSaveableList(this.part.getSorter());
        }
        ArrayList<MonitoredItemStack> searchlist = new ArrayList<MonitoredItemStack>();
        List cached = this.part.getMonitoredList().createSaveableList(this.part.getSorter());
        for (MonitoredItemStack stack : cached) {
            StoredItemStack item = stack.getStoredStack();
            if (item == null || !item.item.func_82833_r().toLowerCase().contains(search.toLowerCase())) continue;
            searchlist.add(stack);
        }
        return searchlist;
    }

    @Override
    public void onGridClicked(MonitoredItemStack selection, int x, int y, int pos, int button, boolean empty) {
        if (Keyboard.isKeyDown((int)42)) {
            button = 2;
        }
        if (!empty) {
            PL2.network.sendToServer((IMessage)new PacketInventoryReader(this.part.getSlotID(), this.part.func_174877_v(), selection.getStoredStack().item, button));
        } else {
            PL2.network.sendToServer((IMessage)new PacketInventoryReader(this.part.getSlotID(), this.part.func_174877_v(), null, button));
        }
    }

    @Override
    public void renderStrings(int x, int y) {
    }

    @Override
    public void renderGridElement(MonitoredItemStack selection, int x, int y, int slot) {
        StoredItemStack storedStack = selection.getStoredStack();
        if (storedStack == null) {
            return;
        }
        ItemStack stack = storedStack.item;
        stack.func_190920_e(1);
        this.drawNormalItemStack(stack, 0, 0);
        RenderHelper.renderStoredItemStackOverlay((ItemStack)stack, (long)storedStack.stored, (int)0, (int)0, null, (boolean)true);
    }

    @Override
    public void renderElementToolTip(MonitoredItemStack element, int x, int y) {
        StoredItemStack storedStack = element.getStoredStack();
        if (storedStack == null) {
            return;
        }
        List list = storedStack.item.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)(this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        list.add(1, PL2Translate.BUTTON_STORED.t() + ": " + storedStack.stored);
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, storedStack.item.func_77953_t().field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, TextFormatting.GRAY + (String)list.get(k));
        }
        FontRenderer font = storedStack.item.func_77973_b().getFontRenderer(storedStack.item);
        this.drawHoveringText(list, x, y, font == null ? this.field_146289_q : font);
    }

    @Override
    public void func_146976_a(float var1, int var2, int var3) {
        super.func_146976_a(var1, var2, var3);
        if (this.getSetting() == InventoryReader.Modes.STACK) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(playerInv);
            this.func_73729_b(this.field_147003_i + 62, this.field_147009_r + 8, 0, 0, 18, 18);
        }
    }
}

