/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.fluids.handling;

import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import sonar.core.SonarCore;
import sonar.core.api.fluids.ISonarFluidHandler;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.api.utils.ActionType;
import sonar.core.handlers.fluids.FluidHelper;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.nodes.NodeTransferMode;
import sonar.logistics.base.channels.BlockConnection;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.utils.CacheType;
import sonar.logistics.core.tiles.connections.data.network.NetworkHelper;

public class FluidHelper {
    public static StoredFluidStack transferFluids(ILogisticsNetwork network, StoredFluidStack add, NodeTransferMode mode, ActionType action, FluidHelper.ITankFilter filter) {
        if (!FluidHelper.validStack(add)) {
            return add;
        }
        return NetworkHelper.forEachTileEntity(network, CacheType.ALL, c -> c.canTransferFluid((NodeConnection)c, add, mode), FluidHelper.getTileAction(add, mode, action, filter)) ? add : null;
    }

    private static BiPredicate<BlockConnection, TileEntity> getTileAction(StoredFluidStack stack, NodeTransferMode mode, ActionType action, FluidHelper.ITankFilter filter) {
        return (c, t) -> stack.setStackSize(FluidHelper.transfer(mode, t, stack, c.face, action)).getStackSize() != 0L;
    }

    private static StoredFluidStack transfer(NodeTransferMode mode, TileEntity tile, StoredFluidStack stack, EnumFacing dir, ActionType action) {
        List handlers = SonarCore.fluidHandlers;
        for (ISonarFluidHandler handler : handlers) {
            if (!handler.canHandleFluids(tile, dir)) continue;
            StoredFluidStack copy = stack.copy().setStackSize(stack);
            stack = mode.shouldRemove() ? handler.removeStack(copy, tile, dir, action) : handler.addStack(stack, tile, dir, action);
            return stack;
        }
        return null;
    }

    public static boolean validStack(StoredFluidStack stack) {
        return stack != null && stack.getStackSize() != 0L;
    }
}

