/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.tiles.connected;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.ISyncableListener;
import sonar.core.network.sync.SyncCoords;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.sync.SyncableList;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.core.tiles.connections.EnumCableConnection;
import sonar.logistics.api.core.tiles.connections.EnumCableConnectionType;
import sonar.logistics.api.core.tiles.connections.EnumCableRenderSize;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.displays.tiles.IDisplay;
import sonar.logistics.api.core.tiles.displays.tiles.ILargeDisplay;
import sonar.logistics.base.guidance.errors.ErrorMessage;
import sonar.logistics.base.listeners.ILogicListenable;
import sonar.logistics.base.utils.slots.EnumDisplayFaceSlot;
import sonar.logistics.base.utils.worlddata.ConnectedDisplayData;
import sonar.logistics.core.tiles.connections.data.handling.CableConnectionHelper;
import sonar.logistics.core.tiles.displays.DisplayHandler;
import sonar.logistics.core.tiles.displays.DisplayHelper;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.storage.EditContainer;
import sonar.logistics.core.tiles.displays.tiles.DisplayVectorHelper;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;
import sonar.logistics.core.tiles.displays.tiles.connected.ConnectedDisplayChange;

public class ConnectedDisplay
implements IDisplay,
INBTSyncable,
ISyncPart,
ISyncableListener {
    public int dim;
    public int registryID;
    public ILargeDisplay topLeftScreen = null;
    public SyncableList syncParts = new SyncableList((ISyncableListener)this);
    public SyncEnum<EnumFacing> face = new SyncEnum((Enum[])EnumFacing.field_82609_l, 0);
    public SyncTagType.DOUBLE width = new SyncTagType.DOUBLE(2);
    public SyncTagType.DOUBLE height = new SyncTagType.DOUBLE(3);
    public SyncTagType.BOOLEAN canBeRendered = (SyncTagType.BOOLEAN)new SyncTagType.BOOLEAN(4).setDefault((Object)true);
    public DisplayGSI gsi = null;
    public SyncCoords topLeftCoords = new SyncCoords(5);
    public SyncTagType.BOOLEAN isLocked = new SyncTagType.BOOLEAN(6);
    public World world;
    public Vec3d screenScale = new Vec3d(0.0, 0.0, 0.0);
    public Vec3d screenRotation = new Vec3d(0.0, 0.0, 0.0);
    public Vec3d screenOrigin = new Vec3d(0.0, 0.0, 0.0);

    ConnectedDisplay() {
        this.syncParts.addParts(new IDirtyPart[]{this.face, this.width, this.height, this.canBeRendered, this.topLeftCoords, this.isLocked});
    }

    public static ConnectedDisplay loadDisplay(World world, int registryID) {
        NBTTagCompound tag = world.field_72995_K ? null : ConnectedDisplayData.unloadedDisplays.get(registryID);
        return ConnectedDisplay.loadDisplay(world, registryID, tag);
    }

    public static ConnectedDisplay loadDisplay(World world, int registryID, NBTTagCompound tag) {
        ConnectedDisplay display = new ConnectedDisplay();
        display.world = world;
        display.gsi = new DisplayGSI(display, world, registryID);
        display.registryID = registryID;
        if (tag != null) {
            display.readData(tag, NBTHelper.SyncType.SAVE);
            ConnectedDisplayData.unloadedDisplays.remove(registryID);
        }
        if (world.field_72995_K) {
            EditContainer.addEditContainer(display.gsi);
        }
        return display;
    }

    public void setDisplayScaling() {
        List<ILargeDisplay> displays = DisplayHandler.instance().getConnections(this.getRegistryID());
        if (displays.isEmpty()) {
            this.canBeRendered.setObject((Object)false);
            displays.forEach(d -> d.setShouldRender(false));
            return;
        }
        displays.forEach(display -> display.setConnectedDisplay(this));
        this.topLeftScreen = (ILargeDisplay)displays.get(0);
        Vec3d p = DisplayVectorHelper.convertVector((Vec3i)this.topLeftScreen.getCoords().getBlockPos()).func_72441_c(0.5, 0.5, 0.5);
        double minX = p.field_72450_a;
        double maxX = p.field_72450_a;
        double minY = p.field_72448_b;
        double maxY = p.field_72448_b;
        double minZ = p.field_72449_c;
        double maxZ = p.field_72449_c;
        for (ILargeDisplay display2 : displays) {
            Vec3d pos = DisplayVectorHelper.convertVector((Vec3i)display2.getCoords().getBlockPos()).func_72441_c(0.5, 0.5, 0.5);
            minX = Math.min(pos.field_72450_a, minX);
            maxX = Math.max(pos.field_72450_a, maxX);
            minY = Math.min(pos.field_72448_b, minY);
            maxY = Math.max(pos.field_72448_b, maxY);
            minZ = Math.min(pos.field_72449_c, minZ);
            maxZ = Math.max(pos.field_72449_c, maxZ);
        }
        double width = 0.0;
        double height = 0.0;
        switch (this.getCableFace().func_176740_k()) {
            case X: {
                width = maxZ - minZ;
                height = maxY - minY;
                break;
            }
            case Y: {
                width = maxX - minX;
                height = maxZ - minZ;
                break;
            }
            case Z: {
                width = maxX - minX;
                height = maxY - minY;
                break;
            }
        }
        this.width.setObject((Object)(width += 0.875));
        this.height.setObject((Object)(height += 0.875));
        this.screenOrigin = new Vec3d((minX + maxX) / 2.0, (minY + maxY) / 2.0, (minZ + maxZ) / 2.0).func_178787_e(DisplayVectorHelper.getFaceOffset(this.getCableFace(), 0.5));
        this.screenRotation = DisplayVectorHelper.getScreenRotation(this.getCableFace());
        this.screenScale = new Vec3d(width, height, 0.001);
        if (Math.ceil(width) * Math.ceil(height) != (double)displays.size()) {
            this.canBeRendered.setObject((Object)false);
            displays.forEach(d -> d.setShouldRender(false));
            return;
        }
        Vec3d[] vectors = DisplayVectorHelper.getScreenVectors(this, DisplayVectorHelper.getLookVector(this.getPitch(), this.getYaw()));
        Vec3i topLeft = DisplayVectorHelper.convertVector(DisplayVectorHelper.getTopRight(new Vec3d((minX + maxX) / 2.0, (minY + maxY) / 2.0, (minZ + maxZ) / 2.0), vectors[0], vectors[1], width, height));
        displays.forEach(display -> this.setTopLeftScreen((ILargeDisplay)display, display.getCoords().getBlockPos().equals((Object)topLeft)));
        this.canBeRendered.setObject((Object)true);
        this.gsi.updateScaling();
    }

    @Override
    public Vec3d getScreenScaling() {
        return this.screenScale;
    }

    @Override
    public Vec3d getScreenOrigin() {
        return this.screenOrigin;
    }

    @Override
    public Vec3d getScreenRotation() {
        return this.screenRotation;
    }

    public List<ILogicListenable> getLocalProviders(List<ILogicListenable> monitors) {
        List displays = DisplayHandler.instance().getConnections(this.registryID);
        for (ILargeDisplay display : displays) {
            if (!(display instanceof TileAbstractDisplay)) continue;
            monitors = DisplayHelper.getLocalProvidersFromDisplay(monitors, (IBlockAccess)((TileAbstractDisplay)((Object)display)).func_145831_w(), ((TileAbstractDisplay)((Object)display)).func_174877_v(), display);
        }
        return monitors;
    }

    @Override
    public ILargeDisplay getActualDisplay() {
        return this.getTopLeftScreen();
    }

    public void setTopLeftScreen(ILargeDisplay display, boolean isTopLeft) {
        if (isTopLeft) {
            this.topLeftScreen = display;
            this.topLeftCoords.setCoords(display.getCoords());
            display.setShouldRender(true);
            this.face.setObject((Enum)display.getCableFace());
        } else {
            display.setShouldRender(false);
        }
    }

    public ILargeDisplay getTopLeftScreen() {
        IDisplay display;
        if (this.topLeftCoords.getCoords() != null && (display = CableConnectionHelper.getDisplay(this.world, this.topLeftCoords.getCoords().getBlockPos(), EnumDisplayFaceSlot.fromFace((EnumFacing)this.face.getObject()))) instanceof ILargeDisplay) {
            this.topLeftScreen = (ILargeDisplay)display;
        }
        return this.topLeftScreen;
    }

    @Override
    public DisplayGSI getGSI() {
        return this.gsi;
    }

    @Override
    public void setGSI(DisplayGSI gsi) {
        this.gsi = gsi;
    }

    @Override
    public EnumFacing getCableFace() {
        return (EnumFacing)this.face.getObject();
    }

    public BlockCoords getCoords() {
        return this.getTopLeftScreen() != null ? this.topLeftScreen.getCoords() : this.topLeftCoords.getCoords();
    }

    public int getDimension() {
        return this.getCoords().getDimension();
    }

    @Override
    public int getInfoContainerID() {
        return this.getRegistryID();
    }

    @Override
    public void onInfoContainerPacket() {
        DisplayHandler.instance().markConnectedDisplayChanged(this.getRegistryID(), ConnectedDisplayChange.WATCHERS_CHANGED);
    }

    public int getRegistryID() {
        return this.registryID;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (nbt.func_74764_b(this.getTagName())) {
            NBTTagCompound tag = nbt.func_74775_l(this.getTagName());
            NBTHelper.readSyncParts((NBTTagCompound)tag, (NBTHelper.SyncType)type, (SyncableList)this.syncParts);
            this.screenScale = DisplayVectorHelper.readVec3d("scale", nbt, type);
            this.screenRotation = DisplayVectorHelper.readVec3d("rotate", nbt, type);
            this.screenOrigin = DisplayVectorHelper.readVec3d("origin", nbt, type);
            this.getGSI().readData(tag, type);
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTHelper.writeSyncParts((NBTTagCompound)tag, (NBTHelper.SyncType)type, (SyncableList)this.syncParts, (boolean)true);
        DisplayVectorHelper.writeVec3d(this.screenScale, "scale", nbt, type);
        DisplayVectorHelper.writeVec3d(this.screenRotation, "rotate", nbt, type);
        DisplayVectorHelper.writeVec3d(this.screenOrigin, "origin", nbt, type);
        this.getGSI().writeData(tag, type);
        if (!tag.func_82582_d()) {
            nbt.func_74782_a(this.getTagName(), (NBTBase)tag);
        }
        return nbt;
    }

    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
    }

    public void readFromBuf(ByteBuf buf) {
        this.readData(ByteBufUtils.readTag((ByteBuf)buf), NBTHelper.SyncType.SAVE);
    }

    public boolean canSync(NBTHelper.SyncType sync) {
        return NBTHelper.SyncType.isGivenType((NBTHelper.SyncType)sync, (NBTHelper.SyncType[])new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE});
    }

    public String getTagName() {
        return "connected";
    }

    public ISyncableListener getListener() {
        return this;
    }

    public IDirtyPart setListener(ISyncableListener listener) {
        if (listener instanceof ILargeDisplay && listener != this.topLeftScreen) {
            this.setTopLeftScreen((ILargeDisplay)listener, true);
        }
        return this;
    }

    public void markChanged(IDirtyPart part) {
        this.syncParts.markSyncPartChanged(part);
        if (!this.getActualWorld().field_72995_K) {
            DisplayHandler.instance().markConnectedDisplayChanged(this.getRegistryID(), ConnectedDisplayChange.WATCHERS_CHANGED);
        }
    }

    @Override
    public int getNetworkID() {
        return this.getTopLeftScreen().getNetworkID();
    }

    @Override
    public ILogisticsNetwork getNetwork() {
        return this.getTopLeftScreen().getNetwork();
    }

    @Override
    public int getIdentity() {
        return this.registryID;
    }

    @Override
    public ErrorMessage[] getValidMessages() {
        return new ErrorMessage[0];
    }

    @Override
    public PL2Multiparts getMultipart() {
        return PL2Multiparts.LARGE_DISPLAY_SCREEN;
    }

    @Override
    public void onNetworkConnect(ILogisticsNetwork network) {
    }

    @Override
    public void onNetworkDisconnect(ILogisticsNetwork network) {
    }

    public boolean isValid() {
        return true;
    }

    @Override
    public EnumCableConnection canConnect(int registryID, EnumCableConnectionType type, EnumFacing dir, boolean internal) {
        return EnumCableConnection.NETWORK;
    }

    @Override
    public EnumCableRenderSize getCableRenderSize(EnumFacing dir) {
        return EnumCableRenderSize.CABLE;
    }

    public World getActualWorld() {
        return this.gsi.getWorld();
    }

    public World getPartWorld() {
        return this.getTopLeftScreen().getPartWorld();
    }
}

