/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.text.styling;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.ListHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.elements.base.WidthAlignment;
import sonar.logistics.core.tiles.displays.info.types.text.StyledTextElement;
import sonar.logistics.core.tiles.displays.info.types.text.styling.IStyledString;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledString;

public class StyledStringLine
implements INBTSyncable,
Iterable<IStyledString> {
    private StyledTextElement text;
    private List<IStyledString> strings = new ArrayList<IStyledString>();
    private int cachedWidth = -1;
    private String cachedFormattedString;
    private String cachedUnformattedString;
    private int[] unformattedSize;
    private WidthAlignment align = WidthAlignment.CENTERED;

    public StyledStringLine(StyledTextElement text) {
        this.setText(text);
    }

    public StyledStringLine(StyledTextElement text, String s) {
        this(text, new StyledString(s));
    }

    public StyledStringLine(StyledTextElement text, IStyledString s) {
        this.setText(text);
        this.setStrings(Lists.newArrayList((Object[])new IStyledString[]{s}));
    }

    public StyledTextElement setText(StyledTextElement text) {
        this.text = text;
        return this.text;
    }

    public StyledTextElement getText() {
        return this.text;
    }

    public DisplayGSI getGSI() {
        return this.getText().getGSI();
    }

    public double render() {
        int offsetX = 0;
        boolean offsetY = false;
        for (IStyledString s : this.strings) {
            FontHelper.text((String)s.getFormattedString(), (int)offsetX, (int)0, (int)s.getStyle().getFontColour());
            offsetX += RenderHelper.fontRenderer.func_78256_a(s.getFormattedString());
        }
        return 0.0;
    }

    public List<IStyledString> getStrings() {
        return this.strings;
    }

    public List<IStyledString> setStrings(List<IStyledString> strings) {
        strings.forEach(ss -> ss.setLine(this));
        this.strings = strings;
        this.updateTextContents();
        return this.strings;
    }

    public List<Integer> getContainedActions() {
        ArrayList<Integer> actions = new ArrayList<Integer>();
        this.forEach(ss -> ListHelper.addWithCheck((Collection)actions, (Object)ss.getStyle().getActionID()));
        return actions;
    }

    public WidthAlignment getAlign() {
        return this.align;
    }

    public void setAlign(WidthAlignment align) {
        this.align = align;
        this.updateTextScaling();
    }

    public void updateTextScaling() {
        if (this.getText() != null) {
            this.getText().markTextScalingChanged();
        }
    }

    public void updateTextContents() {
        if (this.getText() != null) {
            this.getText().markTextContentsChanged();
            this.cachedUnformattedString = null;
            this.cachedFormattedString = null;
            this.cachedWidth = -1;
            this.updateTextScaling();
        }
    }

    public Tuple<Integer, IStyledString> getCursorPosition(int cursorIndex) {
        if (cursorIndex == -1) {
            return null;
        }
        int length = 0;
        for (IStyledString ss : this.strings) {
            int sLength = ss.getStringLength();
            if (length + sLength > cursorIndex) {
                return new Tuple((Object)(cursorIndex - length), (Object)ss);
            }
            length += sLength;
        }
        return null;
    }

    public void addWithCombine(IStyledString ss) {
        ss.setLine(this);
        StyledStringLine.addWithCombine(this.strings, ss);
        this.updateTextContents();
    }

    public static void addWithCombine(List<IStyledString> strings, IStyledString ss) {
        if (strings.isEmpty()) {
            strings.add(ss);
            return;
        }
        IStyledString lastSS = strings.get(strings.size() - 1);
        if (lastSS.canCombine(ss)) {
            lastSS.combine(ss);
        } else {
            strings.add(ss);
        }
    }

    public String getCachedFormattedString() {
        if (this.cachedFormattedString == null) {
            StringBuilder build = new StringBuilder();
            this.strings.forEach(s -> build.append(s.getFormattedString()).append(TextFormatting.RESET));
            this.cachedFormattedString = build.toString();
        }
        return this.cachedFormattedString;
    }

    public String getCachedUnformattedString() {
        if (this.cachedUnformattedString == null) {
            StringBuilder build = new StringBuilder();
            this.strings.forEach(s -> build.append(s.getUnformattedString()));
            this.cachedUnformattedString = build.toString();
        }
        return this.cachedUnformattedString;
    }

    public String toString() {
        return this.getCachedFormattedString();
    }

    public int getStringWidth() {
        if (this.cachedWidth == -1) {
            int width = 0;
            for (IStyledString ss : this.strings) {
                width += ss.getStringWidth();
            }
            this.cachedWidth = width;
        }
        return this.cachedWidth;
    }

    public int getStringHeight() {
        return RenderHelper.fontRenderer.field_78288_b;
    }

    public StyledStringLine lightCopy(StyledTextElement text) {
        StyledStringLine line = new StyledStringLine(text);
        line.setStrings(Lists.newArrayList(this.strings));
        return line;
    }

    public StyledStringLine deepCopy(StyledTextElement text) {
        StyledStringLine line = new StyledStringLine(text);
        ArrayList<IStyledString> newStrings = new ArrayList<IStyledString>();
        for (IStyledString ss : this.strings) {
            newStrings.add(ss.copy());
        }
        line.setStrings(newStrings);
        return line;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.strings.clear();
        NBTTagList tagList = nbt.func_150295_c("ss", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound ssTag = tagList.func_150305_b(i);
            this.strings.add(DisplayElementHelper.loadStyledString(this, ssTag));
        }
        this.setAlign(WidthAlignment.values()[nbt.func_74762_e("wa")]);
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagList tagList = new NBTTagList();
        for (IStyledString ss : this.strings) {
            tagList.func_74742_a((NBTBase)DisplayElementHelper.saveStyledString(new NBTTagCompound(), ss, type));
        }
        if (!tagList.func_82582_d()) {
            nbt.func_74782_a("ss", (NBTBase)tagList);
        }
        nbt.func_74768_a("wa", this.getAlign().ordinal());
        return nbt;
    }

    @Override
    @Nonnull
    public Iterator<IStyledString> iterator() {
        return this.strings.iterator();
    }
}

