/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.text;

import java.util.List;
import javax.annotation.Nullable;
import javax.xml.ws.Holder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import sonar.core.client.gui.IGuiOrigin;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.api.asm.ASMDisplayElement;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.gsi.interaction.actions.IDisplayAction;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.elements.base.WidthAlignment;
import sonar.logistics.core.tiles.displays.info.types.text.StyledTextElement;
import sonar.logistics.core.tiles.displays.info.types.text.gui.GuiEditTitleStyledString;
import sonar.logistics.core.tiles.displays.info.types.text.styling.IStyledString;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledStringLine;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

@ASMDisplayElement(id="styled_title", modid="practicallogistics2")
public class StyledTitleElement
extends StyledTextElement {
    private int cachedWidth = -1;
    private int cachedHeight = -1;
    public static final String REGISTRY_NAME = "styled_title";

    public StyledTitleElement() {
    }

    public StyledTitleElement(String string) {
        super(string);
    }

    public StyledTitleElement(List<String> strings) {
        super(strings);
    }

    @Override
    public void updateRender() {
        super.updateRender();
        if (this.updateTextContents) {
            this.cachedWidth = -1;
            this.cachedHeight = -1;
        }
    }

    @Override
    public void render() {
        double[] scaling = DisplayElementHelper.getScaling(this.getUnscaledWidthHeight(), this.getMaxScaling(), 100.0);
        double max_width = this.getMaxScaling()[0];
        GlStateManager.func_179140_f();
        for (StyledStringLine s : this) {
            this.preRender(s);
            GlStateManager.func_179094_E();
            double element = (double)s.getStringWidth() * scaling[2];
            if (s.getAlign() == WidthAlignment.CENTERED) {
                GlStateManager.func_179137_b((double)(max_width / 2.0 - element / 2.0), (double)0.0, (double)0.0);
            }
            if (s.getAlign() == WidthAlignment.RIGHT) {
                GlStateManager.func_179137_b((double)(max_width - element), (double)0.0, (double)0.0);
            }
            GlStateManager.func_179139_a((double)scaling[2], (double)scaling[2], (double)1.0);
            s.render();
            GlStateManager.func_179139_a((double)(1.0 / scaling[2]), (double)(1.0 / scaling[2]), (double)1.0);
            GlStateManager.func_179121_F();
            GL11.glTranslated((double)0.0, (double)((double)(s.getStringHeight() + this.spacing) * scaling[2]), (double)0.0);
            this.postRender(s);
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public Object getClientEditGui(TileAbstractDisplay obj, Object origin, World world, EntityPlayer player) {
        return IGuiOrigin.withOrigin((IGuiOrigin)new GuiEditTitleStyledString(this, obj), (Object)origin);
    }

    @Override
    public double[] getAlignmentTranslation(double[] maxScaling, double[] actualScaling) {
        double[] scaling = DisplayElementHelper.getScaling(this.getUnscaledWidthHeight(), this.getMaxScaling(), 100.0);
        double[] align_array = DisplayElementHelper.alignArray(maxScaling, this.getActualScaling(), this.getWidthAlignment(), this.getHeightAlignment());
        double maxHeight = this.getMaxScaling()[1];
        double height = (double)this.getHeight() * scaling[2];
        switch (this.height_align) {
            case CENTERED: {
                align_array[1] = align_array[1] + (maxHeight / 2.0 - height / 2.0);
                break;
            }
            case TOP: {
                break;
            }
            case BOTTOM: {
                align_array[1] = align_array[1] + (maxHeight - height);
            }
        }
        return align_array;
    }

    public int getWidth() {
        if (this.cachedWidth == -1) {
            int width = 0;
            for (StyledStringLine ss : this) {
                int w = ss.getStringWidth();
                if (w <= width) continue;
                width = w;
            }
            this.cachedWidth = width;
        }
        return this.cachedWidth;
    }

    public int getHeight() {
        if (this.cachedHeight == -1) {
            int height = 0;
            for (StyledStringLine ss : this) {
                int h = ss.getStringHeight() + this.spacing;
                height += h;
            }
            this.cachedHeight = height;
        }
        return this.cachedHeight;
    }

    @Override
    public int[] createUnscaledWidthHeight() {
        return new int[]{this.getWidth(), this.getHeight()};
    }

    @Override
    public int onGSIClicked(DisplayScreenClick click, EntityPlayer player, double subClickX, double subClickY) {
        IDisplayAction action;
        Tuple<IStyledString, Integer> string = this.getStringClicked(subClickX, subClickY);
        if (string != null && string.func_76341_a() != null && (action = this.getAction(((IStyledString)string.func_76341_a()).getStyle().action_id)) != null) {
            return action.doAction(click, player, subClickX, subClickY);
        }
        return -1;
    }

    @Nullable
    public int[] getIndexClicked(double subClickX, double subClickY) {
        return this.getIndexClicked((Holder<Double>)new Holder((Object)subClickX), (Holder<Double>)new Holder((Object)subClickY));
    }

    @Nullable
    private int[] getIndexClicked(Holder<Double> subClickX, Holder<Double> subClickY) {
        double[] scaling = DisplayElementHelper.getScaling(this.getUnscaledWidthHeight(), this.getMaxScaling(), 100.0);
        Tuple<StyledStringLine, Integer> line = this.getLineClicked((Double)subClickX.value, (Double)subClickY.value);
        Tuple<IStyledString, Integer> string = this.getStringClicked((Double)subClickX.value, (Double)subClickY.value);
        if (string != null && StyledTitleElement.isValidReturn((Integer)string.func_76340_b())) {
            double rough_click = (Double)subClickX.value;
            Tuple<Character, Integer> character = this.getCharClicked((Double)subClickX.value, (Double)subClickY.value);
            if (StyledTitleElement.isValidReturn((Integer)character.func_76340_b())) {
                int i = 0;
                int index = 0;
                for (IStyledString s : (StyledStringLine)line.func_76341_a()) {
                    if (i == (Integer)string.func_76340_b()) break;
                    index += s.getStringLength();
                    ++i;
                }
                double actual_click = (Double)subClickX.value / scaling[2];
                int charWidth = RenderHelper.fontRenderer.func_78256_a(((IStyledString)string.func_76341_a()).getTextFormattingStyle() + character.func_76341_a());
                return new int[]{Math.min(index + (Integer)character.func_76340_b(), ((StyledStringLine)line.func_76341_a()).getCachedUnformattedString().length()), (Integer)line.func_76340_b()};
            }
        }
        return null;
    }

    public Tuple<StyledStringLine, Integer> getLineClicked(double subClickX, double subClickY) {
        return this.getLineClicked((Holder<Double>)new Holder((Object)subClickX), (Holder<Double>)new Holder((Object)subClickY));
    }

    private Tuple<StyledStringLine, Integer> getLineClicked(Holder<Double> subClickX, Holder<Double> subClickY) {
        double[] scaling = DisplayElementHelper.getScaling(this.getUnscaledWidthHeight(), this.getMaxScaling(), 100.0);
        double max_width = this.getMaxScaling()[0];
        double y = 0.0;
        int i = 0;
        for (StyledStringLine c : this) {
            double height = (double)c.getStringHeight() * scaling[2];
            if (y <= (Double)subClickY.value && y + height >= (Double)subClickY.value) {
                subClickY.value = y;
                double element = (double)c.getStringWidth() * scaling[2];
                if (c.getAlign() == WidthAlignment.CENTERED) {
                    Holder<Double> holder = subClickX;
                    holder.value = (Double)holder.value - (max_width / 2.0 - element / 2.0);
                } else if (c.getAlign() == WidthAlignment.RIGHT) {
                    Holder<Double> holder = subClickX;
                    holder.value = (Double)holder.value - (max_width - element);
                }
                return new Tuple((Object)c, (Object)i);
            }
            y += height + (double)this.spacing * scaling[2];
            ++i;
        }
        return new Tuple(null, (Object)-1);
    }

    public Tuple<IStyledString, Integer> getStringClicked(double subClickX, double subClickY) {
        return this.getStringClicked((Holder<Double>)new Holder((Object)subClickX), (Holder<Double>)new Holder((Object)subClickY));
    }

    private Tuple<IStyledString, Integer> getStringClicked(Holder<Double> subClickX, Holder<Double> subClickY) {
        Tuple<StyledStringLine, Integer> line = this.getLineClicked(subClickX, subClickY);
        if (StyledTitleElement.isValidReturn((Integer)line.func_76340_b())) {
            return this.getStringClicked(line, subClickX, subClickY);
        }
        return new Tuple(null, line.func_76340_b());
    }

    private Tuple<IStyledString, Integer> getStringClicked(Tuple<StyledStringLine, Integer> line, Holder<Double> subClickX, Holder<Double> subClickY) {
        double[] scaling = DisplayElementHelper.getScaling(this.getUnscaledWidthHeight(), this.getMaxScaling(), 100.0);
        double x = 0.0;
        int i = 0;
        for (IStyledString string : (StyledStringLine)line.func_76341_a()) {
            double width = (double)string.getStringWidth() * scaling[2];
            if (x <= (Double)subClickX.value && x + width >= (Double)subClickX.value) {
                Holder<Double> holder = subClickX;
                holder.value = (Double)holder.value - x;
                return new Tuple((Object)string, (Object)i);
            }
            if (i == 0 && (Double)subClickX.value < x) {
                return new Tuple(null, (Object)-3);
            }
            x += width;
            ++i;
        }
        return new Tuple(null, (Object)-2);
    }

    public Tuple<Character, Integer> getCharClicked(double subClickX, double subClickY) {
        return this.getCharClicked((Holder<Double>)new Holder((Object)subClickX), (Holder<Double>)new Holder((Object)subClickY));
    }

    private Tuple<Character, Integer> getCharClicked(Holder<Double> subClickX, Holder<Double> subClickY) {
        Tuple<IStyledString, Integer> line = this.getStringClicked(subClickX, subClickY);
        if (StyledTitleElement.isValidReturn((Integer)line.func_76340_b())) {
            return ((IStyledString)line.func_76341_a()).getCharClicked((Integer)line.func_76340_b(), subClickX, subClickY);
        }
        return new Tuple(null, (Object)-1);
    }

    @Override
    public String getRegisteredName() {
        return REGISTRY_NAME;
    }
}

