/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.elements;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.core.tiles.displays.info.InfoRenderHelper;
import sonar.logistics.core.tiles.displays.info.elements.AbstractDisplayElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IInfoReferenceElement;

public abstract class AbstractInfoElement<T extends IInfo>
extends AbstractDisplayElement
implements IInfoReferenceElement {
    public InfoUUID uuid;
    public IInfo info;

    public AbstractInfoElement() {
    }

    public AbstractInfoElement(InfoUUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public void render() {
        this.info = this.getGSI().getCachedInfo(this.uuid);
        if (this.info != null && this.isType(this.info)) {
            this.render(this.info);
        } else {
            InfoRenderHelper.renderCenteredStringsWithAdaptiveScaling(this.getActualScaling()[0], this.getActualScaling()[1], this.getActualScaling()[2], 0, 0.5, -1, Lists.newArrayList((Object[])new String[]{"NO DATA"}));
        }
    }

    public abstract boolean isType(IInfo var1);

    public abstract void render(T var1);

    @Override
    public List<InfoUUID> getInfoReferences() {
        return Lists.newArrayList((Object[])new InfoUUID[]{this.uuid});
    }

    @Override
    public String getRepresentiveString() {
        return this.uuid.toString();
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.uuid = new InfoUUID();
        this.uuid.readData(nbt, type);
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        this.uuid.writeData(nbt, type);
        return nbt;
    }
}

