/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.events;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import sonar.core.helpers.ListHelper;
import sonar.core.listener.ISonarListener;
import sonar.core.utils.IWorldTile;
import sonar.logistics.PL2;
import sonar.logistics.PL2Logging;
import sonar.logistics.api.core.tiles.connections.ICable;
import sonar.logistics.api.core.tiles.connections.data.IDataCable;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.connections.redstone.IRedstoneCable;
import sonar.logistics.api.core.tiles.displays.tiles.IDisplay;
import sonar.logistics.api.core.tiles.displays.tiles.ILargeDisplay;
import sonar.logistics.api.core.tiles.nodes.IEntityNode;
import sonar.logistics.api.core.tiles.nodes.INode;
import sonar.logistics.api.core.tiles.readers.IInfoProvider;
import sonar.logistics.api.core.tiles.readers.IListReader;
import sonar.logistics.api.core.tiles.readers.channels.INetworkChannels;
import sonar.logistics.api.core.tiles.readers.channels.INetworkHandler;
import sonar.logistics.api.core.tiles.wireless.emitters.IDataEmitter;
import sonar.logistics.api.core.tiles.wireless.receivers.IDataReceiver;
import sonar.logistics.base.ClientInfoHandler;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.base.events.EventScheduler;
import sonar.logistics.base.events.NetworkChanges;
import sonar.logistics.base.events.types.InfoEvent;
import sonar.logistics.base.events.types.NetworkCableEvent;
import sonar.logistics.base.events.types.NetworkEvent;
import sonar.logistics.base.events.types.NetworkPartEvent;
import sonar.logistics.base.filters.ITransferFilteredTile;
import sonar.logistics.base.listeners.ILogicListenable;
import sonar.logistics.base.tiles.INetworkTile;
import sonar.logistics.base.utils.PL2AdditionType;
import sonar.logistics.base.utils.PL2RemovalType;
import sonar.logistics.core.tiles.connections.data.handling.CableConnectionHandler;
import sonar.logistics.core.tiles.connections.data.network.LogisticsNetwork;
import sonar.logistics.core.tiles.connections.data.network.LogisticsNetworkHandler;
import sonar.logistics.core.tiles.connections.data.network.NetworkHelper;
import sonar.logistics.core.tiles.connections.redstone.handling.RedstoneConnectionHandler;
import sonar.logistics.core.tiles.displays.DisplayHandler;
import sonar.logistics.core.tiles.displays.DisplayInfoReferenceHandler;
import sonar.logistics.core.tiles.displays.DisplayViewerHandler;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.tiles.connected.ConnectedDisplayChange;
import sonar.logistics.core.tiles.nodes.transfer.handling.TransferNetworkChannels;
import sonar.logistics.core.tiles.wireless.handling.WirelessDataManager;
import sonar.logistics.core.tiles.wireless.handling.WirelessRedstoneManager;

public class LogisticsEventHandler {
    public Map<NetworkChanges, List<LogisticsNetwork>> network_changes = new LinkedHashMap<NetworkChanges, List<LogisticsNetwork>>();
    public Map<Class, IQueueHandler> queue_handlers = new LinkedHashMap<Class, IQueueHandler>();
    public Map<Class, Map<Object, PL2AdditionType>> queued_additions = new LinkedHashMap<Class, Map<Object, PL2AdditionType>>();
    public Map<Class, Map<Object, PL2RemovalType>> queued_removals = new LinkedHashMap<Class, Map<Object, PL2RemovalType>>();
    public EventScheduler CONSTRUCTING = new EventScheduler();
    public EventScheduler UPDATING = new EventScheduler();
    public EventScheduler NOTIFYING = new EventScheduler();

    public LogisticsEventHandler() {
        for (NetworkChanges type : NetworkChanges.values()) {
            this.network_changes.put(type, new ArrayList());
        }
        this.queue_handlers.put(IDataCable.class, this::flushDataCables);
        this.queue_handlers.put(IRedstoneCable.class, this::flushRedstoneCables);
        this.queue_handlers.put(ILargeDisplay.class, this::flushLargeDisplays);
        this.queue_handlers.put(IDisplay.class, this::flushDisplays);
        this.queue_handlers.put(INetworkTile.class, this::flushDefaultParts);
        this.queue_handlers.keySet().forEach(clazz -> {
            this.queued_additions.put((Class)clazz, new HashMap());
            this.queued_removals.put((Class)clazz, new HashMap());
        });
    }

    public static LogisticsEventHandler instance() {
        return PL2.proxy.eventHandler;
    }

    public void triggerConstructingPhase() {
        this.queue_handlers.keySet().forEach(TYPE -> {
            Map<Object, PL2AdditionType> added = this.queued_additions.get(TYPE);
            Map<Object, PL2RemovalType> removed = this.queued_removals.get(TYPE);
            HashMap added_copy = Maps.newHashMap(added);
            HashMap removed_copy = Maps.newHashMap(removed);
            this.queued_additions.get(TYPE).clear();
            this.queued_removals.get(TYPE).clear();
            this.queue_handlers.get(TYPE).flushQueue(added_copy, removed_copy);
        });
        this.doNetworkChanges();
        RedstoneConnectionHandler.instance().tick();
        LogisticsNetworkHandler.instance().tick();
        this.CONSTRUCTING.flushEvents();
    }

    public void triggerUpdatingPhase() {
        DisplayInfoReferenceHandler.updateLocalProviderConnections();
        DisplayHandler.instance().updateConnectedDisplays();
        DisplayViewerHandler.instance().updateDisplayViewers();
        this.UPDATING.flushEvents();
    }

    public void triggerNotifyingPhase() {
        ServerInfoHandler.instance().sendInfoUpdates();
        CableConnectionHandler.instance().doRenderUpdates();
        ServerInfoHandler.instance().sendErrors();
        WirelessDataManager.instance().sendDataEmittersToListeners();
        WirelessRedstoneManager.instance().sendDataEmittersToListeners();
        ServerInfoHandler.instance().getGSIMap().values().forEach(DisplayGSI::doQueuedUpdates);
        this.NOTIFYING.flushEvents();
    }

    public void queueNetworkChange(ILogisticsNetwork network, NetworkChanges ... updates) {
        if (!network.isValid()) {
            return;
        }
        for (NetworkChanges update : updates) {
            ListHelper.addWithCheck((Collection)this.network_changes.get((Object)update), (Object)((LogisticsNetwork)network));
        }
    }

    public void queueNetworkAddition(Object tile, PL2AdditionType type) {
        if (tile instanceof IWorldTile && ((IWorldTile)tile).getActualWorld().field_72995_K) {
            return;
        }
        this.queue_handlers.keySet().forEach(clazz -> {
            if (clazz.isInstance(tile)) {
                this.queued_removals.get(clazz).remove(tile);
                PL2AdditionType current = this.queued_additions.get(clazz).get(tile);
                if (current == null || current.ordinal() > type.ordinal()) {
                    this.queued_additions.get(clazz).put(tile, type);
                }
            }
        });
    }

    public void queueNetworkRemoval(Object tile, PL2RemovalType type) {
        if (tile instanceof IWorldTile && ((IWorldTile)tile).getActualWorld().field_72995_K) {
            return;
        }
        this.queue_handlers.keySet().forEach(clazz -> {
            if (clazz.isInstance(tile)) {
                this.queued_additions.get(clazz).remove(tile);
                PL2RemovalType current = this.queued_removals.get(clazz).get(tile);
                if (current == null || current.ordinal() > type.ordinal()) {
                    this.queued_removals.get(clazz).put(tile, type);
                }
            }
        });
    }

    public void flushDataCables(Map<IDataCable, PL2AdditionType> added, Map<IDataCable, PL2RemovalType> removed) {
        added.forEach((cable, type) -> MinecraftForge.EVENT_BUS.post((Event)new NetworkCableEvent.AddedCable((ICable)cable, cable.getActualWorld(), (PL2AdditionType)((Object)type))));
        removed.forEach((cable, type) -> MinecraftForge.EVENT_BUS.post((Event)new NetworkCableEvent.RemovedCable((ICable)cable, cable.getActualWorld(), (PL2RemovalType)((Object)type))));
        CableConnectionHandler.instance().doQueuedUpdates();
    }

    public void flushRedstoneCables(Map<IRedstoneCable, PL2AdditionType> added, Map<IRedstoneCable, PL2RemovalType> removed) {
        added.forEach((cable, type) -> MinecraftForge.EVENT_BUS.post((Event)new NetworkCableEvent.AddedCable((ICable)cable, cable.getActualWorld(), (PL2AdditionType)((Object)type))));
        removed.forEach((cable, type) -> MinecraftForge.EVENT_BUS.post((Event)new NetworkCableEvent.RemovedCable((ICable)cable, cable.getActualWorld(), (PL2RemovalType)((Object)type))));
    }

    public void flushLargeDisplays(Map<ILargeDisplay, PL2AdditionType> added, Map<ILargeDisplay, PL2RemovalType> removed) {
        if (!added.isEmpty() || !removed.isEmpty()) {
            DisplayHandler.instance().rebuild.clear();
            added.forEach((display, type) -> DisplayHandler.instance().onDisplayAddition((ILargeDisplay)display));
            removed.forEach((display, type) -> DisplayHandler.instance().onDisplayRemoval((ILargeDisplay)display));
            DisplayHandler.instance().createConnectedDisplays();
        }
    }

    public void flushDisplays(Map<IDisplay, PL2AdditionType> added, Map<IDisplay, PL2RemovalType> removed) {
        if (!added.isEmpty() || !removed.isEmpty()) {
            added.forEach((display, type) -> DisplayHandler.instance().addDisplay((IDisplay)display, (PL2AdditionType)((Object)type)));
            removed.forEach((display, type) -> DisplayHandler.instance().removeDisplay((IDisplay)display, (PL2RemovalType)((Object)type)));
        }
    }

    public <T extends INetworkTile> void flushDefaultParts(Map<T, PL2AdditionType> added, Map<T, PL2RemovalType> removed) {
        added.forEach((tile, type) -> MinecraftForge.EVENT_BUS.post((Event)new NetworkPartEvent.AddedPart((INetworkTile)tile, tile.getActualWorld(), (PL2AdditionType)((Object)type))));
        removed.forEach((tile, type) -> MinecraftForge.EVENT_BUS.post((Event)new NetworkPartEvent.RemovedPart((INetworkTile)tile, tile.getActualWorld(), (PL2RemovalType)((Object)type))));
    }

    public void doNetworkChanges() {
        for (Map.Entry<NetworkChanges, List<LogisticsNetwork>> entry : this.network_changes.entrySet()) {
            entry.getKey().network.performUpdates(entry.getValue());
            entry.getValue().clear();
        }
    }

    public void updateLocalProviders(List<LogisticsNetwork> networks) {
        List<LogisticsNetwork> watching = this.network_changes.get((Object)NetworkChanges.GLOBAL_PROVIDERS);
        ListHelper.addWithCheck(watching, networks);
        networks.forEach(network -> {
            List<ILogisticsNetwork> watchers = NetworkHelper.getAllNetworks(network, 1);
            watchers.stream().filter(ISonarListener::isValid).forEach(N -> ListHelper.addWithCheck((Collection)watching, (Object)((LogisticsNetwork)N)));
        });
    }

    public void updateLocalChannels(List<LogisticsNetwork> networks) {
        List<LogisticsNetwork> watching = this.network_changes.get((Object)NetworkChanges.GLOBAL_CHANNELS);
        ListHelper.addWithCheck(watching, networks);
        networks.forEach(network -> {
            network.createLocalChannels();
            List<ILogisticsNetwork> watchers = NetworkHelper.getAllNetworks(network, 1);
            watchers.stream().filter(ISonarListener::isValid).forEach(N -> ListHelper.addWithCheck((Collection)watching, (Object)((LogisticsNetwork)N)));
        });
    }

    public void updateGlobalProviders(List<LogisticsNetwork> networks) {
        networks.forEach(LogisticsNetwork::createGlobalProviders);
    }

    public void updateGlobalChannels(List<LogisticsNetwork> networks) {
        networks.forEach(LogisticsNetwork::createGlobalChannels);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPartAdded(NetworkPartEvent.AddedPart event) {
        if (!event.world.field_72995_K) {
            DisplayGSI gsi;
            if (event.tile instanceof ILogicListenable) {
                ServerInfoHandler.instance().addIdentityTile((ILogicListenable)event.tile, event.type);
                DisplayInfoReferenceHandler.queueUpdate((ILogicListenable)event.tile, DisplayInfoReferenceHandler.UpdateCause.getCause(event.type));
            }
            if (event.tile instanceof ILargeDisplay) {
                DisplayHandler.instance().markConnectedDisplayChanged(((ILargeDisplay)event.tile).getRegistryID(), ConnectedDisplayChange.SUB_NETWORK_CHANGED);
            } else if (event.tile instanceof IDisplay && (gsi = ((IDisplay)event.tile).getGSI()) != null) {
                gsi.validateAllInfoReferences();
            }
            if (event.type == PL2AdditionType.PLAYER_ADDED) {
                event.tile.onTileAddition();
            }
        } else if (event.tile instanceof IDisplay) {
            DisplayHandler.addClientDisplay((IDisplay)event.tile, event.type);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPartRemoved(NetworkPartEvent.RemovedPart event) {
        if (!event.world.field_72995_K) {
            DisplayGSI gsi;
            if (event.tile instanceof ILogicListenable) {
                ServerInfoHandler.instance().removeIdentityTile((ILogicListenable)event.tile, event.type);
                DisplayInfoReferenceHandler.queueUpdate((ILogicListenable)event.tile, DisplayInfoReferenceHandler.UpdateCause.getCause(event.type));
            }
            if (event.tile instanceof ILargeDisplay) {
                DisplayHandler.instance().markConnectedDisplayChanged(((ILargeDisplay)event.tile).getRegistryID(), ConnectedDisplayChange.SUB_NETWORK_CHANGED);
            } else if (event.tile instanceof IDisplay && (gsi = ((IDisplay)event.tile).getGSI()) != null) {
                gsi.validateAllInfoReferences();
            }
            if (event.type == PL2RemovalType.PLAYER_REMOVED) {
                event.tile.onTileRemoval();
            }
        } else if (event.tile instanceof IDisplay) {
            DisplayHandler.removeClientDisplay((IDisplay)event.tile, event.type);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onNetworksConnected(NetworkEvent.ConnectedNetwork event) {
        PL2Logging.logConnectedNetworkEvent(event);
        List<IInfoProvider> tiles = event.connected_network.getGlobalInfoProviders();
        tiles.forEach(t -> DisplayInfoReferenceHandler.queueUpdate(t, DisplayInfoReferenceHandler.UpdateCause.NETWORK_CHANGE));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onNetworksDisconnected(NetworkEvent.DisconnectedNetwork event) {
        PL2Logging.logDisconnectedNetworkEvent(event);
        List<IInfoProvider> tiles = event.disconnected_network.getGlobalInfoProviders();
        tiles.forEach(t -> DisplayInfoReferenceHandler.queueUpdate(t, DisplayInfoReferenceHandler.UpdateCause.NETWORK_CHANGE));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onTileConnected(NetworkEvent.ConnectedTile event) {
        PL2Logging.logConnectedTileEvent(event);
        event.network.addConnection(event.tile);
        event.tile.onNetworkConnect(event.network);
        if (event.tile instanceof INode || event.tile instanceof IEntityNode) {
            this.queueNetworkChange(event.network, NetworkChanges.LOCAL_CHANNELS);
        }
        if (event.tile instanceof IListReader) {
            IListReader reader = (IListReader)event.tile;
            List<INetworkHandler> handlers = reader.getValidHandlers();
            for (INetworkHandler handler : handlers) {
                event.network.getOrCreateNetworkChannels(handler.getChannelsType()).addConnection(reader);
            }
        }
        if (event.tile instanceof ITransferFilteredTile) {
            ITransferFilteredTile node = (ITransferFilteredTile)event.tile;
            event.network.getOrCreateNetworkChannels(TransferNetworkChannels.class).addConnection(node);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onTileDisconnected(NetworkEvent.DisconnectedTile event) {
        PL2Logging.logDisconnectedTileEvent(event);
        event.network.removeConnection(event.tile);
        event.tile.onNetworkDisconnect(event.network);
        if (event.tile instanceof INode || event.tile instanceof IEntityNode) {
            this.queueNetworkChange(event.network, NetworkChanges.LOCAL_CHANNELS);
        }
        if (event.tile instanceof IListReader) {
            IListReader reader = (IListReader)event.tile;
            List<INetworkHandler> handlers = reader.getValidHandlers();
            for (INetworkHandler handler : handlers) {
                INetworkChannels channels = event.network.getNetworkChannels(handler.getChannelsType());
                if (channels == null) continue;
                channels.removeConnection(reader);
            }
        }
        if (event.tile instanceof ITransferFilteredTile) {
            ITransferFilteredTile node = (ITransferFilteredTile)event.tile;
            TransferNetworkChannels channels = event.network.getNetworkChannels(TransferNetworkChannels.class);
            if (channels != null) {
                channels.removeConnection(node);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWirelessTileConnected(NetworkEvent.ConnectedTile event) {
        if (event.tile instanceof IDataReceiver) {
            WirelessDataManager.instance().connectReceiver(event.network, (IDataReceiver)event.tile);
        }
        if (event.tile instanceof IDataEmitter) {
            WirelessDataManager.instance().connectEmitter(event.network, (IDataEmitter)event.tile);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWirelessTileDisconnected(NetworkEvent.DisconnectedTile event) {
        if (event.tile instanceof IDataReceiver) {
            WirelessDataManager.instance().disconnectReceiver(event.network, (IDataReceiver)event.tile);
        }
        if (event.tile instanceof IDataEmitter) {
            WirelessDataManager.instance().disconnectEmitter(event.network, (IDataEmitter)event.tile);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLocalProviderConnected(NetworkEvent.ConnectedLocalProvider event) {
        PL2Logging.logConnectedLocalProviderEvent(event);
        event.network.addLocalInfoProvider(event.tile);
        this.queueNetworkChange(event.network, NetworkChanges.LOCAL_PROVIDERS);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLocalProviderDisconnected(NetworkEvent.DisconnectedLocalProvider event) {
        PL2Logging.logDisconnectedLocalProviderEvent(event);
        event.network.removeLocalInfoProvider(event.tile);
        this.queueNetworkChange(event.network, NetworkChanges.LOCAL_PROVIDERS);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onCableAdded(NetworkCableEvent.AddedCable event) {
        if (!event.world.field_72995_K) {
            if (event.tile instanceof IDataCable) {
                CableConnectionHandler.instance().addConnectionToNetwork((IDataCable)event.tile);
            }
            if (event.tile instanceof IRedstoneCable) {
                RedstoneConnectionHandler.instance().addConnectionToNetwork((IRedstoneCable)event.tile);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onCableRemoved(NetworkCableEvent.RemovedCable event) {
        if (!event.world.field_72995_K) {
            if (event.tile instanceof IDataCable) {
                CableConnectionHandler.instance().removeConnectionFromNetwork((IDataCable)event.tile);
            }
            if (event.tile instanceof IRedstoneCable) {
                RedstoneConnectionHandler.instance().removeConnectionFromNetwork((IRedstoneCable)event.tile);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onInfoChanged(InfoEvent.InfoChanged event) {
        if (event.isRemote) {
            for (DisplayGSI display : ClientInfoHandler.instance().gsiMap.values()) {
                if (!display.isDisplayingUUID(event.uuid)) continue;
                display.onInfoChanged(event.uuid, event.newInfo);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onListChanged(InfoEvent.ListChanged event) {
        if (event.isRemote) {
            for (DisplayGSI display : ClientInfoHandler.instance().gsiMap.values()) {
                if (!display.isDisplayingUUID(event.uuid)) continue;
                display.onMonitoredListChanged(event.uuid, event.newList);
            }
        }
    }

    public static interface IQueueHandler<T> {
        public void flushQueue(Map<T, PL2AdditionType> var1, Map<T, PL2RemovalType> var2);
    }
}

