/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tools;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackTools {
    @Nonnull
    public static ItemStack incStackSize(@Nonnull ItemStack stack, int amount) {
        stack.func_190917_f(amount);
        return stack;
    }

    @Nonnull
    public static ItemStack safeCopy(@Nonnull ItemStack stack) {
        return stack.func_77946_l();
    }

    public static int getStackSize(@Nonnull ItemStack stack) {
        return stack.func_190916_E();
    }

    @Nonnull
    public static ItemStack setStackSize(@Nonnull ItemStack stack, int amount) {
        if (amount <= 0) {
            stack.func_190920_e(0);
            return ItemStack.field_190927_a;
        }
        stack.func_190920_e(amount);
        return stack;
    }

    public static boolean isValid(@Nonnull ItemStack stack) {
        return !stack.func_190926_b();
    }

    public static boolean isEmpty(@Nonnull ItemStack stack) {
        return stack.func_190926_b();
    }

    public static void makeEmpty(@Nonnull ItemStack stack) {
        stack.func_190920_e(0);
    }

    @Nonnull
    public static ItemStack loadFromNBT(@Nonnull NBTTagCompound nbt) {
        return new ItemStack(nbt);
    }

    @Nonnull
    public static ItemStack getEmptyStack() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static ItemStack extractItem(@Nullable TileEntity tileEntity, int slot, int amount) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return capability.extractItem(slot, amount, false);
        }
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            return inventory.func_70298_a(slot, amount);
        }
        return ItemStackTools.getEmptyStack();
    }

    @Nonnull
    public static ItemStack getStack(@Nullable TileEntity tileEntity, int slot) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return capability.getStackInSlot(slot);
        }
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            return inventory.func_70301_a(slot);
        }
        return ItemStackTools.getEmptyStack();
    }

    public static void setStack(@Nullable TileEntity tileEntity, int slot, @Nonnull ItemStack stack) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            capability.extractItem(slot, 64, false);
            capability.insertItem(slot, stack, false);
        } else if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            inventory.func_70299_a(slot, stack);
        }
    }

    public static List<ItemStack> getOres(String name) {
        return OreDictionary.getOres((String)name);
    }

    public static List<ItemStack> getOres(String name, boolean alwaysCreateEntry) {
        return OreDictionary.getOres((String)name, (boolean)alwaysCreateEntry);
    }
}

