/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import com.brandon3055.brandonscore.handlers.FileHandler;
import com.brandon3055.projectintelligence.client.ClientEventHandler;
import com.brandon3055.projectintelligence.client.PIGuiHelper;
import com.brandon3055.projectintelligence.utils.LogHelper;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.io.IOUtils;

public class StyleHandler {
    public static boolean unsavedChanges = false;
    private static String highlight = "";
    private static File styleCfgFolder;
    private static File defaultPresetsFolder;
    private static File customPresetsFolder;
    private static File activeStyle;
    private static Map<String, StyleProperty> fullPropertyMap;
    private static Map<String, StyleProperty> rootPropertyMap;
    private static List<Runnable> reloadListeners;

    public static void reloadStyleProperties() {
        fullPropertyMap.clear();
        rootPropertyMap.clear();
        StyleProperty menu = StyleHandler.addProperty(new StyleProperty(StyleType.MENU));
        menu.addSubProp(new BooleanProperty(StyleType.VANILLA_TEXTURE, true));
        menu.addSubProp(new BooleanProperty(StyleType.SHADED_BORDERS, true).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.shade_borders.info", (Object[])new Object[0]))).addSubProp(new BooleanProperty(StyleType.INVERT_SHADE, false).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.invert_shade.info", (Object[])new Object[0])));
        menu.addSubProp(new BooleanProperty(StyleType.THICK_BORDERS, true));
        menu.addSubProp(new ColourProperty(StyleType.COLOUR, -1, true));
        menu.addSubProp(new ColourProperty(StyleType.BORDER, 0, true));
        menu.addSubProp(new ColourProperty(StyleType.TEXT_COLOUR, 0x404040, false));
        menu.addSubProp(new BooleanProperty(StyleType.TEXT_SHADOW, false));
        StyleProperty closeButton = menu.addSubProp(new StyleProperty(StyleType.CLOSE_BUTTON));
        closeButton.addSubProp(new ColourProperty(StyleType.COLOUR, 0xB0B0B0, false));
        closeButton.addSubProp(new ColourProperty(StyleType.HOVER, 0xFF3030, false));
        StyleProperty sizeButtons = menu.addSubProp(new StyleProperty(StyleType.SIZE_BUTTONS));
        sizeButtons.addSubProp(new ColourProperty(StyleType.COLOUR, 0xB0B0B0, false));
        sizeButtons.addSubProp(new ColourProperty(StyleType.HOVER, 0xC0C0C0, false));
        StyleProperty settingsButton = menu.addSubProp(new StyleProperty(StyleType.SETTINGS_BUTTON));
        settingsButton.addSubProp(new ColourProperty(StyleType.COLOUR, 0xFFFFFF, false));
        settingsButton.addSubProp(new ColourProperty(StyleType.HOVER, 0xC0C0C0, false));
        StyleProperty pageList = StyleHandler.addProperty(new StyleProperty(StyleType.PAGE_LIST));
        StyleProperty toggleHidden = pageList.addSubProp(new StyleProperty(StyleType.HIDE_BUTTON));
        toggleHidden.addSubProp(new ColourProperty(StyleType.COLOUR, 0xFFFFFF, false));
        toggleHidden.addSubProp(new ColourProperty(StyleType.HOVER, 0xFFFFA0, false));
        StyleProperty header = pageList.addSubProp(new StyleProperty(StyleType.HEADER));
        header.addSubProp(new BooleanProperty(StyleType.VANILLA_TEXTURE, true));
        header.addSubProp(new BooleanProperty(StyleType.SHADED_BORDERS, true).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.shade_borders.info", (Object[])new Object[0]))).addSubProp(new BooleanProperty(StyleType.INVERT_SHADE, false).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.invert_shade.info", (Object[])new Object[0])));
        header.addSubProp(new BooleanProperty(StyleType.THICK_BORDERS, false));
        header.addSubProp(new ColourProperty(StyleType.COLOUR, -6250336, true));
        header.addSubProp(new ColourProperty(StyleType.BORDER, 0, true));
        header.addSubProp(new ColourProperty(StyleType.TEXT_COLOUR, 0x404040, false));
        StyleProperty dirPath = pageList.addSubProp(new StyleProperty(StyleType.DIR_PATH));
        dirPath.addSubProp(new ColourProperty(StyleType.COLOUR, -3750202, true));
        dirPath.addSubProp(new ColourProperty(StyleType.BORDER, -16777216, true));
        dirPath.addSubProp(new BooleanProperty(StyleType.SHADED_BORDERS, false).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.shade_borders.info", (Object[])new Object[0]))).addSubProp(new BooleanProperty(StyleType.INVERT_SHADE, true).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.invert_shade.info", (Object[])new Object[0])));
        StyleProperty dirButtons = dirPath.addSubProp(new StyleProperty(StyleType.DIR_BUTTONS));
        dirButtons.addSubProp(new ColourProperty(StyleType.COLOUR, -8684677, true));
        dirButtons.addSubProp(new ColourProperty(StyleType.HOVER, -7631928, true));
        dirButtons.addSubProp(new ColourProperty(StyleType.BORDER, -8684677, true));
        dirButtons.addSubProp(new ColourProperty(StyleType.BORDER_HOVER, -7631928, true));
        dirButtons.addSubProp(new BooleanProperty(StyleType.SHADED_BORDERS, true).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.shade_borders.info", (Object[])new Object[0]))).addSubProp(new BooleanProperty(StyleType.INVERT_SHADE, false).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.invert_shade.info", (Object[])new Object[0])));
        dirButtons.addSubProp(new ColourProperty(StyleType.TEXT_COLOUR, 0, false));
        dirButtons.addSubProp(new ColourProperty(StyleType.TEXT_HOVER, 0, false));
        StyleProperty body = pageList.addSubProp(new StyleProperty(StyleType.BODY));
        body.addSubProp(new BooleanProperty(StyleType.VANILLA_TEXTURE, true));
        body.addSubProp(new BooleanProperty(StyleType.SHADED_BORDERS, true).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.shade_borders.info", (Object[])new Object[0]))).addSubProp(new BooleanProperty(StyleType.INVERT_SHADE, false).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.invert_shade.info", (Object[])new Object[0])));
        body.addSubProp(new ColourProperty(StyleType.COLOUR, -1, true));
        body.addSubProp(new ColourProperty(StyleType.BORDER, 0, true));
        body.addSubProp(new ColourProperty(StyleType.TEXT_COLOUR, 0x404040, false));
        StyleProperty footer = pageList.addSubProp(new StyleProperty(StyleType.FOOTER));
        footer.addSubProp(new BooleanProperty(StyleType.VANILLA_TEXTURE, true));
        footer.addSubProp(new BooleanProperty(StyleType.SHADED_BORDERS, true).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.shade_borders.info", (Object[])new Object[0]))).addSubProp(new BooleanProperty(StyleType.INVERT_SHADE, false).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.invert_shade.info", (Object[])new Object[0])));
        footer.addSubProp(new ColourProperty(StyleType.COLOUR, -1, true));
        footer.addSubProp(new ColourProperty(StyleType.BORDER, 0, true));
        StyleProperty search = pageList.addSubProp(new StyleProperty(StyleType.SEARCH));
        search.addSubProp(new ColourProperty(StyleType.TEXT_COLOUR, 0xFFFFFF, false));
        search.addSubProp(new ColourProperty(StyleType.COLOUR, -16777216, true));
        search.addSubProp(new ColourProperty(StyleType.BORDER, -10461088, true));
        StyleProperty searchSettings = search.addSubProp(new StyleProperty(StyleType.SETTINGS_BUTTON));
        searchSettings.addSubProp(new ColourProperty(StyleType.COLOUR, -6250336, false));
        searchSettings.addSubProp(new ColourProperty(StyleType.HOVER, -4144960, false));
        StyleProperty pageButtons = pageList.addSubProp(new StyleProperty(StyleType.PAGE_BUTTONS));
        pageButtons.addSubProp(new BooleanProperty(StyleType.VANILLA_TEXTURE, true));
        pageButtons.addSubProp(new BooleanProperty(StyleType.SHADED_BORDERS, true).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.shade_borders.info", (Object[])new Object[0]))).addSubProp(new BooleanProperty(StyleType.INVERT_SHADE, false).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.invert_shade.info", (Object[])new Object[0])));
        pageButtons.addSubProp(new BooleanProperty(StyleType.THICK_BORDERS, false));
        pageButtons.addSubProp(new ColourProperty(StyleType.COLOUR, -1, true));
        pageButtons.addSubProp(new ColourProperty(StyleType.HOVER, -1, true));
        pageButtons.addSubProp(new ColourProperty(StyleType.BORDER, 0, true));
        pageButtons.addSubProp(new ColourProperty(StyleType.BORDER_HOVER, 0, true));
        pageButtons.addSubProp(new ColourProperty(StyleType.TEXT_COLOUR, 0xE0E0E0, false));
        pageButtons.addSubProp(new ColourProperty(StyleType.TEXT_HOVER, 0xFFFFA0, false));
        pageButtons.addSubProp(new BooleanProperty(StyleType.TEXT_SHADOW, true));
        StyleProperty pageBackButton = pageButtons.addSubProp(new StyleProperty(StyleType.PAGE_BACK_BUTTON));
        pageBackButton.addSubProp(new BooleanProperty(StyleType.VANILLA_TEXTURE, true));
        pageBackButton.addSubProp(new BooleanProperty(StyleType.SHADED_BORDERS, true).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.shade_borders.info", (Object[])new Object[0]))).addSubProp(new BooleanProperty(StyleType.INVERT_SHADE, false).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.invert_shade.info", (Object[])new Object[0])));
        pageBackButton.addSubProp(new BooleanProperty(StyleType.THICK_BORDERS, false));
        pageBackButton.addSubProp(new ColourProperty(StyleType.COLOUR, -1, true));
        pageBackButton.addSubProp(new ColourProperty(StyleType.HOVER, -1, true));
        pageBackButton.addSubProp(new ColourProperty(StyleType.BORDER, 0, true));
        pageBackButton.addSubProp(new ColourProperty(StyleType.BORDER_HOVER, 0, true));
        pageBackButton.addSubProp(new ColourProperty(StyleType.TEXT_COLOUR, 0xE0E0E0, false));
        pageBackButton.addSubProp(new ColourProperty(StyleType.TEXT_HOVER, 0xFFFFA0, false));
        pageBackButton.addSubProp(new BooleanProperty(StyleType.TEXT_SHADOW, true));
        StyleProperty pageBackButtonIcon = pageBackButton.addSubProp(new StyleProperty(StyleType.ICON));
        pageBackButtonIcon.addSubProp(new ColourProperty(StyleType.COLOUR, 0xFFFFFF, false));
        pageBackButtonIcon.addSubProp(new ColourProperty(StyleType.HOVER, 0xFFFFA0, false));
        StyleHandler.createScrollBarProp(pageList);
        StyleProperty mdWindow = StyleHandler.addProperty(new StyleProperty(StyleType.MD_WINDOW));
        header = mdWindow.addSubProp(new StyleProperty(StyleType.HEADER));
        header.addSubProp(new BooleanProperty(StyleType.VANILLA_TEXTURE, true));
        header.addSubProp(new BooleanProperty(StyleType.SHADED_BORDERS, true).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.shade_borders.info", (Object[])new Object[0]))).addSubProp(new BooleanProperty(StyleType.INVERT_SHADE, false).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.invert_shade.info", (Object[])new Object[0])));
        header.addSubProp(new BooleanProperty(StyleType.THICK_BORDERS, false));
        header.addSubProp(new ColourProperty(StyleType.COLOUR, -6250336, true));
        header.addSubProp(new ColourProperty(StyleType.BORDER, 0, true));
        header.addSubProp(new ColourProperty(StyleType.TEXT_COLOUR, 0, false));
        body = mdWindow.addSubProp(new StyleProperty(StyleType.BODY));
        body.addSubProp(new BooleanProperty(StyleType.VANILLA_TEXTURE, true));
        body.addSubProp(new BooleanProperty(StyleType.SHADED_BORDERS, true).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.shade_borders.info", (Object[])new Object[0]))).addSubProp(new BooleanProperty(StyleType.INVERT_SHADE, false).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.invert_shade.info", (Object[])new Object[0])));
        body.addSubProp(new BooleanProperty(StyleType.THICK_BORDERS, false));
        body.addSubProp(new ColourProperty(StyleType.COLOUR, -1, true));
        body.addSubProp(new ColourProperty(StyleType.BORDER, -16777216, true));
        body.addSubProp(new ColourProperty(StyleType.TEXT_COLOUR, 0, false));
        StyleHandler.createScrollBarProp(mdWindow);
        StyleProperty dialogs = StyleHandler.addProperty(new StyleProperty(StyleType.USER_DIALOGS));
        dialogs.addSubProp(new BooleanProperty(StyleType.VANILLA_TEXTURE, true));
        dialogs.addSubProp(new BooleanProperty(StyleType.THICK_BORDERS, false));
        dialogs.addSubProp(new ColourProperty(StyleType.COLOUR, -1, true));
        dialogs.addSubProp(new ColourProperty(StyleType.BORDER, 0, true));
        dialogs.addSubProp(new ColourProperty(StyleType.TEXT_COLOUR, 0x404040, false));
        StyleProperty editorButtons = dialogs.addSubProp(new StyleProperty(StyleType.BUTTON_STYLE));
        editorButtons.addSubProp(new BooleanProperty(StyleType.VANILLA_TEXTURE, true));
        editorButtons.addSubProp(new ColourProperty(StyleType.COLOUR, -1, true));
        editorButtons.addSubProp(new ColourProperty(StyleType.HOVER, -1, true));
        editorButtons.addSubProp(new ColourProperty(StyleType.BORDER, 0, true));
        editorButtons.addSubProp(new ColourProperty(StyleType.BORDER_HOVER, -16777216, true));
        editorButtons.addSubProp(new ColourProperty(StyleType.TEXT_COLOUR, 0xE0E0E0, false));
        editorButtons.addSubProp(new ColourProperty(StyleType.TEXT_HOVER, 0xFFFFA0, false));
        StyleProperty subElements = dialogs.addSubProp(new StyleProperty(StyleType.SUB_ELEMENTS));
        subElements.setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.sub_elements.info", (Object[])new Object[0]));
        subElements.addSubProp(new ColourProperty(StyleType.COLOUR, -6250336, true));
        subElements.addSubProp(new ColourProperty(StyleType.BORDER, 0, true));
        StyleProperty presetButtons = subElements.addSubProp(new StyleProperty(StyleType.BUTTON_STYLE));
        presetButtons.addSubProp(new BooleanProperty(StyleType.VANILLA_TEXTURE, true));
        presetButtons.addSubProp(new ColourProperty(StyleType.COLOUR, -1, true));
        presetButtons.addSubProp(new ColourProperty(StyleType.HOVER, -1, true));
        presetButtons.addSubProp(new ColourProperty(StyleType.BORDER, 0, true));
        presetButtons.addSubProp(new ColourProperty(StyleType.BORDER_HOVER, 0, true));
        presetButtons.addSubProp(new ColourProperty(StyleType.TEXT_COLOUR, 0xE0E0E0, false));
        presetButtons.addSubProp(new ColourProperty(StyleType.TEXT_HOVER, 0xFFFFA0, false));
        StyleProperty guiDoc = StyleHandler.addProperty(new StyleProperty(StyleType.GUI_DOCS).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.gui_docs.info", (Object[])new Object[0])));
        guiDoc.addSubProp(new BooleanProperty(StyleType.VANILLA_TEXTURE, true));
        guiDoc.addSubProp(new BooleanProperty(StyleType.SHADED_BORDERS, true).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.shade_borders.info", (Object[])new Object[0]))).addSubProp(new BooleanProperty(StyleType.INVERT_SHADE, false).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.invert_shade.info", (Object[])new Object[0])));
        guiDoc.addSubProp(new BooleanProperty(StyleType.THICK_BORDERS, false));
        guiDoc.addSubProp(new ColourProperty(StyleType.COLOUR, -1, true));
        guiDoc.addSubProp(new ColourProperty(StyleType.BORDER, 0, true));
        guiDoc.addSubProp(new ColourProperty(StyleType.TEXT_COLOUR, 0, false));
        settingsButton = guiDoc.addSubProp(new StyleProperty(StyleType.SETTINGS_BUTTON));
        settingsButton.addSubProp(new ColourProperty(StyleType.COLOUR, 0xFFFFFF, false));
        settingsButton.addSubProp(new ColourProperty(StyleType.HOVER, 0xC0C0C0, false));
        closeButton = guiDoc.addSubProp(new StyleProperty(StyleType.CLOSE_BUTTON));
        closeButton.addSubProp(new ColourProperty(StyleType.COLOUR, 0xFFFFFF, false));
        closeButton.addSubProp(new ColourProperty(StyleType.HOVER, 0xFF3030, false));
        header = guiDoc.addSubProp(new StyleProperty(StyleType.HEADER));
        header.addSubProp(new ColourProperty(StyleType.TEXT_COLOUR, 0xE0E0E0, false));
        header.addSubProp(new ColourProperty(StyleType.TEXT_HOVER, 0xFFFFA0, false));
        header.addSubProp(new ColourProperty(StyleType.BACKGROUND, 0x40000000, true));
        StyleHandler.createScrollBarProp(guiDoc);
        reloadListeners.forEach(Runnable::run);
    }

    private static StyleProperty addProperty(StyleProperty property) {
        fullPropertyMap.put(property.path, property);
        rootPropertyMap.put(property.path, property);
        return property;
    }

    public static Map<String, StyleProperty> getPropertyMap() {
        return ImmutableMap.copyOf(rootPropertyMap);
    }

    private static StyleProperty createScrollBarProp(StyleProperty parent) {
        StyleProperty scrollBar = parent.addSubProp(new StyleProperty(StyleType.SCROLL_BAR));
        scrollBar.addSubProp(new ColourProperty(StyleType.COLOUR, -7631989, true));
        scrollBar.addSubProp(new ColourProperty(StyleType.HOVER, -7631989, true));
        scrollBar.addSubProp(new ColourProperty(StyleType.BORDER, -7631989, true));
        scrollBar.addSubProp(new ColourProperty(StyleType.BORDER_HOVER, -7631989, true));
        scrollBar.addSubProp(new BooleanProperty(StyleType.SHADED_BORDERS, true).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.shade_borders.info", (Object[])new Object[0]))).addSubProp(new BooleanProperty(StyleType.INVERT_SHADE, true).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.invert_shade.info", (Object[])new Object[0])));
        StyleProperty scrollSlider = scrollBar.addSubProp(new StyleProperty(StyleType.SCROLL_SLIDER));
        scrollSlider.addSubProp(new ColourProperty(StyleType.COLOUR, -7631989, true));
        scrollSlider.addSubProp(new ColourProperty(StyleType.HOVER, -7631928, true));
        scrollSlider.addSubProp(new ColourProperty(StyleType.BORDER, -7631989, true));
        scrollSlider.addSubProp(new ColourProperty(StyleType.BORDER_HOVER, -7631928, true));
        scrollSlider.addSubProp(new BooleanProperty(StyleType.SHADED_BORDERS, true).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.shade_borders.info", (Object[])new Object[0]))).addSubProp(new BooleanProperty(StyleType.INVERT_SHADE, false).setTip(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.invert_shade.info", (Object[])new Object[0])));
        return scrollBar;
    }

    public static void setHighlight(String prop) {
        highlight = prop;
        reloadListeners.forEach(Runnable::run);
    }

    public static boolean getBoolean(String prop) {
        StyleProperty styleProperty = fullPropertyMap.get(prop);
        if (styleProperty != null && styleProperty.isBoolean()) {
            return ((BooleanProperty)styleProperty).get();
        }
        LogHelper.error("StyleHandler: Attempt to retrieve un-defined boolean: " + prop);
        return false;
    }

    public static void setBoolean(String prop, boolean value) {
        if (fullPropertyMap.containsKey(prop) && fullPropertyMap.get(prop).isBoolean()) {
            ((BooleanProperty)fullPropertyMap.get(prop)).set(value);
            StyleHandler.saveStyle();
        }
        LogHelper.error("StyleHandler: Attempt to set un-defined boolean: " + prop);
    }

    public static int getInt(String prop) {
        StyleProperty styleProperty = fullPropertyMap.get(prop);
        if (styleProperty != null && styleProperty.isInteger()) {
            return ((IntegerProperty)styleProperty).get();
        }
        LogHelper.error("StyleHandler: Attempt to retrieve un-defined integer: " + prop);
        return 0;
    }

    public static void setInt(String prop, int value) {
        if (fullPropertyMap.containsKey(prop) && fullPropertyMap.get(prop).isInteger()) {
            ((IntegerProperty)fullPropertyMap.get(prop)).set(value);
            StyleHandler.saveStyle();
        }
        LogHelper.error("StyleHandler: Attempt to set un-defined integer: " + prop);
    }

    public static Colour getColour(String prop) {
        StyleProperty styleProperty = fullPropertyMap.get(prop);
        if (styleProperty != null && styleProperty.isColour()) {
            return ((ColourProperty)styleProperty).getColour();
        }
        LogHelper.error("StyleHandler: Attempt to retrieve un-defined colour: " + prop);
        return new ColourARGB(0);
    }

    public static void setColour(String prop, Colour colour) {
        if (fullPropertyMap.containsKey(prop) && fullPropertyMap.get(prop).isColour()) {
            ((ColourProperty)fullPropertyMap.get(prop)).set(colour);
            StyleHandler.saveStyle();
        }
        LogHelper.error("StyleHandler: Attempt to set un-defined colour: " + prop);
    }

    public static boolean hasProp(String prop) {
        return fullPropertyMap.containsKey(prop);
    }

    private static void addReloadListener(Runnable listener) {
        reloadListeners.add(listener);
    }

    public static BooleanProperty getBooleanProp(String prop) {
        StyleProperty styleProperty = fullPropertyMap.get(prop);
        if (styleProperty != null && styleProperty.isBoolean()) {
            return (BooleanProperty)styleProperty;
        }
        LogHelper.error("StyleHandler: Attempt to retrieve un-defined boolean: " + prop);
        return new BooleanProperty(StyleType.BACKGROUND, false);
    }

    public static IntegerProperty getIntProp(String prop) {
        StyleProperty styleProperty = fullPropertyMap.get(prop);
        if (styleProperty != null && styleProperty.isInteger()) {
            return (IntegerProperty)styleProperty;
        }
        LogHelper.error("StyleHandler: Attempt to retrieve un-defined integer: " + prop);
        return new IntegerProperty(StyleType.BACKGROUND, 0);
    }

    public static ColourProperty getColourProp(String prop) {
        StyleProperty styleProperty = fullPropertyMap.get(prop);
        if (styleProperty != null && styleProperty.isColour()) {
            return (ColourProperty)styleProperty;
        }
        LogHelper.error("StyleHandler: Attempt to retrieve un-defined colour: " + prop);
        return new ColourProperty(StyleType.BACKGROUND, 0, true);
    }

    private static int getHighlightColour(int colour, boolean alpha) {
        ColourARGB in = new ColourARGB(colour);
        ColourARGB out = new ColourARGB(-16711936);
        double d = (Math.sin((double)ClientEventHandler.elapsedTicks / 10.0) + 1.0) / 2.0;
        double r = (double)(in.r & 0xFF) * d + (double)(out.r & 0xFF) * (1.0 - d);
        double g = (double)(in.g & 0xFF) * d + (double)(out.g & 0xFF) * (1.0 - d);
        double b = (double)(in.b & 0xFF) * d + (double)(out.b & 0xFF) * (1.0 - d);
        double a = alpha ? (double)(in.a & 0xFF) * d + (double)(out.a & 0xFF) * (1.0 - d) : 255.0;
        return ((int)a & 0xFF) << 24 | ((int)r & 0xFF) << 16 | ((int)g & 0xFF) << 8 | (int)b & 0xFF;
    }

    public static void initialize() {
        styleCfgFolder = new File(FileHandler.brandon3055Folder, "ProjectIntelligence/GuiStyle");
        if (!styleCfgFolder.exists() && !styleCfgFolder.mkdirs()) {
            PIGuiHelper.displayError("Failed to create GuiStyle folder! Gui styles will be broken! " + styleCfgFolder);
            LogHelper.error("Failed to create GuiStyle folder! Gui styles will be broken! " + styleCfgFolder);
            return;
        }
        defaultPresetsFolder = new File(styleCfgFolder, "DefaultPresets");
        if (!defaultPresetsFolder.exists() && !defaultPresetsFolder.mkdirs()) {
            PIGuiHelper.displayError("Failed to create GuiStyle folder! Gui styles will be broken! " + styleCfgFolder);
            LogHelper.error("Failed to create GuiStyle folder! Gui styles will be broken! " + styleCfgFolder);
            return;
        }
        customPresetsFolder = new File(styleCfgFolder, "CustomPresets");
        if (!customPresetsFolder.exists() && !customPresetsFolder.mkdirs()) {
            PIGuiHelper.displayError("Failed to create GuiStyle folder! Gui styles will be broken! " + styleCfgFolder);
            LogHelper.error("Failed to create GuiStyle folder! Gui styles will be broken! " + styleCfgFolder);
            return;
        }
        activeStyle = new File(styleCfgFolder, "ActiveStyle.json");
        if (!activeStyle.exists()) {
            StyleHandler.saveStyle();
        } else {
            StyleHandler.loadStyle();
        }
    }

    public static void loadStyle() {
        try {
            JsonParser parser = new JsonParser();
            FileReader reader = new FileReader(activeStyle);
            JsonElement element = parser.parse((Reader)reader);
            IOUtils.closeQuietly((Reader)reader);
            if (!element.isJsonObject()) {
                PIGuiHelper.displayError("Failed to load gui style. Detected invalid style config.");
                return;
            }
            JsonObject jObj = element.getAsJsonObject();
            unsavedChanges = JsonUtils.func_151209_a((JsonObject)jObj, (String)"unsavedChanges", (boolean)false);
            rootPropertyMap.forEach((s, property) -> property.load(jObj));
        }
        catch (Exception e) {
            PIGuiHelper.displayError("Error loading gui style: " + e.getMessage());
            LogHelper.error("Error loading gui style");
            e.printStackTrace();
        }
    }

    public static void saveStyle() {
        try {
            JsonObject jObj = new JsonObject();
            jObj.addProperty("unsavedChanges", Boolean.valueOf(unsavedChanges));
            rootPropertyMap.forEach((s, property) -> property.save(jObj));
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(activeStyle));
            writer.setIndent("  ");
            Streams.write((JsonElement)jObj, (JsonWriter)writer);
            writer.flush();
            IOUtils.closeQuietly((Closeable)writer);
        }
        catch (Exception e) {
            PIGuiHelper.displayError("Error saving gui style: " + e.getMessage());
            LogHelper.error("Error saving gui style");
            e.printStackTrace();
        }
    }

    public static List<String> getDefaultPresets() {
        LinkedList<String> list = new LinkedList<String>();
        File[] files = defaultPresetsFolder.listFiles((dir, name) -> name.endsWith(".json"));
        if (files != null) {
            for (File file : files) {
                list.add(file.getName().substring(0, file.getName().indexOf(".json")));
            }
        }
        return list;
    }

    public static List<String> getCustomPresets() {
        LinkedList<String> list = new LinkedList<String>();
        File[] files = customPresetsFolder.listFiles((dir, name) -> name.endsWith(".json"));
        if (files != null) {
            for (File file : files) {
                list.add(file.getName().substring(0, file.getName().indexOf(".json")));
            }
        }
        return list;
    }

    public static void loadPreset(String name, boolean isCustom) {
        File preset = new File(isCustom ? customPresetsFolder : defaultPresetsFolder, name + ".json");
        try {
            JsonParser parser = new JsonParser();
            FileReader reader = new FileReader(preset);
            JsonElement element = parser.parse((Reader)reader);
            IOUtils.closeQuietly((Reader)reader);
            if (!element.isJsonObject()) {
                PIGuiHelper.displayError("Failed to load gui style. Detected invalid style config.");
                return;
            }
            JsonObject jObj = element.getAsJsonObject();
            rootPropertyMap.forEach((s, property) -> property.load(jObj));
            unsavedChanges = false;
            StyleHandler.saveStyle();
        }
        catch (Exception e) {
            PIGuiHelper.displayError("Something went wrong while attempting to load the custom preset: " + e.getMessage());
            LogHelper.error("Something went wrong while attempting to load the custom preset");
            e.printStackTrace();
        }
    }

    public static void savePreset(String name) {
        File preset = new File(customPresetsFolder, name + ".json");
        try {
            JsonObject jObj = new JsonObject();
            rootPropertyMap.forEach((s, property) -> property.save(jObj));
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(preset));
            writer.setIndent("  ");
            Streams.write((JsonElement)jObj, (JsonWriter)writer);
            writer.flush();
            IOUtils.closeQuietly((Closeable)writer);
            unsavedChanges = false;
            StyleHandler.saveStyle();
        }
        catch (Exception e) {
            PIGuiHelper.displayError("Something went wrong while attempting to save the custom preset: " + e.getMessage());
            LogHelper.error("Something went wrong while attempting to save the custom preset");
            e.printStackTrace();
        }
    }

    public static void deletePreset(String name) {
        File preset = new File(customPresetsFolder, name + ".json");
        if (preset.exists()) {
            preset.delete();
        }
    }

    static {
        fullPropertyMap = new LinkedHashMap<String, StyleProperty>();
        rootPropertyMap = new LinkedHashMap<String, StyleProperty>();
        reloadListeners = new ArrayList<Runnable>();
        StyleHandler.reloadStyleProperties();
    }

    public static enum StyleType {
        MENU("menu"),
        CLOSE_BUTTON("close_button"),
        SIZE_BUTTONS("size_buttons"),
        SETTINGS_BUTTON("settings_button"),
        USER_DIALOGS("user_dialogs"),
        SUB_ELEMENTS("sub_elements"),
        PAGE_LIST("page_list"),
        PAGE_ICON("page_icon"),
        PAGE_BUTTONS("page_buttons"),
        PAGE_BACK_BUTTON("page_back_button"),
        HIDE_BUTTON("hide_button"),
        DIR_PATH("dir_path"),
        DIR_BUTTONS("dir_buttons"),
        MD_WINDOW("md_window"),
        GUI_DOCS("gui_docs"),
        COLOUR("colour"),
        HOVER("hover"),
        BACKGROUND("background"),
        BACKGROUND_HOVER("background_hover"),
        BORDER("border"),
        BORDER_HOVER("border_hover"),
        VANILLA_TEXTURE("vanilla_tex"),
        THICK_BORDERS("thick_borders"),
        SHADED_BORDERS("shaded_borders"),
        INVERT_SHADE("invert_shade"),
        BUTTON_STYLE("button_style"),
        TEXT_COLOUR("text_colour"),
        TEXT_HOVER("text_hover"),
        TEXT_SHADOW("text_shadow"),
        HEADER("header"),
        BODY("body"),
        FOOTER("footer"),
        SEARCH("search"),
        SCROLL_BAR("scroll_bar"),
        SCROLL_SLIDER("scroll_slider"),
        COMPACT_BAR("small_bar"),
        ICON("icon");

        private String name;

        private StyleType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String ext() {
            return "." + this.name;
        }

        public String pre() {
            return this.name + ".";
        }
    }

    public static class PropertyGroup {
        private String baseProp;
        private ColourProperty colour = null;
        private ColourProperty hover = null;
        private ColourProperty background = null;
        private ColourProperty backgroundHover = null;
        private ColourProperty border = null;
        private ColourProperty borderHover = null;
        private ColourProperty textColour = null;
        private ColourProperty textColourHover = null;
        private BooleanProperty vanillaTex = null;
        private BooleanProperty thickBorders = null;
        private BooleanProperty shadeBorders = null;
        private BooleanProperty invertShade = null;
        private BooleanProperty textShadow = null;
        private BooleanProperty compact = null;

        public PropertyGroup(String baseProp) {
            this.baseProp = baseProp;
            StyleHandler.addReloadListener(this::updateProps);
            this.updateProps();
        }

        public void updateProps() {
            this.colour = StyleHandler.hasProp(this.baseProp + StyleType.COLOUR.ext()) ? StyleHandler.getColourProp(this.baseProp + StyleType.COLOUR.ext()) : null;
            this.hover = StyleHandler.hasProp(this.baseProp + StyleType.HOVER.ext()) ? StyleHandler.getColourProp(this.baseProp + StyleType.HOVER.ext()) : null;
            this.background = StyleHandler.hasProp(this.baseProp + StyleType.BACKGROUND.ext()) ? StyleHandler.getColourProp(this.baseProp + StyleType.BACKGROUND.ext()) : null;
            this.backgroundHover = StyleHandler.hasProp(this.baseProp + StyleType.BACKGROUND_HOVER.ext()) ? StyleHandler.getColourProp(this.baseProp + StyleType.BACKGROUND_HOVER.ext()) : null;
            this.border = StyleHandler.hasProp(this.baseProp + StyleType.BORDER.ext()) ? StyleHandler.getColourProp(this.baseProp + StyleType.BORDER.ext()) : null;
            this.borderHover = StyleHandler.hasProp(this.baseProp + StyleType.BORDER_HOVER.ext()) ? StyleHandler.getColourProp(this.baseProp + StyleType.BORDER_HOVER.ext()) : null;
            this.textColour = StyleHandler.hasProp(this.baseProp + StyleType.TEXT_COLOUR.ext()) ? StyleHandler.getColourProp(this.baseProp + StyleType.TEXT_COLOUR.ext()) : null;
            this.textColourHover = StyleHandler.hasProp(this.baseProp + StyleType.TEXT_HOVER.ext()) ? StyleHandler.getColourProp(this.baseProp + StyleType.TEXT_HOVER.ext()) : null;
            this.vanillaTex = StyleHandler.hasProp(this.baseProp + StyleType.VANILLA_TEXTURE.ext()) ? StyleHandler.getBooleanProp(this.baseProp + StyleType.VANILLA_TEXTURE.ext()) : null;
            this.thickBorders = StyleHandler.hasProp(this.baseProp + StyleType.THICK_BORDERS.ext()) ? StyleHandler.getBooleanProp(this.baseProp + StyleType.THICK_BORDERS.ext()) : null;
            this.shadeBorders = StyleHandler.hasProp(this.baseProp + StyleType.SHADED_BORDERS.ext()) ? StyleHandler.getBooleanProp(this.baseProp + StyleType.SHADED_BORDERS.ext()) : null;
            this.invertShade = StyleHandler.hasProp(this.baseProp + StyleType.SHADED_BORDERS.ext() + StyleType.INVERT_SHADE.ext()) ? StyleHandler.getBooleanProp(this.baseProp + StyleType.SHADED_BORDERS.ext() + StyleType.INVERT_SHADE.ext()) : null;
            this.textShadow = StyleHandler.hasProp(this.baseProp + StyleType.TEXT_SHADOW.ext()) ? StyleHandler.getBooleanProp(this.baseProp + StyleType.TEXT_SHADOW.ext()) : null;
            this.compact = StyleHandler.hasProp(this.baseProp + StyleType.COMPACT_BAR.ext()) ? StyleHandler.getBooleanProp(this.baseProp + StyleType.COMPACT_BAR.ext()) : null;
        }

        public int colour() {
            if (this.colour == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined colour prop for " + this.baseProp);
                return 0;
            }
            return this.colour.get();
        }

        public boolean hasPropColour() {
            return this.colour != null;
        }

        public int colourHover() {
            if (this.hover == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined hover prop for " + this.baseProp);
                return 0;
            }
            return this.hover.get();
        }

        public boolean hasPropColourHover() {
            return this.hover != null;
        }

        public int colour(boolean hover) {
            return hover ? this.colourHover() : this.colour();
        }

        public void glColour() {
            if (this.colour == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined colour prop for " + this.baseProp);
            } else {
                this.colour.getColour().glColour();
            }
        }

        public void glColourHover() {
            if (this.hover == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined hover prop for " + this.baseProp);
            } else {
                this.hover.getColour().glColour();
            }
        }

        public void glColour(boolean hover) {
            if (hover) {
                this.glColourHover();
            } else {
                this.glColour();
            }
        }

        public int background() {
            if (this.background == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined background prop for " + this.baseProp);
                return 0;
            }
            return this.background.get();
        }

        public int backgroundHover() {
            if (this.backgroundHover == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined bgckgroundHover prop for " + this.baseProp);
                return 0;
            }
            return this.backgroundHover.get();
        }

        public int background(boolean hover) {
            return hover ? this.backgroundHover() : this.background();
        }

        public void glBackground() {
            if (this.background == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined background prop for " + this.baseProp);
            } else {
                this.background.getColour().glColour();
            }
        }

        public void glBackgroundHover() {
            if (this.backgroundHover == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined bgckgroundHover prop for " + this.baseProp);
            } else {
                this.backgroundHover.getColour().glColour();
            }
        }

        public void glBackground(boolean hover) {
            if (hover) {
                this.glBackgroundHover();
            } else {
                this.glBackground();
            }
        }

        public int border() {
            if (this.border == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined border prop for " + this.baseProp);
                return 0;
            }
            return this.border.get();
        }

        public boolean hasPropBorder() {
            return this.border != null;
        }

        public int borderHover() {
            if (this.borderHover == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined boderHover prop for " + this.baseProp);
                return 0;
            }
            return this.borderHover.get();
        }

        public boolean hasPropBorderHover() {
            return this.borderHover != null;
        }

        public int border(boolean hover) {
            return hover ? this.borderHover() : this.border();
        }

        public void glBorder() {
            if (this.border == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined border prop for " + this.baseProp);
            } else {
                this.border.getColour().glColour();
            }
        }

        public void glBorderHover() {
            if (this.borderHover == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined boderHover prop for " + this.baseProp);
            } else {
                this.borderHover.getColour().glColour();
            }
        }

        public void glBorder(boolean hover) {
            if (hover) {
                this.glBorderHover();
            } else {
                this.glBorder();
            }
        }

        public int textColour() {
            if (this.textColour == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined textColour prop for " + this.baseProp);
                return 0;
            }
            return this.textColour.get();
        }

        public int textColourHover() {
            if (this.textColourHover == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined textColourHover prop for " + this.baseProp);
                return 0;
            }
            return this.textColourHover.get();
        }

        public int textColour(boolean hover) {
            return hover ? this.textColourHover() : this.textColour();
        }

        public boolean hasPropTextColour() {
            return this.textColour != null;
        }

        public boolean hasPropTextColourHover() {
            return this.textColourHover != null;
        }

        public void glTextColour() {
            if (this.textColour == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined textColour prop for " + this.baseProp);
            } else {
                this.textColour.getColour().glColour();
            }
        }

        public void glTextColourHover() {
            if (this.textColourHover == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined textColourHover prop for " + this.baseProp);
            } else {
                this.textColourHover.getColour().glColour();
            }
        }

        public void glTextColour(boolean hover) {
            if (hover) {
                this.glTextColourHover();
            } else {
                this.glTextColour();
            }
        }

        public boolean vanillaTex() {
            if (this.vanillaTex == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined vanillaTex prop for " + this.baseProp);
                return false;
            }
            return this.vanillaTex.get();
        }

        public boolean hasPropVanillaTex() {
            return this.vanillaTex != null;
        }

        public boolean thickBorders() {
            if (this.thickBorders == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined thickBorders prop for " + this.baseProp);
                return false;
            }
            return this.thickBorders.get();
        }

        public boolean hasPropThickBorders() {
            return this.thickBorders != null;
        }

        public boolean shadeBorders() {
            if (this.shadeBorders == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined shadeBorders prop for " + this.baseProp);
                return false;
            }
            return this.shadeBorders.get();
        }

        public boolean hasPropShadeBorders() {
            return this.shadeBorders != null;
        }

        public boolean invertShade() {
            if (this.invertShade == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined shadeBorders prop for " + this.baseProp);
                return false;
            }
            return this.invertShade.get();
        }

        public boolean hasPropInvertShade() {
            return this.invertShade != null;
        }

        public boolean textShadow() {
            if (this.textShadow == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined textShadow prop for " + this.baseProp);
                return false;
            }
            return this.textShadow.get();
        }

        public boolean compact() {
            if (this.compact == null) {
                LogHelper.error("StyleHandler: Attempt to retrieve un-defined compact prop for " + this.baseProp);
                return false;
            }
            return this.compact.get();
        }
    }

    public static class ColourProperty
    extends IntegerProperty {
        private Colour colour;
        public final boolean alpha;

        private ColourProperty(StyleType type, int defaultValue, boolean alpha) {
            super(type, defaultValue);
            this.alpha = alpha;
            this.colour = new ColourARGB(alpha ? this.value : 0xFF000000 | this.value);
        }

        @Override
        public void load(JsonObject jObj) {
            super.load(jObj);
            this.colour = new ColourARGB(this.alpha ? this.value : 0xFF000000 | this.value);
        }

        public Colour getColour() {
            if (!highlight.isEmpty() && this.path.startsWith(highlight)) {
                return new ColourARGB(StyleHandler.getHighlightColour(this.colour.argb(), this.alpha));
            }
            return this.colour;
        }

        @Override
        public int get() {
            int argb;
            int n = argb = this.alpha ? this.colour.argb() : this.colour.rgb();
            if (!highlight.isEmpty() && this.path.startsWith(highlight)) {
                return StyleHandler.getHighlightColour(argb, this.alpha);
            }
            return argb;
        }

        public void set(Colour colour) {
            this.colour = colour;
            this.set(this.alpha ? colour.argb() : colour.rgb());
        }

        @Override
        public void set(int value) {
            super.set(value);
            this.colour.set(this.alpha ? value : 0xFF000000 | value);
            unsavedChanges = true;
            StyleHandler.saveStyle();
        }
    }

    public static class IntegerProperty
    extends StyleProperty {
        protected int value;

        private IntegerProperty(StyleType type, int defaultValue) {
            super(type);
            this.value = defaultValue;
        }

        @Override
        public void save(JsonObject jObj) {
            jObj.addProperty(this.type.getName(), (Number)this.value);
            super.save(jObj);
        }

        @Override
        public void load(JsonObject jObj) {
            this.value = JsonUtils.func_151208_a((JsonObject)jObj, (String)this.type.getName(), (int)this.value);
            super.load(jObj);
        }

        public int get() {
            return this.value;
        }

        public void set(int value) {
            this.value = value;
            unsavedChanges = true;
            StyleHandler.saveStyle();
        }
    }

    public static class BooleanProperty
    extends StyleProperty {
        protected boolean value;

        private BooleanProperty(StyleType type, boolean defaultValue) {
            super(type);
            this.value = defaultValue;
        }

        @Override
        public void save(JsonObject jObj) {
            jObj.addProperty(this.type.getName(), Boolean.valueOf(this.value));
            super.save(jObj);
        }

        @Override
        public void load(JsonObject jObj) {
            this.value = JsonUtils.func_151209_a((JsonObject)jObj, (String)this.type.getName(), (boolean)this.value);
            super.load(jObj);
        }

        public boolean get() {
            return this.value;
        }

        public void set(boolean value) {
            this.value = value;
            unsavedChanges = true;
            StyleHandler.saveStyle();
        }
    }

    public static class StyleProperty {
        public Map<String, StyleProperty> subProps = new LinkedHashMap<String, StyleProperty>();
        protected StyleType type;
        protected String path;
        public String tip = null;

        private StyleProperty(StyleType type) {
            this.type = type;
            this.path = type.getName();
        }

        public StyleProperty addSubProp(StyleProperty property) {
            property.path = this.path + "." + property.path;
            this.subProps.put(property.path, property);
            fullPropertyMap.put(property.path, property);
            return property;
        }

        public void save(JsonObject jObj) {
            if (!this.subProps.isEmpty()) {
                JsonObject subPropObj = new JsonObject();
                this.subProps.forEach((s, property) -> property.save(subPropObj));
                jObj.add(this.type.getName() + "_subs", (JsonElement)subPropObj);
            }
        }

        public void load(JsonObject jObj) {
            if (!this.subProps.isEmpty() && jObj.has(this.type.getName() + "_subs") && jObj.get(this.type.getName() + "_subs").isJsonObject()) {
                JsonObject subPropObj = jObj.get(this.type.getName() + "_subs").getAsJsonObject();
                this.subProps.forEach((s, property) -> property.load(subPropObj));
            }
        }

        public boolean isBoolean() {
            return this instanceof BooleanProperty;
        }

        public boolean isInteger() {
            return this instanceof IntegerProperty;
        }

        public boolean isColour() {
            return this instanceof ColourProperty;
        }

        public boolean canSet() {
            return this.isBoolean() || this.isInteger() || this.isColour();
        }

        public StyleType getType() {
            return this.type;
        }

        public String getPath() {
            return this.path;
        }

        public StyleProperty setTip(String tip) {
            this.tip = tip;
            return this;
        }
    }
}

