/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.utils;

import com.bafomdad.realfilingcabinet.ConfigRFC;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityFolder;
import com.bafomdad.realfilingcabinet.utils.FolderUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class MobUtils {
    public static boolean canPlayerChangeStuffHere(World world, EntityPlayer player, ItemStack stack, BlockPos pos, EnumFacing facing) {
        if (!world.func_175660_a(player, pos)) {
            return false;
        }
        return player.func_175151_a(pos, facing, stack);
    }

    public static boolean spawnEntityFromFolder(World world, EntityPlayer player, ItemStack stack, BlockPos pos, EnumFacing side) {
        EntityLivingBase entity;
        if (!MobUtils.canPlayerChangeStuffHere(world, player, stack, pos, side)) {
            return false;
        }
        CapabilityFolder cap = FolderUtils.get(stack).getCap();
        if (cap == null) {
            return false;
        }
        long count = cap.getCount();
        if (count > 0L && player.func_175151_a(pos.func_177972_a(side), side, stack) && (entity = cap.getEntity(world)) != null) {
            boolean spawn = false;
            if (!player.field_70170_p.field_72995_K) {
                EntityVillager entityliving;
                pos = pos.func_177972_a(side);
                if (entity instanceof EntityVillager && !ConfigRFC.randomVillager) {
                    entityliving = (EntityVillager)entity;
                    entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                    entityliving.field_70759_as = entityliving.field_70177_z;
                    entityliving.field_70761_aq = entityliving.field_70177_z;
                    entityliving.func_180482_a(world.func_175649_E(new BlockPos((Entity)entityliving)), (IEntityLivingData)null);
                    entityliving.func_70938_b(0);
                    world.func_72838_d((Entity)entity);
                    entityliving.func_70642_aH();
                    spawn = true;
                }
                if (entity instanceof EntitySlime) {
                    EntitySlime slime = (EntitySlime)entity;
                    slime.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                    NBTTagCompound tag = slime.getEntityData();
                    tag.func_74768_a("Size", 0);
                    slime.func_70014_b(tag);
                    slime.func_70606_j(1.0f);
                    world.func_72838_d((Entity)slime);
                    slime.func_70642_aH();
                    spawn = true;
                } else {
                    entityliving = (EntityLiving)entity;
                    entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                    entityliving.field_70759_as = entityliving.field_70177_z;
                    entityliving.field_70761_aq = entityliving.field_70177_z;
                    entityliving.func_180482_a(world.func_175649_E(new BlockPos((Entity)entityliving)), (IEntityLivingData)null);
                    world.func_72838_d((Entity)entity);
                    entityliving.func_70642_aH();
                    spawn = true;
                }
                if (spawn && !player.field_71075_bZ.field_75098_d) {
                    cap.setCount(count - 1L);
                }
            }
        }
        return true;
    }

    public static void dropMobEquips(World world, EntityLivingBase entity) {
        List<ItemStack> list = MobUtils.loopArmor(entity);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            ItemStack toDrop = list.get(i);
            if (toDrop.func_190916_E() != 0) continue;
            toDrop.func_190920_e(1);
            EntityItem ei = new EntityItem(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, toDrop);
            if (world.field_72995_K) continue;
            world.func_72838_d((Entity)ei);
        }
    }

    public static List<ItemStack> loopArmor(EntityLivingBase entity) {
        ArrayList<ItemStack> invList = new ArrayList<ItemStack>();
        EntityEquipmentSlot[] slots = new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
        for (int i = 0; i < slots.length; ++i) {
            ItemStack stack = entity.func_184582_a(slots[i]);
            if (stack.func_190926_b()) continue;
            invList.add(stack);
        }
        return invList;
    }

    public static boolean acceptableTargets(EntityLivingBase target) {
        if (target instanceof EntityPlayer) {
            return false;
        }
        if (target.func_70631_g_() && !(target instanceof EntityZombie)) {
            return false;
        }
        if (target instanceof IEntityOwnable && ((IEntityOwnable)target).func_70902_q() != null) {
            return false;
        }
        String entityBlacklist = target.getClass().getSimpleName();
        for (String toBlacklist : ConfigRFC.mobFolderBlacklist) {
            if (!toBlacklist.contains(entityBlacklist)) continue;
            return false;
        }
        return true;
    }
}

