/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.items.capabilities;

import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.helpers.TextHelper;
import com.bafomdad.realfilingcabinet.helpers.enums.FolderType;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class CapabilityFolder
implements INBTSerializable<NBTTagCompound> {
    private final ItemStack rootStack;
    private String displayName = "";
    private Object contents;
    private long count = 0L;
    private int remSize = 0;
    private int extractSize = 0;

    public CapabilityFolder(ItemStack rootStack) {
        this.rootStack = rootStack;
    }

    public void addTooltips(List<String> list) {
        if (this.isItemStack()) {
            ItemStack item = this.getItemStack();
            if (this.remSize != 0) {
                list.add(TextHelper.format(this.count) + " " + item.func_82833_r() + " [" + this.remSize + " / " + item.func_77958_k() + "]");
            } else {
                list.add(TextHelper.format(this.count) + " " + item.func_82833_r());
            }
        }
        if (this.isFluidStack()) {
            FluidStack fluid = this.getFluidStack();
            list.add(this.count + "mb " + fluid.getLocalizedName());
        }
        if (this.isEntity()) {
            list.add(TextHelper.format(this.count) + " " + this.displayName);
        }
    }

    public Object extract(long amount, boolean sim, boolean creative) {
        Object obj = null;
        if (this.count <= 0L) {
            return obj;
        }
        obj = ((IFolder)this.rootStack.func_77973_b()).extractFromFolder(this.rootStack, amount, sim, creative);
        return obj;
    }

    public Object insert(Object objects, boolean sim, boolean oreDict) {
        Object obj = ((IFolder)this.rootStack.func_77973_b()).insertIntoFolder(this.rootStack, objects, sim, oreDict);
        if (obj instanceof ItemStack) {
            return (ItemStack)obj;
        }
        return obj;
    }

    public boolean setContents(Object obj) {
        if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            this.displayName = stack.func_82833_r();
            this.contents = new ItemStack(stack.func_77973_b(), 1, stack.func_77952_i());
            this.count = stack.func_190916_E();
            ((IFolder)this.rootStack.func_77973_b()).setAdditionalData(this.rootStack, stack);
            return true;
        }
        if (obj instanceof FluidStack) {
            FluidStack fluid = (FluidStack)obj;
            this.displayName = fluid.getLocalizedName();
            this.contents = fluid.copy();
            this.count = fluid.amount;
            return true;
        }
        if (obj instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)obj;
            this.displayName = EntityRegistry.getEntry(entity.getClass()).getName();
            this.contents = entity.getClass();
            this.count = 1L;
            return true;
        }
        if (obj == null) {
            return false;
        }
        return false;
    }

    public Object getContents() {
        if (this.rootStack.func_77942_o() && this.rootStack.func_77978_p().func_74764_b("fileName")) {
            this.deserializeNBT(new NBTTagCompound());
        } else if (this.isFluidStack()) {
            return this.getFluidStack().copy();
        }
        return this.contents;
    }

    public void setTagCompound(NBTTagCompound tag) {
        ((ItemStack)this.contents).func_77982_d(tag);
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long value) {
        this.count = value;
    }

    public int getExtractSize() {
        return this.extractSize;
    }

    public void setExtractSize(int size) {
        this.extractSize = size;
    }

    public int getRemainingDurability() {
        return this.remSize;
    }

    public int setRemainingDurability(int value) {
        this.remSize = value;
        return this.remSize;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean hasItemTag() {
        return this.getItemStack().func_77942_o();
    }

    public boolean isItemStack() {
        return this.contents instanceof ItemStack;
    }

    public boolean isFluidStack() {
        return this.contents instanceof FluidStack;
    }

    public boolean isBlock() {
        return this.contents instanceof IBlockState;
    }

    public boolean isEntity() {
        return this.contents instanceof Class && EntityLivingBase.class.isAssignableFrom((Class)this.contents);
    }

    public Class<EntityLivingBase> getEntityClass() {
        return this.isEntity() ? (Class)this.contents : null;
    }

    public EntityLivingBase getEntity(World world) {
        return this.isEntity() ? (EntityLivingBase)EntityList.func_191304_a((Class)((Class)this.contents), (World)world) : null;
    }

    public ItemStack getItemStack() {
        return this.isItemStack() ? (ItemStack)this.contents : ItemStack.field_190927_a;
    }

    public FluidStack getFluidStack() {
        return this.isFluidStack() ? (FluidStack)this.contents : null;
    }

    public IBlockState getBlock() {
        return this.isBlock() ? (IBlockState)this.contents : Blocks.field_150350_a.func_176223_P();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.getContents() == null) {
            nbt.func_74774_a("folderType", (byte)0);
        } else if (this.isItemStack()) {
            nbt.func_74774_a("folderType", (byte)1);
            nbt.func_74782_a("objectData", (NBTBase)this.getItemStack().func_77955_b(new NBTTagCompound()));
        } else if (this.isFluidStack()) {
            nbt.func_74774_a("folderType", (byte)3);
            nbt.func_74782_a("objectData", (NBTBase)this.getFluidStack().writeToNBT(new NBTTagCompound()));
        } else if (this.isEntity()) {
            nbt.func_74774_a("folderType", (byte)4);
            nbt.func_74778_a("objectData", EntityList.func_191306_a((Class)((Class)this.contents)).toString());
        }
        nbt.func_74772_a("folderSize", this.count);
        nbt.func_74768_a("folderRem", this.remSize);
        nbt.func_74768_a("folderExtractSize", this.extractSize);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (this.rootStack.func_77942_o() && this.rootStack.func_77978_p().func_74764_b("fileName")) {
            Class entity;
            NBTTagCompound rootTag = this.rootStack.func_77978_p();
            String fName = rootTag.func_74779_i("fileName");
            int fMeta = rootTag.func_74762_e("fileMeta");
            this.count = rootTag.func_74763_f("fileSize");
            this.remSize = rootTag.func_74762_e("leftoverSize");
            NBTTagCompound tags = rootTag.func_74775_l("itemTagCompound");
            rootTag.func_82580_o("fileName");
            rootTag.func_82580_o("fileMeta");
            rootTag.func_82580_o("fileSize");
            rootTag.func_82580_o("leftoverSize");
            rootTag.func_82580_o("itemTagCompound");
            this.displayName = fName;
            if (this.rootStack.func_77952_i() == FolderType.FLUID.ordinal()) {
                Fluid fluid = FluidRegistry.getFluid((String)fName);
                if (fluid != null) {
                    this.contents = new FluidStack(fluid, 1);
                } else {
                    Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(fName));
                    if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                        this.contents = new FluidStack(FluidRegistry.WATER, 1);
                    } else if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                        this.contents = new FluidStack(FluidRegistry.LAVA, 1);
                    }
                }
                return;
            }
            Item item = Item.func_111206_d((String)fName);
            if (item != null && item != Items.field_190931_a) {
                this.contents = new ItemStack(item, 1, fMeta);
                if (!tags.func_82582_d()) {
                    ((ItemStack)this.contents).func_77982_d(tags);
                }
                return;
            }
            Block block = Block.func_149684_b((String)fName);
            if (block != null && block != Blocks.field_150350_a) {
                this.contents = block.func_176203_a(fMeta);
            }
            if ((entity = EntityList.getClass((ResourceLocation)new ResourceLocation(fName))) != null || EntityLivingBase.class.isAssignableFrom(entity)) {
                this.contents = entity;
            }
            return;
        }
        if (this.rootStack.func_77942_o() && this.rootStack.func_77978_p().func_74764_b("folderCap")) {
            nbt = this.rootStack.func_77978_p().func_74775_l("folderCap");
        }
        byte type = nbt.func_74771_c("folderType");
        switch (type) {
            case 0: {
                this.displayName = "";
                this.contents = null;
                this.count = 0L;
                this.remSize = 0;
                break;
            }
            case 1: {
                this.contents = new ItemStack(nbt.func_74775_l("objectData"));
                this.displayName = ((ItemStack)this.contents).func_82833_r();
                break;
            }
            case 3: {
                this.contents = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("objectData"));
                if (this.contents == null) break;
                this.displayName = ((FluidStack)this.contents).getLocalizedName();
                break;
            }
            case 4: {
                this.contents = EntityList.getClass((ResourceLocation)new ResourceLocation(nbt.func_74779_i("objectData")));
                if (this.contents == null) break;
                this.displayName = EntityRegistry.getEntry(this.getEntityClass()).getName();
            }
        }
        this.count = nbt.func_74763_f("folderSize");
        this.remSize = nbt.func_74762_e("folderRem");
        this.extractSize = nbt.func_74764_b("folderExtractSize") ? nbt.func_74762_e("folderExtractSize") : 0;
    }
}

