/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.items;

import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.api.ISubModel;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileFilingCabinet;
import com.bafomdad.realfilingcabinet.helpers.UpgradeHelper;
import com.bafomdad.realfilingcabinet.helpers.enums.FolderType;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemAbstractFolder;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityFolder;
import com.bafomdad.realfilingcabinet.utils.EnderUtils;
import com.bafomdad.realfilingcabinet.utils.FluidUtils;
import com.bafomdad.realfilingcabinet.utils.FolderUtils;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFolder
extends ItemAbstractFolder
implements ISubModel,
IFolder {
    public ItemStack getContainerItem(ItemStack stack) {
        ItemStack item = ItemStack.field_190927_a;
        CapabilityFolder cap = FolderUtils.get(stack).getCap();
        if (cap == null) {
            return item;
        }
        long count = FolderUtils.get(stack).getFileSize();
        long extract = 0L;
        if (count > 0L && cap.isItemStack()) {
            extract = Math.min((long)cap.getItemStack().func_77976_d(), count);
        }
        item = stack.func_77946_l();
        if (stack.func_77952_i() == FolderType.DURA.ordinal() && count == 0L) {
            FolderUtils.get(item).setRemainingDurability(0);
        }
        FolderUtils.get(item).remove(extract);
        FolderUtils.get(item).setExtractSize(-((int)extract));
        return item;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.getContainerItem(stack).func_190926_b();
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "_" + FolderType.values()[stack.func_77952_i()].toString().toLowerCase();
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack folder = player.func_184586_b(hand);
        EnumActionResult ear = this.placeObject(folder, player, world, pos, hand, side, hitX, hitY, hitZ);
        if (ear != EnumActionResult.SUCCESS) {
            RayTraceResult rtr = this.func_77621_a(world, player, true);
            if (rtr == null) {
                return ear;
            }
            if (rtr.field_72313_a == RayTraceResult.Type.BLOCK && FluidUtils.doDrain(world, player, folder, rtr.func_178782_a(), side)) {
                return EnumActionResult.SUCCESS;
            }
        }
        return ear;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, slot, isSelected);
        if (world.field_72995_K) {
            return;
        }
        if (stack.func_77952_i() == FolderType.ENDER.ordinal()) {
            if (!stack.func_77942_o() || stack.func_77942_o() && !stack.func_77978_p().func_74764_b("RFC_slotindex")) {
                return;
            }
            TileFilingCabinet tile = EnderUtils.getCachedTile(stack);
            if (tile == null || UpgradeHelper.getUpgrade(tile, "TAG_enderUpgrade").isEmpty()) {
                FolderUtils.get(stack).setFileSize(0L);
                return;
            }
            if (tile != null) {
                EnderUtils.syncToFolder(stack);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSubModels(Item item) {
        for (int i = 0; i < FolderType.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + FolderType.values()[i].toString().toLowerCase(), "inventory"));
        }
    }

    @Override
    public ItemStack getEmptyFolder(ItemStack stack) {
        switch (stack.func_77952_i()) {
            case 0: {
                return new ItemStack(RFCItems.EMPTYFOLDER, 1, 0);
            }
            case 2: {
                return new ItemStack(RFCItems.EMPTYFOLDER, 1, 1);
            }
            case 3: {
                return new ItemStack(RFCItems.EMPTYFOLDER, 1, 2);
            }
            case 4: {
                return new ItemStack(RFCItems.EMPTYFOLDER, 1, 3);
            }
            case 5: {
                return new ItemStack(RFCItems.EMPTYFOLDER, 1, 4);
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void setAdditionalData(ItemStack folder, Object toSet) {
        if (toSet instanceof ItemStack) {
            ItemStack stack = (ItemStack)toSet;
            if (folder.func_77952_i() == FolderType.DURA.ordinal()) {
                FolderUtils.get(folder).setRemainingDurability(stack.func_77952_i());
            }
            if (folder.func_77952_i() == FolderType.NBT.ordinal()) {
                FolderUtils.get(folder).setTagCompound(stack.func_77978_p());
            }
        }
    }

    @Override
    public EnumActionResult placeObject(ItemStack folder, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return FolderType.values()[folder.func_77952_i()].placeObject(folder, player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public Object insertIntoFolder(ItemStack folder, Object toInsert, boolean simulate, boolean oreDict) {
        return FolderType.values()[folder.func_77952_i()].insert(FolderUtils.get(folder).getCap(), toInsert, simulate, oreDict);
    }

    @Override
    public Object extractFromFolder(ItemStack folder, long amount, boolean simulate, boolean creative) {
        return FolderType.values()[folder.func_77952_i()].extract(FolderUtils.get(folder).getCap(), amount, simulate, creative);
    }
}

